/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator.reporter;

import com.jenkins.testresultsaggregator.data.Aggregated;
import com.jenkins.testresultsaggregator.data.ImagesMap;
import com.jenkins.testresultsaggregator.helper.Colors;
import com.jenkins.testresultsaggregator.helper.Helper;
import com.jenkins.testresultsaggregator.helper.LocalMessages;
import hudson.FilePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import java.util.Set;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.XMLOutput;
import org.xml.sax.SAXException;

public class HTMLReporter {
    public static final String FOLDER = "html";
    private static final String OVERVIEW_FILE = "index.html";
    private static final String REPORT = "htmlreport.jelly";
    private PrintStream logger;
    private FilePath workspace;

    public HTMLReporter(PrintStream logger, FilePath workspace) {
        this.logger = logger;
        this.workspace = workspace;
    }

    public FilePath createOverview(Aggregated aggregated, List<LocalMessages> columns, String theme, boolean showGroups) throws JellyException, SAXException, IOException, InterruptedException {
        this.logger.print(LocalMessages.GENERATE.toString() + " " + LocalMessages.HTML_REPORT.toString());
        FilePath directory = Helper.createFolder(this.workspace, FOLDER);
        FilePath file = Helper.createFile(directory, OVERVIEW_FILE);
        JellyContext context = new JellyContext();
        context.setVariable("name", (Object)"Test Result Aggregator");
        context.setVariable("showGroups", (Object)showGroups);
        context.setVariable("columns", columns);
        context.setVariable("aggregated", (Object)aggregated);
        context.setVariable("theme", (Object)theme);
        context.setVariable("headerColor", (Object)Colors.htmlHEADER());
        context.setVariable("footerColor", (Object)Colors.htmlFOOTER());
        context.setVariable("footerTextColor", (Object)Colors.htmlFOOTERTEXT());
        context.setVariable("lineSeperatorcolor", (Object)Colors.htmlLINESEPERATOR());
        XMLOutput xmlOutput = XMLOutput.createXMLOutput((OutputStream)file.write());
        URL template = HTMLReporter.class.getResource("/htmlreport.jelly");
        JellyContext jellyContext = context.runScript(template, xmlOutput);
        xmlOutput.endDocument();
        xmlOutput.flush();
        xmlOutput.close();
        jellyContext.clear();
        this.copyImages(directory);
        this.logger.println(LocalMessages.FINISHED.toString() + " " + LocalMessages.HTML_REPORT.toString());
        return file;
    }

    private void copyImages(FilePath directory) throws IOException, InterruptedException {
        Set<String> setImageID = ImagesMap.getImages().keySet();
        for (String contentId : setImageID) {
            this.copyStream(ImagesMap.getImages().get(contentId).getSourceInPlugin(), ImagesMap.getImages().get(contentId).getFileName(), directory);
        }
    }

    protected void copyStream(String sourceFile, String destinationFile, FilePath directory) throws IOException, InterruptedException {
        InputStream inputUrl = HTMLReporter.class.getResource(sourceFile).openStream();
        Helper.createFile(directory, destinationFile).copyFrom(inputUrl);
    }
}

