/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator.helper;

import com.jenkins.testresultsaggregator.TestResultsAggregatorTestResultBuildAction;
import com.jenkins.testresultsaggregator.data.Aggregated;
import com.jenkins.testresultsaggregator.helper.Helper;
import hudson.model.Run;

public class TestResultHistoryUtil {
    private TestResultHistoryUtil() {
    }

    public static Aggregated getTestResults(Run<?, ?> owner) {
        if (owner != null) {
            if (owner.getAction(TestResultsAggregatorTestResultBuildAction.class) != null) {
                return ((TestResultsAggregatorTestResultBuildAction)owner.getAction(TestResultsAggregatorTestResultBuildAction.class)).getResult();
            }
            return new Aggregated();
        }
        return null;
    }

    public static Aggregated getPreviousBuildTestResults(Run<?, ?> owner) {
        Run previousBuild = owner.getPreviousCompletedBuild();
        if (previousBuild != null && previousBuild.getAction(TestResultsAggregatorTestResultBuildAction.class) != null) {
            return ((TestResultsAggregatorTestResultBuildAction)previousBuild.getAction(TestResultsAggregatorTestResultBuildAction.class)).getResult();
        }
        return new Aggregated();
    }

    public static String toSummary(TestResultsAggregatorTestResultBuildAction action) {
        Run run = action.run;
        Aggregated previousResult = TestResultHistoryUtil.getPreviousBuildTestResults(run);
        int prevFailed = previousResult.getFailedJobs() + previousResult.getKeepFailJobs();
        int prevUnstable = previousResult.getUnstableJobs() + previousResult.getKeepUnstableJobs();
        int prevSucces = previousResult.getSuccessJobs() + previousResult.getFixedJobs();
        int prevAborted = previousResult.getAbortedJobs();
        int prevRunning = previousResult.getRunningJobs();
        int prevTotal = prevFailed + prevUnstable + prevSucces + prevAborted + prevRunning;
        Aggregated result = action.getResult();
        int total = result.getAbortedJobs() + result.getFailedJobs() + result.getKeepFailJobs() + result.getRunningJobs() + result.getSuccessJobs() + result.getFixedJobs() + result.getUnstableJobs() + result.getKeepUnstableJobs();
        return "<ul>" + Helper.diff(prevTotal, total, "Total Jobs ", true) + Helper.diff(prevFailed, result.getFailedJobs() + result.getKeepFailJobs(), "Failed Jobs ", true) + Helper.diff(prevUnstable, result.getUnstableJobs() + result.getKeepUnstableJobs(), "Unstable Jobs ", true) + Helper.diff(prevAborted, result.getAbortedJobs(), "Aborted Jobs ", true) + Helper.diff(prevRunning, result.getRunningJobs(), "Running Jobs ", true) + "</ul>";
    }

    public static String toSummaryTest(TestResultsAggregatorTestResultBuildAction action) {
        int prevFailed = 0;
        int prevUnstable = 0;
        int prevSucces = 0;
        int prevTotal = 0;
        Run run = action.run;
        Aggregated previousResult = TestResultHistoryUtil.getPreviousBuildTestResults(run);
        if (previousResult != null && previousResult.getResults() != null) {
            prevFailed = previousResult.getResults().getFail();
            prevUnstable = previousResult.getResults().getSkip();
            prevSucces = previousResult.getResults().getPass();
            prevTotal = previousResult.getResults().getTotal();
        }
        Aggregated result = action.getResult();
        return "<ul>" + Helper.diff(prevTotal, result.getResults().getTotal(), "Total Tests ", true) + Helper.diff(prevFailed, result.getResults().getFail(), "Failed Tests ", true) + Helper.diff(prevUnstable, result.getResults().getSkip(), "Aborted Tests ", true) + Helper.diff(prevSucces, result.getResults().getPass(), "Success Tests ", true) + "</ul>";
    }
}

