/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator.helper;

import com.jenkins.testresultsaggregator.data.Aggregated;
import com.jenkins.testresultsaggregator.data.Data;
import com.jenkins.testresultsaggregator.data.Job;
import com.jenkins.testresultsaggregator.data.JobInfo;
import com.jenkins.testresultsaggregator.data.Results;
import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ResultsParser {
    public Aggregated parse(FilePath[] paths) {
        if (null == paths) {
            return new Aggregated();
        }
        Aggregated finalResults = new Aggregated();
        finalResults.setResults(new Results());
        for (FilePath path : paths) {
            File file = new File(path.getRemote());
            if (!file.isFile()) continue;
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(file);
                doc.getDocumentElement().normalize();
                NodeList nList = doc.getElementsByTagName("AGGREGATED");
                if (nList == null || nList.getLength() != 1) continue;
                Node aggregated = nList.item(0);
                Node results = null;
                Node jobs = null;
                for (int i = 0; i < aggregated.getChildNodes().getLength(); ++i) {
                    if (aggregated.getChildNodes().item(i).getNodeType() != 1) continue;
                    if ("RESULTS".equalsIgnoreCase(aggregated.getChildNodes().item(i).getNodeName())) {
                        results = aggregated.getChildNodes().item(i);
                        continue;
                    }
                    if (!"JOBS".equalsIgnoreCase(aggregated.getChildNodes().item(i).getNodeName())) continue;
                    jobs = aggregated.getChildNodes().item(i);
                }
                this.readResults(finalResults, results);
                this.readJobs(finalResults, jobs);
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                // empty catch block
            }
        }
        return finalResults;
    }

    private int getInteger(Node currentNodeResults) {
        try {
            return Integer.parseInt(currentNodeResults.getTextContent());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private String getString(Node currentNodeResults) {
        try {
            return currentNodeResults.getTextContent();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void readResults(Aggregated finalResults, Node results) {
        if (results != null) {
            for (int i = 0; i < results.getChildNodes().getLength(); ++i) {
                Node currentNodeResults = results.getChildNodes().item(i);
                if (currentNodeResults.getNodeType() != 1 || currentNodeResults.getNodeName().startsWith("#")) continue;
                if (currentNodeResults.getNodeName().equalsIgnoreCase("ABORTED")) {
                    finalResults.setAbortedJobs(this.getInteger(currentNodeResults));
                    continue;
                }
                if (currentNodeResults.getNodeName().equalsIgnoreCase("FAILED")) {
                    finalResults.setFailedJobs(this.getInteger(currentNodeResults));
                    continue;
                }
                if (currentNodeResults.getNodeName().equalsIgnoreCase("KEEPFAILLING")) {
                    finalResults.setKeepFailJobs(this.getInteger(currentNodeResults));
                    continue;
                }
                if (currentNodeResults.getNodeName().equalsIgnoreCase("RUNNING")) {
                    finalResults.setRunningJobs(this.getInteger(currentNodeResults));
                    continue;
                }
                if (currentNodeResults.getNodeName().equalsIgnoreCase("SUCCESS")) {
                    finalResults.setSuccessJobs(this.getInteger(currentNodeResults));
                    continue;
                }
                if (currentNodeResults.getNodeName().equalsIgnoreCase("FIXED")) {
                    finalResults.setFixedJobs(this.getInteger(currentNodeResults));
                    continue;
                }
                if (currentNodeResults.getNodeName().equalsIgnoreCase("UNSTABLE")) {
                    finalResults.setUnstableJobs(this.getInteger(currentNodeResults));
                    continue;
                }
                if (currentNodeResults.getNodeName().equalsIgnoreCase("KEEPUNSTABLE")) {
                    finalResults.setKeepUnstableJobs(this.getInteger(currentNodeResults));
                    continue;
                }
                if (currentNodeResults.getNodeName().equalsIgnoreCase("TEST_TOTAL")) {
                    finalResults.getResults().setTotal(this.getInteger(currentNodeResults));
                    continue;
                }
                if (currentNodeResults.getNodeName().equalsIgnoreCase("TEST_SUCCESS")) {
                    finalResults.getResults().setPass(this.getInteger(currentNodeResults));
                    continue;
                }
                if (currentNodeResults.getNodeName().equalsIgnoreCase("TEST_SKIPPED")) {
                    finalResults.getResults().setSkip(this.getInteger(currentNodeResults));
                    continue;
                }
                if (!currentNodeResults.getNodeName().equalsIgnoreCase("TEST_FAILED")) continue;
                finalResults.getResults().setFail(this.getInteger(currentNodeResults));
            }
        }
    }

    private void readJobs(Aggregated finalResults, Node jobs) {
        if (jobs != null) {
            ArrayList<Job> dataJobs = new ArrayList<Job>();
            ArrayList<Data> data = new ArrayList<Data>();
            data.add(new Data("", dataJobs));
            finalResults.setData(data);
            for (int i = 0; i < jobs.getChildNodes().getLength(); ++i) {
                Node currentNodeResults = jobs.getChildNodes().item(i);
                if (!"JOB".equalsIgnoreCase(currentNodeResults.getNodeName())) continue;
                Job dataJob = new Job("", "");
                dataJobs.add(dataJob);
                dataJob.setResults(new Results(null, null));
                dataJob.setJobInfo(new JobInfo());
                for (int j = 0; j < currentNodeResults.getChildNodes().getLength(); ++j) {
                    Node jobResults = currentNodeResults.getChildNodes().item(j);
                    if (jobResults.getNodeName().startsWith("#")) continue;
                    if (jobResults.getNodeName().equalsIgnoreCase("NAME")) {
                        dataJob.setJobName(this.getString(jobResults));
                        continue;
                    }
                    if (jobResults.getNodeName().equalsIgnoreCase("STATUS")) {
                        dataJob.getResults().setCurrentResult(this.getString(jobResults));
                        continue;
                    }
                    if (jobResults.getNodeName().equalsIgnoreCase("URL")) {
                        try {
                            dataJob.getJobInfo().setUrl(new URL(this.getString(jobResults)));
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (jobResults.getNodeName().equalsIgnoreCase("TEST_SUCCESS")) {
                        dataJob.getResults().setPass(this.getInteger(jobResults));
                        continue;
                    }
                    if (jobResults.getNodeName().equalsIgnoreCase("TEST_SKIPPED")) {
                        dataJob.getResults().setSkip(this.getInteger(jobResults));
                        continue;
                    }
                    if (jobResults.getNodeName().equalsIgnoreCase("TEST_FAILED")) {
                        dataJob.getResults().setFail(this.getInteger(jobResults));
                        continue;
                    }
                    if (jobResults.getNodeName().equalsIgnoreCase("TEST_TOTAL")) {
                        dataJob.getResults().setTotal(this.getInteger(jobResults));
                        continue;
                    }
                    if (jobResults.getNodeName().equalsIgnoreCase("CC_PACKAGES")) {
                        dataJob.getResults().setCcPackages(this.getInteger(jobResults));
                        continue;
                    }
                    if (jobResults.getNodeName().equalsIgnoreCase("CC_FILES")) {
                        dataJob.getResults().setCcFiles(this.getInteger(jobResults));
                        continue;
                    }
                    if (jobResults.getNodeName().equalsIgnoreCase("CC_CLASSES")) {
                        dataJob.getResults().setCcClasses(this.getInteger(jobResults));
                        continue;
                    }
                    if (jobResults.getNodeName().equalsIgnoreCase("CC_METHODS")) {
                        dataJob.getResults().setCcMethods(this.getInteger(jobResults));
                        continue;
                    }
                    if (jobResults.getNodeName().equalsIgnoreCase("CC_LINES")) {
                        dataJob.getResults().setCcLines(this.getInteger(jobResults));
                        continue;
                    }
                    if (!jobResults.getNodeName().equalsIgnoreCase("CC_CONDITIONALS")) continue;
                    dataJob.getResults().setCcConditions(this.getInteger(jobResults));
                }
            }
        }
    }
}

