/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator.helper;

import com.google.common.base.Strings;
import com.jenkins.testresultsaggregator.data.JobStatus;
import com.jenkins.testresultsaggregator.data.Results;
import com.jenkins.testresultsaggregator.helper.Colors;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;

public class Helper {
    public static String encodeValue(String value) throws UnsupportedEncodingException, MalformedURLException {
        return URLEncoder.encode(value, "UTF-8").replace("+", "%20").trim();
    }

    public static String getTimeStamp(String timeStamp) {
        if (Strings.isNullOrEmpty((String)timeStamp)) {
            return "";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss:SSS");
        LocalDateTime date = LocalDateTime.parse(timeStamp, formatter);
        return date.toString();
    }

    public static String getTimeStamp(String outOfDateResults, String timeStamp) {
        if (Strings.isNullOrEmpty((String)timeStamp)) {
            return "";
        }
        int outOfDate = Integer.parseInt(outOfDateResults) * 3600;
        LocalDateTime today = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss:SSS");
        LocalDateTime date = LocalDateTime.parse(timeStamp, formatter);
        Duration d = Duration.between(date, today);
        long currentHours = d.getSeconds() / 3600L;
        long currentMin = d.getSeconds() / 60L;
        long bDours = currentHours % 24L;
        long bDays = currentHours / 24L;
        if (d.getSeconds() > (long)outOfDate) {
            if (bDays > 0L) {
                return Helper.colorize(bDays + "d:" + bDours + "h ago", Colors.FAILED);
            }
            return Helper.colorize(bDours + "h ago", Colors.FAILED);
        }
        if (bDays > 0L) {
            if (bDays == 1L) {
                return bDays + "d:" + bDours + "h ago";
            }
            return bDays + "d:" + bDours + "h ago";
        }
        if (bDours == 0L) {
            return currentMin + "m ago";
        }
        return currentHours + "h ago";
    }

    public static String getNumber(int value) {
        if (value < 0) {
            return Integer.toString(value);
        }
        if (value > 0) {
            return Integer.toString(value);
        }
        return "";
    }

    public static String urlNumberofChanges(String url, String number) {
        if (!number.isEmpty()) {
            return "<a href = '" + url + "' ><font color='" + Colors.htmlJOB_NAME_URL() + "'>" + number + "</font></a>";
        }
        return "";
    }

    public static String colorizeResultStatus(String result) {
        if (JobStatus.SUCCESS.name().equals(result)) {
            return Helper.colorize(result, Colors.SUCCESS);
        }
        if (JobStatus.FAILURE.name().equals(result)) {
            return Helper.colorize(result, Colors.FAILED);
        }
        if (JobStatus.STILL_FAILING.name().equals(result)) {
            return Helper.colorize(result, Colors.FAILED);
        }
        if (JobStatus.FIXED.name().equals(result)) {
            return Helper.colorize(result, Colors.SUCCESS);
        }
        if (JobStatus.UNSTABLE.name().equals(result)) {
            return Helper.colorize(result, Colors.UNSTABLE);
        }
        if (JobStatus.ABORTED.name().equals(result)) {
            return Helper.colorize(result, Colors.ABORTED);
        }
        if (JobStatus.STILL_UNSTABLE.name().equals(result)) {
            return Helper.colorize(result, Colors.UNSTABLE);
        }
        if (JobStatus.RUNNING.name().equals(result)) {
            return Helper.colorize(result, Colors.RUNNING);
        }
        return result;
    }

    public static Double countPercentage(Results results) {
        if (results != null && results.getTotal() != 0) {
            try {
                String percentage = Helper.singDoubleSingle((double)(results.getPass() + results.getSkip()) * 100.0 / (double)results.getTotal());
                if (percentage.equals("100")) {
                    return 100.0;
                }
                double percentageDouble = 0.0;
                try {
                    percentageDouble = Double.parseDouble(percentage);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return percentageDouble;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1.0;
    }

    public static String countPercentage(int pass, int total) {
        return Helper.countPercentageD(pass, total).toString();
    }

    public static Double countPercentageD(int pass, int total) {
        Results results = new Results();
        results.setPass(pass);
        results.setSkip(0);
        results.setTotal(total);
        return Helper.countPercentage(results);
    }

    public static String colorizePercentage(Double percentageDouble, Integer fontSize, String jobStatus) {
        Color color = null;
        String percentageString = "";
        if (JobStatus.RUNNING.toString().equalsIgnoreCase(jobStatus)) {
            color = Colors.RUNNING;
        }
        percentageString = percentageDouble >= 100.0 ? "100" : (percentageDouble == 0.0 ? "0" : percentageDouble.toString());
        if (color == null) {
            color = percentageDouble == 100.0 ? Colors.SUCCESS : (percentageDouble >= 95.0 ? Colors.UNSTABLE : Colors.FAILED);
        }
        return Helper.colorize(percentageString + "%", color, fontSize);
    }

    private static String singDoubleSingle(double value) {
        if (value == 0.0) {
            return "0";
        }
        DecimalFormat df = new DecimalFormat("#.##");
        df.setRoundingMode(RoundingMode.DOWN);
        if (Math.abs(value) < 0.005) {
            return "";
        }
        if (Math.abs(value) == 0.0) {
            return "";
        }
        if (value < 0.0 || value > 0.0) {
            return df.format(value);
        }
        return "";
    }

    public static FilePath createFolder(FilePath filePath, String folder) throws IOException, InterruptedException {
        FilePath fp;
        if (filePath.isRemote()) {
            VirtualChannel channel = filePath.getChannel();
            if (filePath.child(folder).exists()) {
                filePath.child(folder).deleteRecursive();
            }
            fp = new FilePath(channel, filePath.child(folder).getRemote());
        } else {
            if (filePath.child(folder).exists()) {
                filePath.child(folder).deleteRecursive();
            }
            fp = new FilePath(new File(filePath.getRemote(), folder));
        }
        fp.mkdirs();
        return fp;
    }

    public static FilePath createFile(FilePath filePath, String filename) throws IOException, InterruptedException {
        FilePath fp;
        if (filePath.isRemote()) {
            VirtualChannel channel = filePath.getChannel();
            fp = new FilePath(channel, filePath.getRemote() + "/" + filename);
        } else {
            fp = new FilePath(new File(filePath.getRemote() + "/" + filename));
        }
        return fp;
    }

    public static String diff(long prev, long curr, boolean list) {
        return Helper.diff(prev, curr, null, list);
    }

    public static String diff(long prev, long curr, String name) {
        return Helper.diff(prev, curr, name, null, false, false);
    }

    public static String diff(long prev, long curr, String name, boolean list) {
        return Helper.diff(prev, curr, name, null, list, false);
    }

    public static String diff(long prev, long curr, String name, Color color, boolean list, boolean percentage) {
        String namePrefix = null;
        String text = null;
        if (Strings.isNullOrEmpty((String)name)) {
            name = "";
        }
        namePrefix = !Strings.isNullOrEmpty((String)name) ? name + ": " : name;
        text = color != null ? Helper.colorize(namePrefix, color) : namePrefix;
        String percentageIcon = "";
        if (percentage) {
            percentageIcon = "%";
        }
        if (list) {
            if (prev == curr) {
                return "<li>" + text + curr + "</li>";
            }
            if (prev < curr) {
                return "<li>" + text + curr + Helper.colorize("(+" + (curr - prev) + ")", Colors.BLACK) + "</li>";
            }
            return "<li>" + text + curr + Helper.colorize("(-" + (prev - curr) + ")", Colors.BLACK) + "</li>";
        }
        if (prev == curr) {
            if (curr == 0L) {
                return "";
            }
            return text + Helper.colorize(curr, Colors.BLACK) + percentageIcon;
        }
        if (prev < curr) {
            if (curr == 0L) {
                return text + Helper.colorize("+" + (curr - prev), Colors.BLACK) + percentageIcon;
            }
            if (prev == 0L) {
                return text + Helper.colorize(curr, color) + percentageIcon;
            }
            return text + Helper.colorize(curr, color) + Helper.colorize("(+" + (curr - prev) + ")", Colors.BLACK) + percentageIcon;
        }
        if (curr == 0L) {
            return text + Helper.colorize("-" + (prev - curr), Colors.BLACK) + percentageIcon;
        }
        return text + Helper.colorize(curr, color) + Helper.colorize("(-" + (prev - curr) + ")", Colors.BLACK) + percentageIcon;
    }

    private static String colorize(String text, Color color) {
        return Helper.colorize(text, color, null);
    }

    private static String colorize(String text, Color color, Integer font) {
        if (color == null) {
            color = Colors.BLACK;
        }
        if (font != null) {
            if (!Strings.isNullOrEmpty((String)text)) {
                return "<font style='font-size: " + font + "px; color:" + Colors.html(color) + "'>" + text + "</font>";
            }
        } else if (!Strings.isNullOrEmpty((String)text)) {
            return "<font style='color:" + Colors.html(color) + "'>" + text + "</font>";
        }
        return text;
    }

    private static String colorize(Long text, Color color) {
        if (color == null || text == 0L) {
            color = Colors.BLACK;
        }
        return "<font color='" + Colors.html(color) + "'>" + text + "</font>";
    }

    public static String duration(Long millis) {
        Duration duration = Duration.of(millis, ChronoUnit.MILLIS);
        long durationInSeconds = duration.getSeconds();
        long hours = durationInSeconds / 3600L;
        long minutes = durationInSeconds % 3600L / 60L;
        String hoursString = "";
        String minString = "";
        hoursString = hours < 10L ? "0" + hours : Long.toString(hours);
        minString = minutes < 10L ? "0" + minutes : Long.toString(minutes);
        if (hours == 0L && minutes == 0L) {
            return null;
        }
        if (hours == 0L) {
            return "00:" + minString;
        }
        return hoursString + ":" + minString;
    }

    public static String calculateStatus(String currentResult, String previousResult) {
        if (JobStatus.SUCCESS.name().equals(currentResult) && JobStatus.SUCCESS.name().equals(previousResult)) {
            return JobStatus.SUCCESS.name();
        }
        if (JobStatus.SUCCESS.name().equals(currentResult) && JobStatus.FAILURE.name().equals(previousResult)) {
            return JobStatus.FIXED.name();
        }
        if (JobStatus.SUCCESS.name().equals(currentResult) && JobStatus.UNSTABLE.name().equals(previousResult)) {
            return JobStatus.FIXED.name();
        }
        if (JobStatus.SUCCESS.name().equals(currentResult) && previousResult == null) {
            return JobStatus.SUCCESS.name();
        }
        if (JobStatus.UNSTABLE.name().equals(currentResult) && JobStatus.UNSTABLE.name().equals(previousResult)) {
            return JobStatus.STILL_UNSTABLE.name();
        }
        if (JobStatus.FAILURE.name().equals(currentResult) && JobStatus.FAILURE.name().equals(previousResult)) {
            return JobStatus.STILL_FAILING.name();
        }
        if (JobStatus.FAILURE.name().equals(currentResult)) {
            return JobStatus.FAILURE.name();
        }
        if (JobStatus.UNSTABLE.name().equals(currentResult)) {
            return JobStatus.UNSTABLE.name();
        }
        if (JobStatus.RUNNING.name().equals(currentResult)) {
            return JobStatus.RUNNING.name();
        }
        if (JobStatus.ABORTED.name().equals(currentResult)) {
            return JobStatus.ABORTED.name();
        }
        if (JobStatus.SUCCESS.name().equals(currentResult)) {
            return JobStatus.SUCCESS.name();
        }
        return currentResult;
    }

    public static Double resolvePercentage(String percentage) {
        if (Strings.isNullOrEmpty((String)percentage)) {
            return -1.0;
        }
        try {
            Double doublePercentage = Double.valueOf(percentage);
            if (doublePercentage >= 100.0) {
                return 100.0;
            }
            return doublePercentage;
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0;
        }
    }
}

