/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator.helper;

import com.jenkins.testresultsaggregator.TestResultsAggregatorTestResultBuildAction;
import com.jenkins.testresultsaggregator.helper.Colors;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.ChartUtil;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="BarRenderer subclasses do not seem to need to override it")
public class GraphHelper {
    private GraphHelper() {
    }

    public static void redirectWhenGraphUnsupported(StaplerResponse rsp, StaplerRequest req) throws IOException {
        rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
    }

    public static JFreeChart createChartJob(final StaplerRequest req, CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"Jobs Count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StackedAreaRenderer2 ar = new StackedAreaRenderer2(){

            public String generateURL(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                String path = req.getParameter("rel");
                return (path == null ? "" : path) + label.getRun().getNumber() + "/" + "reports" + "/";
            }

            public String generateToolTip(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                TestResultsAggregatorTestResultBuildAction report = (TestResultsAggregatorTestResultBuildAction)label.getRun().getAction(TestResultsAggregatorTestResultBuildAction.class);
                if (report == null) {
                    return "";
                }
                if ("Success".equalsIgnoreCase(dataset.getRowKey(row).toString()) || "Fixed".equalsIgnoreCase(dataset.getRowKey(row).toString())) {
                    return String.valueOf(report.getSuccess() + report.getFixed()) + " " + "Success";
                }
                if ("Aborted".equalsIgnoreCase(dataset.getRowKey(row).toString())) {
                    return String.valueOf(report.getAborted()) + " " + "Aborted";
                }
                if ("Failed".equalsIgnoreCase(dataset.getRowKey(row).toString()) || "KeepFailling".equalsIgnoreCase(dataset.getRowKey(row).toString())) {
                    return String.valueOf(report.getFailCount() + report.getFailKeepCount()) + " " + "Failed";
                }
                if ("Running".equalsIgnoreCase(dataset.getRowKey(row).toString())) {
                    return String.valueOf(report.getRunning()) + " " + "Running";
                }
                if ("Unstable".equalsIgnoreCase(dataset.getRowKey(row).toString()) || "KeepUnstable".equalsIgnoreCase(dataset.getRowKey(row).toString())) {
                    return String.valueOf(report.getUnstableCount() + report.getUnstableKeepCount()) + " " + "Unstable";
                }
                return "";
            }
        };
        plot.setRenderer((CategoryItemRenderer)ar);
        for (int i = 0; i < dataset.getRowCount(); ++i) {
            if ("Success".equalsIgnoreCase(dataset.getRowKey(i).toString()) || "Fixed".equalsIgnoreCase(dataset.getRowKey(i).toString())) {
                ar.setSeriesPaint(i, (Paint)Colors.SUCCESS);
                continue;
            }
            if ("Aborted".equalsIgnoreCase(dataset.getRowKey(i).toString())) {
                ar.setSeriesPaint(i, (Paint)Colors.ABORTED);
                continue;
            }
            if ("Failed".equalsIgnoreCase(dataset.getRowKey(i).toString()) || "KeepFailling".equalsIgnoreCase(dataset.getRowKey(i).toString())) {
                ar.setSeriesPaint(i, (Paint)Colors.FAILED);
                continue;
            }
            if ("Running".equalsIgnoreCase(dataset.getRowKey(i).toString())) {
                ar.setSeriesPaint(i, (Paint)Colors.RUNNING);
                continue;
            }
            if (!"Unstable".equalsIgnoreCase(dataset.getRowKey(i).toString()) && !"KeepUnstable".equalsIgnoreCase(dataset.getRowKey(i).toString())) continue;
            ar.setSeriesPaint(i, (Paint)Colors.UNSTABLE);
        }
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public static JFreeChart createChartTests(final StaplerRequest req, CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"Test Count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StackedAreaRenderer2 ar = new StackedAreaRenderer2(){

            public String generateURL(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                String path = req.getParameter("rel");
                return (path == null ? "" : path) + label.getRun().getNumber() + "/" + "reports" + "/";
            }

            public String generateToolTip(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                TestResultsAggregatorTestResultBuildAction report = (TestResultsAggregatorTestResultBuildAction)label.getRun().getAction(TestResultsAggregatorTestResultBuildAction.class);
                if (report == null) {
                    return "";
                }
                if ("Success".equalsIgnoreCase(dataset.getRowKey(row).toString())) {
                    return String.valueOf(report.getSuccessTTests()) + " " + "Success";
                }
                if ("Failed".equalsIgnoreCase(dataset.getRowKey(row).toString())) {
                    return String.valueOf(report.getFailedTTests()) + " " + "Failed";
                }
                if ("Unstable".equalsIgnoreCase(dataset.getRowKey(row).toString())) {
                    return String.valueOf(report.getSkippedTTests()) + " " + "Unstable";
                }
                return "";
            }
        };
        plot.setRenderer((CategoryItemRenderer)ar);
        for (int i = 0; i < dataset.getRowCount(); ++i) {
            if ("Success".equalsIgnoreCase(dataset.getRowKey(i).toString())) {
                ar.setSeriesPaint(i, (Paint)Colors.SUCCESS);
                continue;
            }
            if ("Failed".equalsIgnoreCase(dataset.getRowKey(i).toString())) {
                ar.setSeriesPaint(i, (Paint)Colors.FAILED);
                continue;
            }
            if (!"Unstable".equalsIgnoreCase(dataset.getRowKey(i).toString())) continue;
            ar.setSeriesPaint(i, (Paint)Colors.UNSTABLE);
        }
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 2.0));
        return chart;
    }
}

