/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator.helper;

import com.google.common.base.Strings;
import com.jenkins.testresultsaggregator.data.BuildInfo;
import com.jenkins.testresultsaggregator.data.ChangeSet;
import com.jenkins.testresultsaggregator.data.CoberturaCoverage;
import com.jenkins.testresultsaggregator.data.Data;
import com.jenkins.testresultsaggregator.data.Job;
import com.jenkins.testresultsaggregator.data.JobInfo;
import com.jenkins.testresultsaggregator.data.JobListDTO;
import com.jenkins.testresultsaggregator.data.JobStatus;
import com.jenkins.testresultsaggregator.data.ReportJob;
import com.jenkins.testresultsaggregator.data.Results;
import com.jenkins.testresultsaggregator.helper.Deserialize;
import com.jenkins.testresultsaggregator.helper.Helper;
import com.jenkins.testresultsaggregator.helper.Http;
import com.jenkins.testresultsaggregator.helper.LocalMessages;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Collector {
    public static final String JOB = "job";
    public static final String API_JSON_URL = "api/json";
    public static final String API_JSON_JOBS = "api/json?tree=jobs[name,url]";
    public static final String API_JSON_COBERTURA = "cobertura/api/json?depth=2";
    public static final String API_JSON_JACOCO = "api/json?depth=1";
    public static final String LASTBUILD = "lastBuild";
    public static final String CHANGES = "changes";
    public static final String FAILCOUNT = "failCount";
    public static final String SKIPCOUNT = "skipCount";
    public static final String TOTALCOUNT = "totalCount";
    public static final String JACOCO_BRANCH = "branchCoverage";
    public static final String JACOCO_CLASS = "classCoverage";
    public static final String JACOCO_LINES = "lineCoverage";
    public static final String JACOCO_METHODS = "methodCoverage";
    public static final String JACOCO_INSTRUCTION = "instructionCoverage";
    public static final String SONAR_URL = "sonarqubeDashboardUrl";
    public static final int MAXRETRIES = 3;
    private String username;
    private Secret password;
    private String jenkinsUrl;
    private PrintStream logger;

    public Collector(PrintStream logger, String username, Secret password, String jenkinsUrl) {
        this.username = username;
        this.password = password;
        this.jenkinsUrl = jenkinsUrl;
        this.logger = logger;
    }

    public void collectResults(List<Data> dataJob, boolean compareWithPreviousRun) throws InterruptedException {
        ArrayList<Job> allDataJobDTO = new ArrayList<Job>();
        for (Data temp : dataJob) {
            if (temp.getJobs() == null || temp.getJobs().isEmpty()) continue;
            allDataJobDTO.addAll(temp.getJobs());
        }
        ReportThread[] threads = new ReportThread[allDataJobDTO.size()];
        int index = 0;
        for (Job tempDataJobDTO : allDataJobDTO) {
            threads[index] = new ReportThread(tempDataJobDTO, compareWithPreviousRun);
            ++index;
        }
        index = 0;
        for (ReportThread thread : threads) {
            thread.start();
            if (++index % 3 != 0) continue;
            Thread.sleep(500L);
        }
        for (ReportThread thread : threads) {
            thread.join(30000L);
        }
    }

    private String authenticationString() {
        if (!Strings.isNullOrEmpty((String)this.username) && !Strings.isNullOrEmpty((String)this.password.getPlainText())) {
            byte[] encode = (this.username + ":" + this.password.getPlainText()).getBytes(Charset.forName("UTF-8"));
            return Base64.getEncoder().encodeToString(encode);
        }
        return null;
    }

    public String getAPIConnection() throws IOException {
        URL jobUrlAPI = new URL(this.jenkinsUrl + "/" + API_JSON_URL);
        return Http.get(jobUrlAPI, this.authenticationString());
    }

    public void delay(int millisec) {
        try {
            Thread.sleep(millisec);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public JobListDTO getJobList() {
        return this.getJobList(this.jenkinsUrl);
    }

    public JobListDTO getJobList(String url) {
        JobListDTO jobListDTO = null;
        for (int retries = 1; jobListDTO == null && retries <= 3; ++retries) {
            try {
                URL jobUrlAPI = new URL(url + "/" + API_JSON_JOBS);
                jobListDTO = (JobListDTO)Deserialize.initializeObjectMapper().readValue(Http.get(jobUrlAPI, this.authenticationString()), JobListDTO.class);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (jobListDTO != null) continue;
            this.delay(2000);
        }
        return jobListDTO;
    }

    public List<Data> resolveJobs(List<Data> validatedData) {
        List<JobListDTO.JobDTO> allJobs = this.getAllJenkinsJobs();
        for (Data group : validatedData) {
            if (group.getJobs() == null || group.getJobs().isEmpty()) continue;
            block1: for (Job jobInGroup : group.getJobs()) {
                for (JobListDTO.JobDTO temp : allJobs) {
                    if (!jobInGroup.getJobName().equalsIgnoreCase(temp.getName())) continue;
                    jobInGroup.setUrl(temp.getUrl());
                    continue block1;
                }
            }
        }
        return validatedData;
    }

    public List<JobListDTO.JobDTO> getAllJenkinsJobs() {
        ArrayList<JobListDTO.JobDTO> returnList = new ArrayList<JobListDTO.JobDTO>();
        JobListDTO original = this.getJobList();
        for (JobListDTO.JobDTO tempInOriginalList : original.getJobs()) {
            if (!Strings.isNullOrEmpty((String)tempInOriginalList.getClassString()) && tempInOriginalList.getClassString().endsWith(".Folder")) {
                JobListDTO listTemp = this.getJobList(tempInOriginalList.getUrl());
                for (JobListDTO.JobDTO temp : listTemp.getJobs()) {
                    if (!Strings.isNullOrEmpty((String)temp.getClassString()) && temp.getClassString().endsWith(".Folder")) continue;
                    temp.setFolder(tempInOriginalList.getName());
                    returnList.add(temp);
                }
                continue;
            }
            tempInOriginalList.setFolder("root");
            returnList.add(tempInOriginalList);
        }
        return returnList;
    }

    public JobInfo getJobInfo(Job job) {
        JobInfo jobInfo = null;
        for (int retries = 1; jobInfo == null && retries <= 3; ++retries) {
            try {
                URL jobUrlAPI = null;
                jobUrlAPI = Strings.isNullOrEmpty((String)job.getUrl()) ? new URL(this.jenkinsUrl + "/" + JOB + "/" + Helper.encodeValue(job.getJobName()) + "/" + API_JSON_URL) : new URL(job.getUrl() + "/" + API_JSON_URL);
                jobInfo = (JobInfo)Deserialize.initializeObjectMapper().readValue(Http.get(jobUrlAPI, this.authenticationString()), JobInfo.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (jobInfo != null) continue;
            this.delay(2000);
        }
        return jobInfo;
    }

    public BuildInfo getJobInfoLastBuild(Job dataJobDTO) {
        return this.getJobInfoWithUrl(dataJobDTO.getJobInfo().getUrl() + "/" + LASTBUILD + "/" + API_JSON_JACOCO);
    }

    public BuildInfo getJobInfo(String url) {
        return this.getJobInfoWithUrl(url + "/" + API_JSON_JACOCO);
    }

    private BuildInfo getJobInfoWithUrl(String url) {
        BuildInfo buildInfo = null;
        for (int retries = 1; buildInfo == null && retries <= 3; ++retries) {
            try {
                URL jobUrlAPILastBuild = new URL(url);
                buildInfo = (BuildInfo)Deserialize.initializeObjectMapper().readValue(Http.get(jobUrlAPILastBuild, this.authenticationString()), BuildInfo.class);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (buildInfo != null) continue;
            this.delay(2000);
        }
        return buildInfo;
    }

    public CoberturaCoverage getCobertura(String url) {
        try {
            URL jobUrlAPILastBuild = new URL(url + "/" + API_JSON_COBERTURA);
            String reply = Http.get(jobUrlAPILastBuild, this.authenticationString());
            return (CoberturaCoverage)Deserialize.initializeObjectMapper().readValue(reply, CoberturaCoverage.class);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Results calculateResults(Job job, boolean compareWithPreviousRun) {
        if (job != null && job.getBuildInfo() != null) {
            Results results = new Results();
            results.setUrl(job.getJobInfo().getUrl().toString());
            results.setBuilding(job.getBuildInfo().getBuilding());
            results.setCurrentResult(job.getBuildInfo().getResult());
            results.setDescription(job.getBuildInfo().getDescription());
            results.setDuration(job.getBuildInfo().getDuration());
            results.setNumber(job.getBuildInfo().getNumber());
            results.setDuration(job.getBuildInfo().getDuration());
            if (job.getBuildInfo().getTimestamp() != null) {
                SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/YYYY HH:mm:ss:SSS");
                String dateFormatted = formatter.format(new Date(job.getBuildInfo().getTimestamp()));
                results.setTimestamp(dateFormatted);
            }
            boolean foundJacocoResults = false;
            boolean foundCoberturaResults = false;
            if (results.isBuilding()) {
                results.setCurrentResult(JobStatus.RUNNING.name());
            } else if (results.getCurrentResult() != null) {
                for (HashMap<Object, Object> temp : job.getBuildInfo().getActions()) {
                    Map tempMap;
                    if (temp.containsKey(FAILCOUNT)) {
                        results.setFail((Integer)temp.get(FAILCOUNT));
                    }
                    if (temp.containsKey(SKIPCOUNT)) {
                        results.setSkip((Integer)temp.get(SKIPCOUNT));
                    }
                    if (temp.containsKey(TOTALCOUNT)) {
                        results.setTotal((Integer)temp.get(TOTALCOUNT));
                    }
                    if (temp.containsKey(JACOCO_BRANCH)) {
                        tempMap = (Map)temp.get(JACOCO_BRANCH);
                        results.setCcConditions((Integer)tempMap.get("percentage"));
                        foundJacocoResults = true;
                    }
                    if (temp.containsKey(JACOCO_CLASS)) {
                        tempMap = (Map)temp.get(JACOCO_CLASS);
                        results.setCcClasses((Integer)tempMap.get("percentage"));
                        foundJacocoResults = true;
                    }
                    if (temp.containsKey(JACOCO_LINES)) {
                        tempMap = (Map)temp.get(JACOCO_LINES);
                        results.setCcLines((Integer)tempMap.get("percentage"));
                        foundJacocoResults = true;
                    }
                    if (temp.containsKey(JACOCO_METHODS)) {
                        tempMap = (Map)temp.get(JACOCO_METHODS);
                        results.setCcMethods((Integer)tempMap.get("percentage"));
                        foundJacocoResults = true;
                    }
                    if (!temp.containsKey(SONAR_URL)) continue;
                    results.setSonarUrl((String)temp.get(SONAR_URL));
                }
                if (!foundJacocoResults) {
                    foundCoberturaResults = this.coberturaCoverage(job, results);
                }
                results.setPass(results.getTotal() - Math.abs(results.getFail()) - Math.abs(results.getSkip()));
                results.setPercentage(Helper.countPercentage(results));
                if (compareWithPreviousRun && job.getBuildInfo().getPreviousBuild() != null) {
                    BuildInfo jenkinsPreviousBuildDTO = null;
                    if (job.getSavedJobUrl() == null) {
                        jenkinsPreviousBuildDTO = this.getJobInfo(job.getBuildInfo().getPreviousBuild().getUrl().toString());
                        if (jenkinsPreviousBuildDTO != null) {
                            jenkinsPreviousBuildDTO.setUrl(job.getBuildInfo().getPreviousBuild().getUrl().toString());
                            job.setUpdated("");
                        }
                    } else {
                        String currentUrl = job.getJobInfo().getLastBuild().getUrl().toString();
                        if (currentUrl.equals(job.getSavedJobUrl())) {
                            jenkinsPreviousBuildDTO = this.getJobInfo(job.getBuildInfo().getPreviousBuild().getUrl().toString());
                            if (jenkinsPreviousBuildDTO != null) {
                                jenkinsPreviousBuildDTO.setUrl(job.getBuildInfo().getPreviousBuild().getUrl().toString());
                                job.setUpdated("");
                            }
                        } else {
                            jenkinsPreviousBuildDTO = this.getJobInfo(job.getSavedJobUrl());
                            if (jenkinsPreviousBuildDTO != null) {
                                jenkinsPreviousBuildDTO.setUrl(job.getSavedJobUrl());
                                job.setUpdated("");
                            }
                        }
                    }
                    int previouslyFail = 0;
                    int previouslyPass = 0;
                    int previouslySkip = 0;
                    if (jenkinsPreviousBuildDTO != null) {
                        results.setPreviousResult(jenkinsPreviousBuildDTO.getResult());
                        for (HashMap<Object, Object> temp : jenkinsPreviousBuildDTO.getActions()) {
                            Map tempMap;
                            if (temp.containsKey(FAILCOUNT)) {
                                results.setFailDif((Integer)temp.get(FAILCOUNT));
                                previouslyFail += ((Integer)temp.get(FAILCOUNT)).intValue();
                            }
                            if (temp.containsKey(SKIPCOUNT)) {
                                results.setSkipDif((Integer)temp.get(SKIPCOUNT));
                                previouslySkip += ((Integer)temp.get(SKIPCOUNT)).intValue();
                            }
                            if (temp.containsKey(TOTALCOUNT)) {
                                results.setTotalDif((Integer)temp.get(TOTALCOUNT));
                                previouslyPass += ((Integer)temp.get(TOTALCOUNT)).intValue();
                            }
                            if (!foundJacocoResults) continue;
                            if (temp.containsKey(JACOCO_BRANCH)) {
                                tempMap = (Map)temp.get(JACOCO_BRANCH);
                                results.setCcConditionsDif((Integer)tempMap.get("percentage"));
                            }
                            if (temp.containsKey(JACOCO_CLASS)) {
                                tempMap = (Map)temp.get(JACOCO_CLASS);
                                results.setCcClassesDif((Integer)tempMap.get("percentage"));
                            }
                            if (temp.containsKey(JACOCO_LINES)) {
                                tempMap = (Map)temp.get(JACOCO_LINES);
                                results.setCcLinesDif((Integer)tempMap.get("percentage"));
                            }
                            if (!temp.containsKey(JACOCO_METHODS)) continue;
                            tempMap = (Map)temp.get(JACOCO_METHODS);
                            results.setCcMethodsDif((Integer)tempMap.get("percentage"));
                        }
                        if (foundCoberturaResults) {
                            this.coberturaCoverage(jenkinsPreviousBuildDTO.getUrl(), results);
                        }
                        this.calculateChangeSets(job, results, jenkinsPreviousBuildDTO);
                    }
                    results.setPassDif(previouslyPass - Math.abs(previouslyFail) - Math.abs(previouslySkip));
                }
            }
            return results;
        }
        return null;
    }

    private void calculateChangeSets(Job job, Results results, BuildInfo jenkinsPreviousBuildDTO) {
        if (job.getBuildInfo().getPreviousBuild().getUrl().toString().equalsIgnoreCase(jenkinsPreviousBuildDTO.getUrl())) {
            if (job.getBuildInfo().getChangeSets() != null) {
                int changes = 0;
                for (ChangeSet tempI : job.getBuildInfo().getChangeSets()) {
                    changes += tempI.getItems().size();
                }
                results.setNumberOfChanges(changes);
            } else {
                results.setNumberOfChanges(0);
            }
            results.setChangesUrl(job.getJobInfo().getUrl() + "/" + job.getBuildInfo().getNumber() + "/" + CHANGES);
        } else {
            int changes = 0;
            for (int i = jenkinsPreviousBuildDTO.getNumber() + 1; i <= job.getBuildInfo().getNumber(); ++i) {
                BuildInfo temp = this.getJobInfo(job.getJobInfo().getUrl().toString() + i);
                if (temp == null || temp.getChangeSets() == null) continue;
                for (ChangeSet tempI : temp.getChangeSets()) {
                    changes += tempI.getItems().size();
                }
            }
            results.setNumberOfChanges(changes);
            results.setChangesUrl(job.getJobInfo().getUrl() + "/" + job.getBuildInfo().getNumber() + "/" + CHANGES);
        }
    }

    private boolean coberturaCoverage(Job job, Results results) {
        return this.coberturaCoverage(job.getJobInfo().getUrl().toString() + "/" + job.getBuildInfo().getNumber(), results);
    }

    private boolean coberturaCoverage(String url, Results results) {
        CoberturaCoverage cobertura = this.getCobertura(url);
        if (cobertura != null) {
            Double packages = 0.0;
            Double files = 0.0;
            Double classes = 0.0;
            Double methods = 0.0;
            Double lines = 0.0;
            Double conditions = 0.0;
            for (CoberturaCoverage.Element tempElement : cobertura.getResults().getElements()) {
                if ("Packages".equalsIgnoreCase(tempElement.getName())) {
                    packages = tempElement.getRatio();
                }
                if ("Files".equalsIgnoreCase(tempElement.getName())) {
                    files = tempElement.getRatio();
                }
                if ("Classes".equalsIgnoreCase(tempElement.getName())) {
                    classes = tempElement.getRatio();
                }
                if ("Methods".equalsIgnoreCase(tempElement.getName())) {
                    methods = tempElement.getRatio();
                }
                if ("Lines".equalsIgnoreCase(tempElement.getName())) {
                    lines = tempElement.getRatio();
                }
                if (!"Conditionals".equalsIgnoreCase(tempElement.getName())) continue;
                conditions = tempElement.getRatio();
            }
            results.setCcPackages(packages.intValue());
            results.setCcFiles(files.intValue());
            results.setCcClasses(classes.intValue());
            results.setCcMethods(methods.intValue());
            results.setCcLines(lines.intValue());
            results.setCcConditions(conditions.intValue());
            return true;
        }
        return true;
    }

    public class ReportThread
    extends Thread {
        Job job;
        boolean compareWithPreviousRun;

        public ReportThread(Job job, boolean compareWithPreviousRun) {
            this.job = job;
            this.compareWithPreviousRun = compareWithPreviousRun;
        }

        @Override
        public void run() {
            this.job.setJobInfo(Collector.this.getJobInfo(this.job));
            if (this.job.getJobInfo() == null) {
                this.job.setJobInfo(new JobInfo());
                this.job.setResults(new Results(JobStatus.NOT_FOUND.name(), null));
                this.job.getResults().setUrl(null);
                this.job.setReport(new ReportJob());
                Collector.this.logger.println(LocalMessages.COLLECT_DATA.toString() + " '" + this.job.getJobName() + "' " + LocalMessages.JOB_NOT_FOUND.toString());
            } else if (!this.job.getJobInfo().getBuildable()) {
                String tempUrl = this.job.getJobInfo().getUrl().toString();
                this.job.setJobInfo(new JobInfo());
                this.job.setResults(new Results(JobStatus.DISABLED.name(), null));
                this.job.getResults().setUrl(tempUrl);
                this.job.setReport(new ReportJob());
                Collector.this.logger.println(LocalMessages.COLLECT_DATA.toString() + " '" + this.job.getJobName() + "' " + LocalMessages.JOB_IS_DISABLED.toString());
            } else if (this.job.getJobInfo() != null) {
                this.job.setBuildInfo(Collector.this.getJobInfoLastBuild(this.job));
                this.job.setResults(Collector.this.calculateResults(this.job, this.compareWithPreviousRun));
                Collector.this.logger.println(LocalMessages.COLLECT_DATA.toString() + " '" + this.job.getJobName() + "' " + LocalMessages.FINISHED.toString());
            } else {
                Collector.this.logger.println("...");
            }
        }
    }
}

