/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator.data;

import com.jenkins.testresultsaggregator.helper.Colors;
import com.jenkins.testresultsaggregator.helper.Helper;
import java.io.Serializable;

public class Results
implements Serializable {
    private static final long serialVersionUID = 3491974223667L;
    private String name;
    private int pass;
    private int passDif;
    private int fail;
    private int failDif;
    private int skip;
    private int skipDif;
    private int total;
    private int totalDif;
    private int ccPackages;
    private int ccPackagesDif;
    private int ccFiles;
    private int ccFilesDif;
    private int ccClasses;
    private int ccClassesDif;
    private int ccMethods;
    private int ccMethodsDif;
    private int ccLines;
    private int ccLinesDif;
    private int ccConditions;
    private int ccConditionsDif;
    private String currentResult;
    private String previousResult;
    private String status;
    private int number;
    private Long duration;
    private String description;
    private boolean building;
    private String url;
    private String sonarUrl;
    private int calculatedNumberOfChanges;
    private int numberOfChanges;
    private String changesUrl;
    private String timestamp;
    private Double percentage;

    public Results() {
        this.setPass(0);
        this.setPassDif(0);
        this.setFail(0);
        this.setFailDif(0);
        this.setSkip(0);
        this.setSkipDif(0);
        this.setTotal(0);
        this.setTotalDif(0);
    }

    public Results(String currentResult, String previousResult) {
        this.setCurrentResult(currentResult);
        this.setPreviousResult(previousResult);
        this.setPass(0);
        this.setPassDif(0);
        this.setFail(0);
        this.setFailDif(0);
        this.setSkip(0);
        this.setSkipDif(0);
        this.setTotal(0);
        this.setTotalDif(0);
    }

    public Results addResults(Results resultsDTO) {
        this.setTotal(this.getTotal() + resultsDTO.getTotal());
        this.setTotalDif(this.getTotalDif() + resultsDTO.getTotalDif());
        this.setFail(this.getFail() + resultsDTO.getFail());
        this.setFailDif(this.getFailDif() + resultsDTO.getFailDif());
        this.setPass(this.getPass() + resultsDTO.getPass());
        this.setPassDif(this.getPassDif() + resultsDTO.getPassDif());
        this.setSkip(this.getSkip() + resultsDTO.getSkip());
        this.setSkipDif(this.getSkipDif() + resultsDTO.getSkipDif());
        return this;
    }

    public int getPass() {
        return this.pass;
    }

    public void setPass(int pass) {
        this.pass = pass;
    }

    public int getPassDif() {
        return this.passDif;
    }

    public void setPassDif(int passDif) {
        this.passDif = passDif;
    }

    public int getFail() {
        return this.fail;
    }

    public void setFail(int fail) {
        this.fail = fail;
    }

    public int getFailDif() {
        return this.failDif;
    }

    public void setFailDif(int failDif) {
        this.failDif = failDif;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public int getSkipDif() {
        return this.skipDif;
    }

    public void setSkipDif(int skipDif) {
        this.skipDif = skipDif;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getTotalDif() {
        return this.totalDif;
    }

    public void setTotalDif(int totalDif) {
        this.totalDif = totalDif;
    }

    public String getCurrentResult() {
        return this.currentResult;
    }

    public void setCurrentResult(String currentResult) {
        this.currentResult = currentResult;
    }

    public String getPreviousResult() {
        return this.previousResult;
    }

    public void setPreviousResult(String previousResult) {
        this.previousResult = previousResult;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isBuilding() {
        return this.building;
    }

    public void setBuilding(boolean building) {
        this.building = building;
    }

    public int getNumberOfChanges() {
        return this.numberOfChanges;
    }

    public void setNumberOfChanges(int numberOfChanges) {
        this.numberOfChanges = numberOfChanges;
    }

    public String getChangesUrl() {
        return this.changesUrl;
    }

    public void setChangesUrl(String changesUrl) {
        this.changesUrl = changesUrl;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCalculatedPass() {
        return Helper.diff((long)this.getPassDif(), (long)this.getPass(), false);
    }

    public String getCalculatedTotal() {
        return Helper.diff((long)this.getTotalDif(), (long)this.getTotal(), false);
    }

    public String getCalculatedSkip() {
        return Helper.diff((long)this.getSkipDif(), (long)this.getSkip(), false);
    }

    public String getCalculatedFail() {
        return Helper.diff((long)this.getFailDif(), (long)this.getFail(), false);
    }

    public String getCalculatedFailColor() {
        return Helper.diff(this.getFailDif(), this.getFail(), null, Colors.FAILED, false, false);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(Double percentage) {
        this.percentage = percentage;
    }

    public String getStatus() {
        this.status = Helper.calculateStatus(this.currentResult, this.previousResult);
        return this.status;
    }

    public int getCalculatedNumberOfChanges() {
        return this.calculatedNumberOfChanges;
    }

    public void setCalculatedNumberOfChanges(int calculatedNumberOfChanges) {
        this.calculatedNumberOfChanges = calculatedNumberOfChanges;
    }

    public String getCalculatedCcPackage() {
        return Helper.diff((long)this.getCcPackagesDif(), (long)this.getCcPackages(), false);
    }

    public int getCcPackages() {
        return this.ccPackages;
    }

    public void setCcPackages(int ccPackages) {
        this.ccPackages = ccPackages;
    }

    public int getCcPackagesDif() {
        return this.ccPackagesDif;
    }

    public void setCcPackagesDif(int ccPackagesDif) {
        this.ccPackagesDif = ccPackagesDif;
    }

    public String getCalculatedCcFiles() {
        return Helper.diff((long)this.getCcFilesDif(), (long)this.getCcFiles(), false);
    }

    public int getCcFiles() {
        return this.ccFiles;
    }

    public void setCcFiles(int ccFiles) {
        this.ccFiles = ccFiles;
    }

    public int getCcFilesDif() {
        return this.ccFilesDif;
    }

    public void setCcFilesDif(int ccFilesDif) {
        this.ccFilesDif = ccFilesDif;
    }

    public String getCalculatedCcClasses() {
        return Helper.diff((long)this.getCcClassesDif(), (long)this.getCcClasses(), false);
    }

    public int getCcClasses() {
        return this.ccClasses;
    }

    public void setCcClasses(int ccClasses) {
        this.ccClasses = ccClasses;
    }

    public int getCcClassesDif() {
        return this.ccClassesDif;
    }

    public void setCcClassesDif(int ccClassesDif) {
        this.ccClassesDif = ccClassesDif;
    }

    public String getCalculatedCcMethods() {
        return Helper.diff((long)this.getCcMethodsDif(), (long)this.getCcMethods(), false);
    }

    public int getCcMethods() {
        return this.ccMethods;
    }

    public void setCcMethods(int ccMethods) {
        this.ccMethods = ccMethods;
    }

    public int getCcMethodsDif() {
        return this.ccMethodsDif;
    }

    public void setCcMethodsDif(int ccMethodsDif) {
        this.ccMethodsDif = ccMethodsDif;
    }

    public String getCalculatedCcLines() {
        return Helper.diff((long)this.getCcLinesDif(), (long)this.getCcLines(), false);
    }

    public int getCcLines() {
        return this.ccLines;
    }

    public void setCcLines(int ccLines) {
        this.ccLines = ccLines;
    }

    public int getCcLinesDif() {
        return this.ccLinesDif;
    }

    public void setCcLinesDif(int ccLinesDif) {
        this.ccLinesDif = ccLinesDif;
    }

    public String getCalculatedCcConditions() {
        return Helper.diff((long)this.getCcConditionsDif(), (long)this.getCcConditions(), false);
    }

    public int getCcConditions() {
        return this.ccConditions;
    }

    public void setCcConditions(int ccConditions) {
        this.ccConditions = ccConditions;
    }

    public int getCcConditionsDif() {
        return this.ccConditionsDif;
    }

    public void setCcConditionsDif(int ccConditionsDif) {
        this.ccConditionsDif = ccConditionsDif;
    }

    public String getSonarUrl() {
        return this.sonarUrl;
    }

    public void setSonarUrl(String sonarUrl) {
        this.sonarUrl = sonarUrl;
    }
}

