/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator.data;

import com.google.common.base.Strings;
import com.jenkins.testresultsaggregator.data.JobStatus;
import com.jenkins.testresultsaggregator.data.Results;
import com.jenkins.testresultsaggregator.helper.Colors;
import com.jenkins.testresultsaggregator.helper.GetEnumFromString;
import com.jenkins.testresultsaggregator.helper.Helper;
import java.io.Serializable;

public class ReportJob
implements Serializable {
    private static final long serialVersionUID = 3491366L;
    private String status;
    private String timestamp;
    private String total;
    private String pass;
    private String failed;
    private String failedColor;
    private String skipped;
    private String changes;
    private String reportURL;
    private String duration;
    private String description;
    private String parameters;
    private String percentage;
    private String sonarUrl;
    private String ccPackages;
    private String ccFiles;
    private String ccClasses;
    private String ccMethods;
    private String ccLines;
    private String ccConditions;

    public String calculateStatus(Results resultsDTO) {
        this.setStatus(Helper.calculateStatus(resultsDTO.getCurrentResult(), resultsDTO.getPreviousResult()));
        return this.getStatus();
    }

    private String fixStatusName(String jobStatus) {
        if (jobStatus != null) {
            return jobStatus.replace("_", " ");
        }
        return jobStatus;
    }

    public void calculateTimestamp(Results resultsDTO, String outOfDateResults) {
        if (Strings.isNullOrEmpty((String)outOfDateResults)) {
            this.setTimestamp(Helper.getTimeStamp(resultsDTO.getTimestamp()));
        } else {
            this.setTimestamp(Helper.getTimeStamp(outOfDateResults, resultsDTO.getTimestamp()));
        }
    }

    public void calculateTotal(Results resultsDTO) {
        if (resultsDTO != null) {
            this.setTotal(Helper.diff((long)resultsDTO.getTotalDif(), (long)resultsDTO.getTotal(), false));
        } else {
            this.setTotal("0");
        }
    }

    public void calculatePass(Results resultsDTO) {
        if (resultsDTO != null) {
            this.setPass(Helper.diff((long)resultsDTO.getPassDif(), (long)resultsDTO.getPass(), false));
        } else {
            this.setPass("0");
        }
    }

    public void calculateFailedColor(Results resultsDTO) {
        if (resultsDTO != null) {
            this.setFailedColor(Helper.diff(resultsDTO.getFailDif(), resultsDTO.getFail(), null, Colors.FAILED, false, false));
        } else {
            this.setFailedColor("0");
        }
    }

    public void calculateFailed(Results resultsDTO) {
        if (resultsDTO != null) {
            this.setFailed(Helper.diff((long)resultsDTO.getFailDif(), (long)resultsDTO.getFail(), false));
        } else {
            this.setFailed("0");
        }
    }

    public void calculateSkipped(Results resultsDTO) {
        if (resultsDTO != null) {
            this.setSkipped(Helper.diff((long)resultsDTO.getSkipDif(), (long)resultsDTO.getSkip(), false));
        } else {
            this.setSkipped("0");
        }
    }

    public String getStatus() {
        return this.status;
    }

    public JobStatus getStatusFromEnum() {
        return GetEnumFromString.get(JobStatus.class, this.status);
    }

    public String getStatusColor(boolean withLinktoResults) {
        if (withLinktoResults && this.getReportURL() != null) {
            return "<a href='" + this.getReportURL() + "' style='text-decoration:none;'>" + this.fixStatusName(Helper.colorizeResultStatus(this.status)) + "</a>";
        }
        return this.getStatusColor();
    }

    public String getStatusColor() {
        return this.fixStatusName(Helper.colorizeResultStatus(this.status));
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void calculateChanges(Results resultsDTO) {
        this.setChanges(Helper.urlNumberofChanges(resultsDTO.getChangesUrl(), Helper.getNumber(resultsDTO.getNumberOfChanges())));
    }

    public String getTotal(boolean withLinktoResults) {
        if (withLinktoResults) {
            if (!Strings.isNullOrEmpty((String)this.getTotal()) && !"0".equals(this.getTotal())) {
                return "<a href='" + this.getReportURL() + "' style='text-decoration:none;'>" + this.getTotal() + "</a>";
            }
            return "";
        }
        return this.total;
    }

    public String getTotal() {
        return this.total;
    }

    public void setTotal(String total) {
        this.total = total;
    }

    public String getPass(boolean withLinktoResults) {
        if (withLinktoResults) {
            if (!Strings.isNullOrEmpty((String)this.getPass()) && !"0".equals(this.getPass())) {
                return "<a href='" + this.getReportURL() + "' style='text-decoration:none;'>" + this.getPass() + "</a>";
            }
            return "";
        }
        return this.pass;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public String getFailed() {
        return this.failed;
    }

    public void setFailed(String failed) {
        this.failed = failed;
    }

    public String getSkipped(boolean withLinktoResults) {
        if (withLinktoResults) {
            if (!Strings.isNullOrEmpty((String)this.getSkipped()) && !"0".equals(this.getSkipped())) {
                return "<a href='" + this.getReportURL() + "' style='text-decoration:none;'>" + this.getSkipped() + "</a>";
            }
            return "";
        }
        return this.skipped;
    }

    public String getSkipped() {
        return this.skipped;
    }

    public void setSkipped(String skipped) {
        this.skipped = skipped;
    }

    public String getChanges() {
        return this.changes;
    }

    public void setChanges(String calculatedChanges) {
        this.changes = calculatedChanges;
    }

    public String getFailedColor(boolean withLinktoResults) {
        if (withLinktoResults) {
            if (!Strings.isNullOrEmpty((String)this.getFailedColor()) && !"0".equals(this.getFailedColor())) {
                return "<a href='" + this.getReportURL() + "' style='text-decoration:none;'>" + this.getFailedColor() + "</a>";
            }
            return "";
        }
        return this.failedColor;
    }

    public String getFailedColor() {
        return this.failedColor;
    }

    public void setFailedColor(String failedColor) {
        this.failedColor = failedColor;
    }

    public String getReportURL() {
        return this.reportURL;
    }

    public void setReportURL(String reportURL) {
        this.reportURL = reportURL;
    }

    public String calculateDuration(Long millis) {
        this.setDuration(Helper.duration(millis));
        return this.getDuration();
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String calculateDescription(String jobDescription) {
        this.setDescription(jobDescription);
        return this.getDescription();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public String calculatePercentage(Results results) {
        if (results.getCurrentResult().equalsIgnoreCase(JobStatus.ABORTED.name()) || results.getCurrentResult().equalsIgnoreCase(JobStatus.DISABLED.name()) || results.getCurrentResult().equalsIgnoreCase(JobStatus.NOT_FOUND.name()) || results.getCurrentResult().equalsIgnoreCase(JobStatus.RUNNING.name())) {
            this.setPercentage(null);
        } else {
            Double calculatedPercentage = Helper.countPercentage(results);
            if (calculatedPercentage > 0.0) {
                this.setPercentage(Double.toString(Helper.countPercentage(results)));
            } else {
                this.setPercentage(null);
            }
        }
        return this.percentage;
    }

    public String getPercentage(boolean withColor, boolean withLink) {
        if (withColor && !Strings.isNullOrEmpty((String)this.percentage)) {
            String temp = Helper.colorizePercentage(Double.valueOf(this.percentage), null, null);
            if (withLink) {
                return "<a href='" + this.getReportURL() + "' style='text-decoration:none;'>" + temp + "</a>";
            }
            return temp;
        }
        return this.percentage;
    }

    public void setPercentage(String percentage) {
        this.percentage = percentage;
    }

    public String calculateSonar(Results results) {
        if (!Strings.isNullOrEmpty((String)results.getSonarUrl())) {
            this.setSonarUrl("<a href='" + results.getSonarUrl() + "' style='text-decoration:none;'>Sonar</a>");
            return this.getSonarUrl();
        }
        return "";
    }

    public String getSonarUrl() {
        return this.sonarUrl;
    }

    public void setSonarUrl(String sonarUrl) {
        this.sonarUrl = sonarUrl;
    }

    public String calculateCCPackages(Results results) {
        this.setCcPackages(Helper.diff((long)results.getCcPackagesDif(), (long)results.getCcPackages(), false));
        return this.getCcPackages();
    }

    public String getCcPackages() {
        if (Strings.isNullOrEmpty((String)this.ccPackages)) {
            return this.ccPackages;
        }
        return this.ccPackages + "%";
    }

    public void setCcPackages(String ccPackages) {
        this.ccPackages = ccPackages;
    }

    public String calculateCCFiles(Results results) {
        this.setCcFiles(Helper.diff((long)results.getCcFilesDif(), (long)results.getCcFiles(), false));
        return this.getCcFiles();
    }

    public String getCcFiles() {
        if (Strings.isNullOrEmpty((String)this.ccFiles)) {
            return this.ccFiles;
        }
        return this.ccFiles + "%";
    }

    public void setCcFiles(String ccFiles) {
        this.ccFiles = ccFiles;
    }

    public String calculateCCClasses(Results results) {
        this.setCcClasses(Helper.diff((long)results.getCcClassesDif(), (long)results.getCcClasses(), false));
        return this.getCcClasses();
    }

    public String getCcClasses() {
        if (Strings.isNullOrEmpty((String)this.ccClasses)) {
            return this.ccClasses;
        }
        return this.ccClasses + "%";
    }

    public void setCcClasses(String ccClasses) {
        this.ccClasses = ccClasses;
    }

    public String calculateCCMethods(Results results) {
        this.setCcMethods(Helper.diff((long)results.getCcMethodsDif(), (long)results.getCcMethods(), false));
        return this.getCcMethods();
    }

    public String getCcMethods() {
        if (Strings.isNullOrEmpty((String)this.ccMethods)) {
            return this.ccMethods;
        }
        return this.ccMethods + "%";
    }

    public void setCcMethods(String ccMethods) {
        this.ccMethods = ccMethods;
    }

    public String calculateCCLines(Results results) {
        this.setCcLines(Helper.diff((long)results.getCcLinesDif(), (long)results.getCcLines(), false));
        return this.getCcLines();
    }

    public String getCcLines() {
        if (Strings.isNullOrEmpty((String)this.ccLines)) {
            return this.ccLines;
        }
        return this.ccLines + "%";
    }

    public void setCcLines(String ccLines) {
        this.ccLines = ccLines;
    }

    public String calculateCCConditions(Results results) {
        this.setCcConditions(Helper.diff((long)results.getCcConditionsDif(), (long)results.getCcConditions(), false));
        return this.getCcConditions();
    }

    public String getCcConditions() {
        if (Strings.isNullOrEmpty((String)this.ccConditions)) {
            return this.ccConditions;
        }
        return this.ccConditions + "%";
    }

    public void setCcConditions(String ccConditions) {
        this.ccConditions = ccConditions;
    }
}

