/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator.data;

import com.jenkins.testresultsaggregator.data.BuildDTO;
import com.jenkins.testresultsaggregator.data.ImagesMap;
import java.io.Serializable;
import java.net.URL;
import java.util.List;

public class JobInfo
implements Serializable {
    private static final long serialVersionUID = 74223666L;
    private URL url;
    private boolean buildable;
    private Boolean inQueue;
    private BuildDTO lastBuild;
    private BuildDTO lastCompletedBuild;
    private List<HealthReport> healthReport;

    public JobInfo() {
    }

    public JobInfo(URL url) {
        this.setUrl(url);
    }

    public boolean getBuildable() {
        return this.buildable;
    }

    public void setBuildable(boolean buildable) {
        this.buildable = buildable;
    }

    public BuildDTO getLastBuild() {
        return this.lastBuild;
    }

    public void setLastBuild(BuildDTO lastBuild) {
        this.lastBuild = lastBuild;
    }

    public BuildDTO getLastCompletedBuild() {
        return this.lastCompletedBuild;
    }

    public void setLastCompletedBuild(BuildDTO lastCompletedBuild) {
        this.lastCompletedBuild = lastCompletedBuild;
    }

    public Boolean getInQueue() {
        return this.inQueue;
    }

    public void setInQueue(Boolean inQueue) {
        this.inQueue = inQueue;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public List<HealthReport> getHealthReport() {
        return this.healthReport;
    }

    public String getHealthReport(boolean icon) {
        if (icon && this.healthReport != null) {
            for (HealthReport temp : this.healthReport) {
                if (!temp.getDescription().startsWith("Build stability")) continue;
                return ImagesMap.getImage(temp.getScore());
            }
        }
        return null;
    }

    public void setHealthReport(List<HealthReport> healthReport) {
        this.healthReport = healthReport;
    }

    public static class HealthReport
    implements Serializable {
        private static final long serialVersionUID = 742123666L;
        private int score;
        private String description;

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public int getScore() {
            return this.score;
        }

        public void setScore(int score) {
            this.score = score;
        }
    }
}

