/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator.data;

import com.google.common.base.Strings;
import com.jenkins.testresultsaggregator.data.BuildInfo;
import com.jenkins.testresultsaggregator.data.JobInfo;
import com.jenkins.testresultsaggregator.data.ReportJob;
import com.jenkins.testresultsaggregator.data.Results;
import com.jenkins.testresultsaggregator.helper.Colors;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class Job
extends AbstractDescribableImpl<Job>
implements Serializable {
    private static final long serialVersionUID = 34911974223666L;
    private String jobName;
    private String jobFriendlyName;
    private String folder;
    private String updated;
    private JobInfo jobInfo;
    private BuildInfo buildInfo;
    private Results results;
    private ReportJob report;
    private String savedUrl;
    private String url;

    @DataBoundConstructor
    public Job() {
    }

    public Job(String jobName, String jobFriendlyName) {
        this.setJobName(jobName);
        this.setJobFriendlyName(jobFriendlyName);
    }

    public String getJobName() {
        if (this.jobName != null) {
            return this.jobName.trim();
        }
        return this.jobName;
    }

    @DataBoundSetter
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobFriendlyName() {
        if (this.jobFriendlyName != null) {
            return this.jobFriendlyName.trim();
        }
        return this.jobFriendlyName;
    }

    @DataBoundSetter
    public void setJobFriendlyName(String jonFriendlyName) {
        this.jobFriendlyName = jonFriendlyName;
    }

    public JobInfo getJobInfo() {
        return this.jobInfo;
    }

    public void setJobInfo(JobInfo jobInfo) {
        this.jobInfo = jobInfo;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public void setBuildInfo(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
    }

    public Results getResults() {
        return this.results;
    }

    public void setResults(Results results) {
        this.results = results;
    }

    public String getJobNameFromFriendlyName() {
        if (Strings.isNullOrEmpty((String)this.jobFriendlyName)) {
            return this.jobName;
        }
        return this.jobFriendlyName;
    }

    public String getJobNameFromFriendlyName(boolean withLinktoResults) {
        if (withLinktoResults) {
            String reportUrl = null;
            reportUrl = this.results == null ? null : (Strings.isNullOrEmpty((String)this.results.getUrl()) ? null : this.results.getUrl());
            if (Strings.isNullOrEmpty(reportUrl) && this.jobInfo.getUrl() != null) {
                reportUrl = this.jobInfo.getUrl().toString();
            }
            return "<a href='" + reportUrl + "'><font color='" + Colors.htmlJOB_NAME_URL() + "'>" + this.getJobNameFromFriendlyName() + "</font></a>";
        }
        return this.getJobNameFromFriendlyName();
    }

    public ReportJob getReport() {
        return this.report;
    }

    public void setReport(ReportJob report) {
        this.report = report;
    }

    public String getSavedJobUrl() {
        return this.savedUrl;
    }

    public void setSavedJobUrl(String savedUrl) {
        this.savedUrl = savedUrl;
    }

    public String getUpdated() {
        return this.updated;
    }

    public void setUpdated(String updated) {
        this.updated = updated;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    @Extension
    public static class JobDescriptor
    extends Descriptor<Job> {
        public String getDisplayName() {
            return "";
        }
    }
}

