/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator.data;

import com.jenkins.testresultsaggregator.data.Job;
import com.jenkins.testresultsaggregator.data.ReportGroup;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class Data
extends AbstractDescribableImpl<Data>
implements Serializable {
    private static final long serialVersionUID = 3491974223666L;
    private String groupName;
    private List<Job> jobs;
    private ReportGroup reportGroup;

    @DataBoundConstructor
    public Data() {
    }

    public Data(String groupName, List<Job> jobs) {
        this.setGroupName(groupName);
        this.setJobs(jobs);
    }

    public String getGroupName() {
        if (this.groupName != null) {
            return this.groupName.trim();
        }
        return this.groupName;
    }

    @DataBoundSetter
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public List<Job> getJobs() {
        return this.jobs;
    }

    @DataBoundSetter
    public void setJobs(List<Job> jobs) {
        this.jobs = jobs;
    }

    public ReportGroup getReportGroup() {
        return this.reportGroup;
    }

    @DataBoundSetter
    public void setReportGroup(ReportGroup reportGroup) {
        this.reportGroup = reportGroup;
    }

    public Data copy() {
        Data dt = new Data();
        dt.setGroupName(this.groupName);
        dt.setReportGroup(this.reportGroup);
        dt.setJobs(new ArrayList<Job>(this.jobs));
        return dt;
    }

    @Extension
    public static class DataDescriptor
    extends Descriptor<Data> {
        public String getDisplayName() {
            return "";
        }
    }
}

