/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator.data;

import com.jenkins.testresultsaggregator.TestResultsAggregatorTestResultBuildAction;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TabulatedResult;
import hudson.tasks.test.TestResult;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class BaseResult
extends TabulatedResult
implements ModelObject,
Serializable {
    protected Run<?, ?> run;
    protected final String name;
    protected BaseResult parent;

    public BaseResult(String name) {
        this.name = name;
    }

    @Exported(visibility=999)
    public String getName() {
        return this.name;
    }

    public BaseResult getParent() {
        return this.parent;
    }

    public void setParent(BaseResult parent) {
        this.parent = parent;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public void setRun(Run<?, ?> run) {
        this.run = run;
    }

    public String getTitle() {
        return this.getName();
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getUpUrl() {
        Jenkins j = Jenkins.getInstance();
        return j != null ? j.getRootUrl() + this.run.getUrl() + this.getId() : "";
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        for (TestResult result : this.getChildren()) {
            if (!token.equals(result.getName())) continue;
            return result;
        }
        return null;
    }

    public AbstractTestResultAction getTestResultAction() {
        Run<?, ?> run = this.getRun();
        if (run != null) {
            return (AbstractTestResultAction)run.getAction(TestResultsAggregatorTestResultBuildAction.class);
        }
        return null;
    }

    public AbstractTestResultAction getParentAction() {
        return this.getTestResultAction();
    }

    public TestResult findCorrespondingResult(String id) {
        if (this.getId().equals(id) || id == null) {
            return this;
        }
        int sepIdx = id.indexOf(47);
        if (sepIdx < 0) {
            if (this.getSafeName().equals(id)) {
                return this;
            }
        } else {
            String currId = id.substring(0, sepIdx);
            if (!this.getSafeName().equals(currId)) {
                return null;
            }
            String childId = id.substring(sepIdx + 1);
            sepIdx = childId.indexOf(47);
            for (TestResult result : this.getChildren()) {
                if (sepIdx < 0 && childId.equals(result.getSafeName())) {
                    return result;
                }
                if (sepIdx <= 0 || !result.getSafeName().equals(childId.substring(0, sepIdx))) continue;
                return result.findCorrespondingResult(childId);
            }
        }
        return null;
    }

    public long getAge() {
        BaseResult result = (BaseResult)this.getPreviousResult();
        if (result == null) {
            return 1L;
        }
        return 1L + result.getAge();
    }
}

