/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator.data;

import com.google.common.base.Strings;
import com.jenkins.testresultsaggregator.data.BaseResult;
import com.jenkins.testresultsaggregator.data.Data;
import com.jenkins.testresultsaggregator.data.JobStatus;
import com.jenkins.testresultsaggregator.data.Results;
import com.jenkins.testresultsaggregator.helper.Colors;
import com.jenkins.testresultsaggregator.helper.Helper;
import hudson.model.Run;
import hudson.tasks.test.TestResult;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Aggregated
extends BaseResult {
    private List<Data> data;
    private Results results;
    private int runningJobs = 0;
    private int successJobs = 0;
    private int fixedJobs = 0;
    private int failedJobs = 0;
    private int keepFailJobs = 0;
    private int unstableJobs = 0;
    private int keepUnstableJobs = 0;
    private int abortedJobs = 0;
    private int disabledJobs = 0;
    private int totalJobs = 0;
    private Long totalDuration = 0L;
    private int totalNumberOfChanges = 0;
    private Run<?, ?> owner;

    public Aggregated() {
        super("reports");
    }

    public List<Data> getData() {
        return this.data;
    }

    public void setData(List<Data> data) {
        this.data = data;
    }

    public Results getResults() {
        return this.results;
    }

    public void setResults(Results results) {
        this.results = results;
    }

    public int getRunningJobs() {
        return this.runningJobs;
    }

    public void setRunningJobs(int runningJobs) {
        this.runningJobs = runningJobs;
    }

    public int getSuccessJobs() {
        return this.successJobs;
    }

    public void setSuccessJobs(int successJobs) {
        this.successJobs = successJobs;
    }

    public int getFailedJobs() {
        return this.failedJobs;
    }

    public void setFailedJobs(int countJobFailures) {
        this.failedJobs = countJobFailures;
    }

    public int getUnstableJobs() {
        return this.unstableJobs;
    }

    public void setUnstableJobs(int unstableJobs) {
        this.unstableJobs = unstableJobs;
    }

    public int getAbortedJobs() {
        return this.abortedJobs;
    }

    public void setAbortedJobs(int abortedJobs) {
        this.abortedJobs = abortedJobs;
    }

    public int getFixedJobs() {
        return this.fixedJobs;
    }

    public void setFixedJobs(int fixedJobs) {
        this.fixedJobs = fixedJobs;
    }

    public int getKeepFailJobs() {
        return this.keepFailJobs;
    }

    public void setKeepFailJobs(int keepFailJobs) {
        this.keepFailJobs = keepFailJobs;
    }

    public int getKeepUnstableJobs() {
        return this.keepUnstableJobs;
    }

    public void setKeepUnstableJobs(int keepUnstableJobs) {
        this.keepUnstableJobs = keepUnstableJobs;
    }

    @Override
    public Run<?, ?> getRun() {
        return this.owner;
    }

    @Override
    public void setRun(Run<?, ?> owner) {
        this.owner = owner;
    }

    public int getTotalJobs() {
        this.setTotalJobs(this.runningJobs + this.successJobs + this.fixedJobs + this.failedJobs + this.keepFailJobs + this.unstableJobs + this.keepUnstableJobs + this.abortedJobs);
        return this.totalJobs;
    }

    public void setTotalJobs(int totalJobs) {
        this.totalJobs = totalJobs;
    }

    public Collection<? extends TestResult> getChildren() {
        return null;
    }

    public boolean hasChildren() {
        return false;
    }

    public String getPercentageSummary(boolean withColor) {
        StringBuilder percentage = new StringBuilder("<br>");
        int fontSize = 12;
        String status = null;
        if (this.runningJobs > 0) {
            status = JobStatus.RUNNING.toString();
        }
        String jobPercentage = this.calculatePercentageOfJobs(false, fontSize, status);
        String testPercentage = this.calculatePercentage(false, fontSize, status);
        String fontColor = Colors.html(Color.gray);
        if (!Strings.isNullOrEmpty((String)jobPercentage)) {
            percentage.append(this.calculatePercentageOfJobs(withColor, fontSize, status));
            if (!Strings.isNullOrEmpty((String)testPercentage)) {
                percentage.append("<font style='font-size:" + (fontSize - 2) + "px;color:" + fontColor + "'> Jobs</font>").append("<br>");
            }
        }
        if (!Strings.isNullOrEmpty((String)testPercentage)) {
            percentage.append(this.calculatePercentage(withColor, fontSize, status));
            if (!Strings.isNullOrEmpty((String)jobPercentage)) {
                percentage.append("<font style='font-size:" + (fontSize - 2) + "px;color:" + fontColor + "'> Tests</font>");
            }
        }
        return percentage.toString();
    }

    public String calculatePercentage(boolean withColor, int fontSize, String status) {
        if (withColor) {
            return Helper.colorizePercentage(Helper.countPercentage(this.results), fontSize, status);
        }
        return Helper.countPercentage(this.results).toString();
    }

    public String calculatePercentageOfJobs(boolean withColor, int fontSize, String status) {
        if (withColor) {
            return Helper.colorizePercentage(Helper.countPercentageD(this.successJobs + this.fixedJobs + this.unstableJobs + this.keepUnstableJobs, this.getTotalJobs()), fontSize, status);
        }
        return Helper.countPercentageD(this.successJobs + this.fixedJobs + this.unstableJobs + this.keepUnstableJobs, this.getTotalJobs()).toString();
    }

    public String calculateTotalDuration() {
        return Helper.duration(this.totalDuration);
    }

    public Long getTotalDuration() {
        return this.totalDuration;
    }

    public void setTotalDuration(Long totalDuration) {
        this.totalDuration = totalDuration;
    }

    public int getTotalNumberOfChanges() {
        return this.totalNumberOfChanges;
    }

    public void setTotalNumberOfChanges(int totalNumberOfChanges) {
        this.totalNumberOfChanges = totalNumberOfChanges;
    }

    public int getFailed() {
        return this.failedJobs + this.keepFailJobs;
    }

    public int getUnstable() {
        return this.unstableJobs + this.keepUnstableJobs;
    }

    public int getDisabledJobs() {
        return this.disabledJobs;
    }

    public void setDisabledJobs(int disabledJobs) {
        this.disabledJobs = disabledJobs;
    }

    public Aggregated copy() {
        Aggregated aggregatedCopy = new Aggregated();
        aggregatedCopy.setAbortedJobs(this.abortedJobs);
        ArrayList<Data> copiedDataList = new ArrayList<Data>();
        for (Data tempData : this.data) {
            copiedDataList.add(tempData.copy());
        }
        aggregatedCopy.setData(copiedDataList);
        aggregatedCopy.setDisabledJobs(this.disabledJobs);
        aggregatedCopy.setFailedJobs(this.failedJobs);
        aggregatedCopy.setFixedJobs(this.fixedJobs);
        aggregatedCopy.setKeepFailJobs(this.keepFailJobs);
        aggregatedCopy.setKeepUnstableJobs(this.keepUnstableJobs);
        aggregatedCopy.setResults(this.results);
        aggregatedCopy.setRunningJobs(this.runningJobs);
        aggregatedCopy.setSuccessJobs(this.successJobs);
        aggregatedCopy.setTotalDuration(this.totalDuration);
        aggregatedCopy.setTotalJobs(this.totalJobs);
        aggregatedCopy.setTotalNumberOfChanges(this.totalNumberOfChanges);
        aggregatedCopy.setUnstableJobs(this.unstableJobs);
        return aggregatedCopy;
    }
}

