/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator;

import com.jenkins.testresultsaggregator.TestResultsAggregatorProjectAction;
import com.jenkins.testresultsaggregator.data.Aggregated;
import com.jenkins.testresultsaggregator.helper.ResultsParser;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Run;
import hudson.tasks.test.AbstractTestResultAction;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;

public class TestResultsAggregatorTestResultBuildAction
extends AbstractTestResultAction
implements Serializable,
SimpleBuildStep.LastBuildAction {
    private static final long serialVersionUID = 31415926L;
    private static final Logger LOGGER = Logger.getLogger(TestResultsAggregatorTestResultBuildAction.class.getName());
    private transient Reference<Aggregated> aggregatedResults;
    protected Integer success;
    protected int fixed;
    protected int failed;
    protected int keepfailed;
    protected int unstable;
    protected int keepunstable;
    protected int aborted;
    protected int running;
    protected int successTTests;
    protected int failedTTests;
    protected int skippedTTests;

    public TestResultsAggregatorTestResultBuildAction(Aggregated aggregatedResults) {
        if (aggregatedResults != null) {
            this.aggregatedResults = new WeakReference<Aggregated>(aggregatedResults);
            this.count(aggregatedResults);
        }
    }

    private void count(Aggregated aggregated) {
        this.success = aggregated.getSuccessJobs();
        this.fixed = aggregated.getFixedJobs();
        this.failed = aggregated.getFailedJobs();
        this.keepfailed = aggregated.getKeepFailJobs();
        this.aborted = aggregated.getAbortedJobs();
        this.unstable = aggregated.getUnstableJobs();
        this.keepunstable = aggregated.getKeepUnstableJobs();
        this.running = aggregated.getRunningJobs();
        this.successTTests = aggregated.getResults().getPass();
        this.failedTTests = aggregated.getResults().getFail();
        this.skippedTTests = aggregated.getResults().getSkip();
    }

    private void countAndSave(Aggregated aggregatedDTO) {
        int savedSuccessCount = this.success != null ? this.success : -1;
        int savedFixedCount = this.fixed;
        int savedFailedCount = this.failed;
        int savedFailedKeepCount = this.keepfailed;
        int savedUnstableCount = this.unstable;
        int savedUnstableKeepCount = this.keepunstable;
        int savedAbortedCount = this.aborted;
        int savedRunningCount = this.running;
        this.count(aggregatedDTO);
        if (this.success != savedSuccessCount || this.failed != savedFailedCount || this.unstable != savedUnstableCount || this.aborted != savedAbortedCount || this.running != savedRunningCount || this.fixed != savedFixedCount || this.keepfailed != savedFailedKeepCount || this.keepunstable != savedUnstableKeepCount) {
            try {
                this.owner.save();
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, "failed to save " + this.owner, x);
            }
        }
    }

    private void countAsNeeded() {
        if (this.success == null) {
            this.countAndSave(this.getResult());
        }
    }

    public Aggregated getResult() {
        return this.getResult(this.run);
    }

    public Aggregated getResult(Run build) {
        Aggregated tr;
        Aggregated aggregated = tr = this.aggregatedResults != null ? this.aggregatedResults.get() : null;
        if (tr == null) {
            tr = TestResultsAggregatorTestResultBuildAction.loadResults(build);
            this.countAndSave(tr);
            this.aggregatedResults = new WeakReference<Aggregated>(tr);
        }
        return tr;
    }

    static Aggregated loadResults(Run<?, ?> owner) {
        FilePath resultDirectory = TestResultsAggregatorTestResultBuildAction.getAggregatedReport(owner);
        FilePath[] paths = null;
        try {
            paths = resultDirectory.list("aggregated.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (paths == null) {
            Aggregated aggregatedDTO = new Aggregated();
            aggregatedDTO.setRun(owner);
            return aggregatedDTO;
        }
        ResultsParser parser = new ResultsParser();
        Aggregated aggregatedDTO = parser.parse(paths);
        aggregatedDTO.setRun(owner);
        return aggregatedDTO;
    }

    static FilePath getAggregatedReport(Run<?, ?> build) {
        return new FilePath(new File(build.getRootDir(), ""));
    }

    public String getIconFileName() {
        return "/plugin/test-results-aggregator/icons/report.png";
    }

    public int getTotalCount() {
        return this.failed + this.unstable + this.success + this.aborted + this.running;
    }

    public int getFailCount() {
        this.countAsNeeded();
        return this.failed;
    }

    public int getFailKeepCount() {
        this.countAsNeeded();
        return this.keepfailed;
    }

    public int getUnstableCount() {
        this.countAsNeeded();
        return this.unstable;
    }

    public int getUnstableKeepCount() {
        this.countAsNeeded();
        return this.keepunstable;
    }

    public int getSuccess() {
        this.countAsNeeded();
        return this.success;
    }

    public int getFixed() {
        this.countAsNeeded();
        return this.fixed;
    }

    public int getAborted() {
        this.countAsNeeded();
        return this.aborted;
    }

    public int getRunning() {
        this.countAsNeeded();
        return this.running;
    }

    public int getSuccessTTests() {
        this.countAsNeeded();
        return this.successTTests;
    }

    public int getFailedTTests() {
        this.countAsNeeded();
        return this.failedTTests;
    }

    public int getSkippedTTests() {
        this.countAsNeeded();
        return this.skippedTTests;
    }

    public String getDisplayName() {
        return "Job Results Aggregated";
    }

    public String getUrlName() {
        return "reports";
    }

    public Api getApi() {
        return new Api((Object)this.getResult());
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new TestResultsAggregatorProjectAction(this.run.getParent()));
    }
}

