/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator;

import com.jenkins.testresultsaggregator.TestResultsAggregatorTestResultBuildAction;
import com.jenkins.testresultsaggregator.helper.GraphHelper;
import hudson.Functions;
import hudson.model.Job;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.test.TestResultProjectAction;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import java.io.IOException;
import java.util.Calendar;
import java.util.SortedMap;
import jenkins.model.lazy.LazyBuildMixIn;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class TestResultsAggregatorProjectAction
extends TestResultProjectAction
implements ProminentProjectAction {
    public static final String SUCCESS = "Success";
    public static final String FIXED = "Fixed";
    public static final String FAILED = "Failed";
    public static final String FAILED_KEEP = "KeepFailling";
    public static final String UNSTABLE = "Unstable";
    public static final String UNSTABLE_KEEP = "KeepUnstable";
    public static final String ABORTED = "Aborted";
    public static final String RUNNING = "Running";
    public static final String JOB_SUCCESS = "SUCCESS";
    public static final String JOB_FIXED = "FIXED";
    public static final String JOB_FAILED = "FAILED";
    public static final String JOB_FAILED_KEEP = "KEEPFAILLING";
    public static final String JOB_UNSTABLE = "UNSTABLE";
    public static final String JOB_UNSTABLE_KEEP = "KEEPUNSTABLE";
    public static final String JOB_ABORTED = "ABORTED";
    public static final String JOB_RUNNING = "RUNNING";
    public static final String JOB_TOTAL = "TOTAL";
    public static final String TEST_TOTAL = "TEST_TOTAL";
    public static final String TEST_SUCCESS = "TEST_SUCCESS";
    public static final String TEST_SKIPPED = "TEST_SKIPPED";
    public static final String TEST_FAILED = "TEST_FAILED";
    public static final String CC_PACKAGES = "CC_PACKAGES";
    public static final String CC_FILES = "CC_FILES";
    public static final String CC_CLASSES = "CC_CLASSES";
    public static final String CC_METHODS = "CC_METHODS";
    public static final String CC_LINES = "CC_LINES";
    public static final String CC_CONDTITIONALS = "CC_CONDITIONALS";

    public TestResultsAggregatorProjectAction(Job<?, ?> project) {
        super(project);
    }

    protected Class<TestResultsAggregatorTestResultBuildAction> getBuildActionClass() {
        return TestResultsAggregatorTestResultBuildAction.class;
    }

    public Job<?, ?> getProject() {
        return this.job;
    }

    public String getIconFileName() {
        return "/plugin/test-results-aggregator/icons/report.png";
    }

    public String getDisplayName() {
        return "Job Results Aggregated";
    }

    public String getGraphNameJobs() {
        return "Job Results Trend";
    }

    public String getGraphNameTests() {
        return "Test Results Trend";
    }

    public String getUrlName() {
        return "reports";
    }

    public String getSearchUrl() {
        return "reports";
    }

    public void doGraphJob(final StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.newGraphNotNeeded(req, rsp)) {
            return;
        }
        final DataSetBuilder dataSetBuilder = new DataSetBuilder();
        this.populateDataSetBuilderJobs((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dataSetBuilder);
        new Graph(-1L, this.getGraphWidth(), this.getGraphHeight()){

            protected JFreeChart createGraph() {
                return GraphHelper.createChartJob(req, dataSetBuilder.build());
            }
        }.doPng(req, rsp);
    }

    public void doGraphTests(final StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.newGraphNotNeeded(req, rsp)) {
            return;
        }
        final DataSetBuilder dataSetBuilder = new DataSetBuilder();
        this.populateDataSetBuilderTest((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dataSetBuilder);
        new Graph(-1L, this.getGraphWidth(), this.getGraphHeight()){

            protected JFreeChart createGraph() {
                return GraphHelper.createChartTests(req, dataSetBuilder.build());
            }
        }.doPng(req, rsp);
    }

    public String getUpUrl() {
        return Functions.getNearestAncestorUrl((StaplerRequest)Stapler.getCurrentRequest(), (Object)this.job) + '/';
    }

    private boolean newGraphNotNeeded(StaplerRequest req, StaplerResponse rsp) {
        Calendar t = this.getProject().getLastCompletedBuild().getTimestamp();
        return req.checkIfModified(t, rsp);
    }

    public void doGraphMapJob(final StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.newGraphNotNeeded(req, rsp)) {
            return;
        }
        final DataSetBuilder dataSetBuilder = new DataSetBuilder();
        this.populateDataSetBuilderJobs((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dataSetBuilder);
        new Graph(-1L, this.getGraphWidth(), this.getGraphHeight()){

            protected JFreeChart createGraph() {
                return GraphHelper.createChartJob(req, dataSetBuilder.build());
            }
        }.doMap(req, rsp);
    }

    public void doGraphMapTests(final StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.newGraphNotNeeded(req, rsp)) {
            return;
        }
        final DataSetBuilder dataSetBuilder = new DataSetBuilder();
        this.populateDataSetBuilderTest((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dataSetBuilder);
        new Graph(-1L, this.getGraphWidth(), this.getGraphHeight()){

            protected JFreeChart createGraph() {
                return GraphHelper.createChartTests(req, dataSetBuilder.build());
            }
        }.doMap(req, rsp);
    }

    public boolean isGraphActive() {
        Run build = this.getProject().getLastBuild();
        int numPoints = 0;
        while (numPoints < 2) {
            if (build == null) {
                return false;
            }
            if (build.getAction(this.getBuildActionClass()) != null) {
                ++numPoints;
            }
            build = build.getPreviousBuild();
        }
        return true;
    }

    public TestResultsAggregatorTestResultBuildAction getLastCompletedBuildAction() {
        for (Run build = this.getProject().getLastCompletedBuild(); build != null; build = build.getPreviousCompletedBuild()) {
            TestResultsAggregatorTestResultBuildAction action = (TestResultsAggregatorTestResultBuildAction)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return action;
        }
        return null;
    }

    protected void populateDataSetBuilderJobs(DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> dataset) {
        if (!(this.job instanceof LazyBuildMixIn.LazyLoadingJob)) {
            return;
        }
        SortedMap loadedBuilds = ((LazyBuildMixIn.LazyLoadingJob)this.job).getLazyBuildMixIn()._getRuns().getLoadedBuilds();
        for (Run build : loadedBuilds.values()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
            TestResultsAggregatorTestResultBuildAction action = (TestResultsAggregatorTestResultBuildAction)build.getAction(this.getBuildActionClass());
            Result result = build.getResult();
            if (result == null || result.isWorseThan(Result.FAILURE) || action == null) continue;
            dataset.add((Number)(action.getSuccess() + action.getFixed()), (Comparable)((Object)SUCCESS), (Comparable)label);
            dataset.add((Number)(action.getFailCount() + action.getFailKeepCount()), (Comparable)((Object)FAILED), (Comparable)label);
            dataset.add((Number)(action.getUnstableCount() + action.getUnstableKeepCount()), (Comparable)((Object)UNSTABLE), (Comparable)label);
            dataset.add((Number)action.getAborted(), (Comparable)((Object)ABORTED), (Comparable)label);
            dataset.add((Number)action.getRunning(), (Comparable)((Object)RUNNING), (Comparable)label);
        }
    }

    protected void populateDataSetBuilderTest(DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> dataset) {
        if (!(this.job instanceof LazyBuildMixIn.LazyLoadingJob)) {
            return;
        }
        SortedMap loadedBuilds = ((LazyBuildMixIn.LazyLoadingJob)this.job).getLazyBuildMixIn()._getRuns().getLoadedBuilds();
        for (Run build : loadedBuilds.values()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
            TestResultsAggregatorTestResultBuildAction action = (TestResultsAggregatorTestResultBuildAction)build.getAction(this.getBuildActionClass());
            Result result = build.getResult();
            if (result == null || result.isWorseThan(Result.FAILURE) || action == null) continue;
            dataset.add((Number)action.getSuccessTTests(), (Comparable)((Object)SUCCESS), (Comparable)label);
            dataset.add((Number)action.getFailedTTests(), (Comparable)((Object)FAILED), (Comparable)label);
            dataset.add((Number)action.getSkippedTTests(), (Comparable)((Object)UNSTABLE), (Comparable)label);
        }
    }

    public int getGraphWidth() {
        return 500;
    }

    public int getGraphHeight() {
        return 200;
    }
}

