/*
 * Decompiled with CFR 0.152.
 */
package com.jenkins.testresultsaggregator;

import com.google.common.base.Strings;
import com.jenkins.testresultsaggregator.TestResultsAggregatorTestResultBuildAction;
import com.jenkins.testresultsaggregator.data.Aggregated;
import com.jenkins.testresultsaggregator.data.Data;
import com.jenkins.testresultsaggregator.data.Job;
import com.jenkins.testresultsaggregator.helper.Analyzer;
import com.jenkins.testresultsaggregator.helper.Collector;
import com.jenkins.testresultsaggregator.helper.Helper;
import com.jenkins.testresultsaggregator.helper.LocalMessages;
import com.jenkins.testresultsaggregator.helper.TestResultHistoryUtil;
import com.jenkins.testresultsaggregator.reporter.Reporter;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.Secret;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.CheckForNull;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class TestResultsAggregator
extends Notifier {
    private static final String displayName = "Aggregate Test Results";
    private String subject;
    private String recipientsList;
    private String beforebody;
    private String afterbody;
    private String theme;
    private String sortresults;
    private String outOfDateResults;
    private Boolean compareWithPreviousRun;
    private Boolean ignoreNotFoundJobs;
    private Boolean ignoreDisabledJobs;
    private Boolean ignoreAbortedJobs;
    private String selectedColumns;
    private List<LocalMessages> columns;
    private List<Data> data;
    private Properties properties;
    public static final String DISPLAY_NAME = "Job Results Aggregated";
    public static final String GRAPH_NAME_JOBS = "Job Results Trend";
    public static final String GRAPH_NAME_TESTS = "Test Results Trend";
    public static final String URL = "reports";
    public static final String ICON_FILE_NAME = "/plugin/test-results-aggregator/icons/report.png";

    @DataBoundConstructor
    public TestResultsAggregator(String subject, String recipientsList, String outOfDateResults, List<Data> data, String beforebody, String afterbody, String theme, String sortresults, String selectedColumns, Boolean compareWithPreviousRun, Boolean ignoreNotFoundJobs, Boolean ignoreDisabledJobs, Boolean ignoreAbortedJobs) {
        this.setRecipientsList(recipientsList);
        this.setOutOfDateResults(outOfDateResults);
        this.setData(data);
        this.setBeforebody(beforebody);
        this.setAfterbody(afterbody);
        this.setTheme(theme);
        this.setSortresults(sortresults);
        this.setSubject(subject);
        this.setSelectedColumns(selectedColumns);
        this.setCompareWithPreviousRun(compareWithPreviousRun);
        this.setIgnoreDisabledJobs(ignoreDisabledJobs);
        this.setIgnoreNotFoundJobs(ignoreNotFoundJobs);
        this.setIgnoreAbortedJobs(ignoreAbortedJobs);
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        PrintStream logger = listener.getLogger();
        Descriptor desc = this.getDescriptor();
        try {
            logger.println(LocalMessages.START_AGGREGATE.toString());
            this.properties = new Properties();
            this.properties.put(AggregatorProperties.OUT_OF_DATE_RESULTS_ARG.name(), this.getOutOfDateResults());
            this.properties.put(AggregatorProperties.TEST_PERCENTAGE_PREFIX.name(), "");
            this.properties.put(AggregatorProperties.THEME.name(), this.getTheme());
            this.properties.put(AggregatorProperties.TEXT_BEFORE_MAIL_BODY.name(), this.getBeforebody());
            this.properties.put(AggregatorProperties.TEXT_AFTER_MAIL_BODY.name(), this.getAfterbody());
            this.properties.put(AggregatorProperties.SORT_JOBS_BY.name(), this.getSortresults());
            this.properties.put(AggregatorProperties.SUBJECT_PREFIX.name(), this.getSubject());
            this.properties.put(AggregatorProperties.RECIPIENTS_LIST.name(), this.getRecipientsList());
            this.resolveVariables(this.properties, build, listener);
            this.columns = this.calculateColumns(this.getSelectedColumns());
            List<Data> validatedData = this.validateInputData(this.getData(), desc.getJenkinsUrl());
            if (this.compareWithPrevious()) {
                Aggregated previousSavedAggregatedResults = TestResultHistoryUtil.getTestResults(build.getPreviousSuccessfulBuild());
                this.previousSavedResults(validatedData, previousSavedAggregatedResults);
            }
            Collector collector = new Collector(logger, desc.getUsername(), desc.getPassword(), desc.getJenkinsUrl());
            collector.collectResults(validatedData, this.compareWithPrevious());
            Aggregated aggregated = new Analyzer(logger).analyze(validatedData, this.properties);
            Reporter reporter = new Reporter(logger, build.getProject().getSomeWorkspace(), build.getRootDir(), desc.getMailNotificationFrom(), this.ignoreDisabledJobs, this.ignoreNotFoundJobs, this.ignoreAbortedJobs);
            reporter.publishResuts(aggregated, this.properties, this.getColumns(), build.getRootDir());
            build.addAction((Action)new TestResultsAggregatorTestResultBuildAction(aggregated));
        }
        catch (Exception e) {
            logger.printf(LocalMessages.ERROR_OCCURRED.toString() + " : %s ", e);
            e.printStackTrace();
        }
        logger.println(LocalMessages.FINISHED_AGGREGATE.toString());
        return true;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    private void resolveVariables(Properties properties, AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
        VariableResolver buildVars = build.getBuildVariableResolver();
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String originalValue = entry.getValue().toString();
            if (Strings.isNullOrEmpty((String)originalValue)) continue;
            while (originalValue.contains("${")) {
                Object buildVariable;
                String tempValue = null;
                if (originalValue.contains("${")) {
                    tempValue = originalValue.substring(originalValue.indexOf("${") + 2, originalValue.indexOf(125));
                }
                if ((buildVariable = buildVars.resolve(tempValue)) == null) {
                    buildVariable = envVars.get(tempValue);
                }
                if (buildVariable != null) {
                    originalValue = originalValue.replaceAll("\\$\\{" + tempValue + "}", buildVariable.toString());
                    continue;
                }
                originalValue = originalValue.replaceAll("\\$\\{" + tempValue + "}", "\\$[" + tempValue + "]");
            }
            entry.setValue(originalValue);
        }
    }

    private void previousSavedResults(List<Data> validatedData, Aggregated previousAggregated) {
        if (previousAggregated != null && previousAggregated.getData() != null) {
            for (Data data : validatedData) {
                for (Job job : data.getJobs()) {
                    block2: for (Data pdata : previousAggregated.getData()) {
                        for (Job pjob : pdata.getJobs()) {
                            if (!job.getJobName().equals(pjob.getJobName())) continue;
                            if (pjob.getJobInfo().getUrl() == null) continue block2;
                            job.setSavedJobUrl(pjob.getJobInfo().getUrl().toString());
                            continue block2;
                        }
                    }
                }
            }
        }
    }

    private List<LocalMessages> calculateColumns(String selectedColumns) {
        ArrayList<LocalMessages> columns = new ArrayList<LocalMessages>(Arrays.asList(LocalMessages.COLUMN_GROUP));
        if (!Strings.isNullOrEmpty((String)selectedColumns)) {
            String[] splitter;
            for (String temp : splitter = selectedColumns.split(",")) {
                if (temp == null) continue;
                if ((temp = temp.trim()).equalsIgnoreCase("Status")) {
                    columns.add(LocalMessages.COLUMN_JOB_STATUS);
                    continue;
                }
                if (temp.equalsIgnoreCase("Job")) {
                    columns.add(LocalMessages.COLUMN_JOB);
                    continue;
                }
                if (temp.equalsIgnoreCase("Percentage")) {
                    columns.add(LocalMessages.COLUMN_PERCENTAGE);
                    continue;
                }
                if (temp.equalsIgnoreCase("Total")) {
                    columns.add(LocalMessages.COLUMN_TESTS);
                    continue;
                }
                if (temp.equalsIgnoreCase("Pass")) {
                    columns.add(LocalMessages.COLUMN_PASS);
                    continue;
                }
                if (temp.equalsIgnoreCase("Fail")) {
                    columns.add(LocalMessages.COLUMN_FAIL);
                    continue;
                }
                if (temp.equalsIgnoreCase("Skip")) {
                    columns.add(LocalMessages.COLUMN_SKIP);
                    continue;
                }
                if (temp.equalsIgnoreCase("Commits")) {
                    columns.add(LocalMessages.COLUMN_COMMITS);
                    continue;
                }
                if (temp.equalsIgnoreCase("LastRun")) {
                    columns.add(LocalMessages.COLUMN_LAST_RUN);
                    continue;
                }
                if (temp.equalsIgnoreCase("Duration")) {
                    columns.add(LocalMessages.COLUMN_DURATION);
                    continue;
                }
                if (temp.equalsIgnoreCase("Description")) {
                    columns.add(LocalMessages.COLUMN_DESCRIPTION);
                    continue;
                }
                if (temp.equalsIgnoreCase("Health")) {
                    columns.add(LocalMessages.COLUMN_HEALTH);
                    continue;
                }
                if (temp.equalsIgnoreCase("Packages")) {
                    columns.add(LocalMessages.COLUMN_CC_PACKAGES);
                    continue;
                }
                if (temp.equalsIgnoreCase("Files")) {
                    columns.add(LocalMessages.COLUMN_CC_FILES);
                    continue;
                }
                if (temp.equalsIgnoreCase("Classes")) {
                    columns.add(LocalMessages.COLUMN_CC_CLASSES);
                    continue;
                }
                if (temp.equalsIgnoreCase("Methods")) {
                    columns.add(LocalMessages.COLUMN_CC_METHODS);
                    continue;
                }
                if (temp.equalsIgnoreCase("Lines")) {
                    columns.add(LocalMessages.COLUMN_CC_LINES);
                    continue;
                }
                if (temp.equalsIgnoreCase("Conditions")) {
                    columns.add(LocalMessages.COLUMN_CC_CONDITIONS);
                    continue;
                }
                if (!temp.equalsIgnoreCase("Sonar")) continue;
                columns.add(LocalMessages.COLUMN_SONAR_URL);
            }
        }
        return columns;
    }

    private List<Data> validateInputData(List<Data> data, String jenkinsUrl) throws UnsupportedEncodingException, MalformedURLException {
        ArrayList<Data> validateData = new ArrayList<Data>();
        for (Data tempDataDTO : data) {
            if (tempDataDTO.getJobs() == null || tempDataDTO.getJobs().isEmpty()) continue;
            boolean allJobsareEmpty = true;
            ArrayList<Job> validateDataJobs = new ArrayList<Job>();
            for (Job temp : tempDataDTO.getJobs()) {
                if (Strings.isNullOrEmpty((String)temp.getJobName())) continue;
                allJobsareEmpty = false;
                validateDataJobs.add(temp);
            }
            if (allJobsareEmpty) continue;
            tempDataDTO.setJobs(validateDataJobs);
            validateData.add(tempDataDTO);
        }
        return this.evaluateInputData(validateData, jenkinsUrl);
    }

    private List<Data> evaluateInputData(List<Data> data, String jenkinsUrl) throws UnsupportedEncodingException, MalformedURLException {
        for (Data jobs : data) {
            for (Job job : jobs.getJobs()) {
                if (job.getJobName().contains("/")) {
                    String[] spliter = job.getJobName().split("/");
                    if (spliter[spliter.length - 1].equals("*")) continue;
                    StringBuilder folders = new StringBuilder();
                    for (int i = 0; i < spliter.length - 1; ++i) {
                        folders.append(spliter[i] + "/");
                    }
                    job.setFolder(folders.toString().replaceAll("/", "/job/"));
                    job.setUrl(jenkinsUrl + "/" + "job" + "/" + Helper.encodeValue(job.getFolder()).replace("%2F", "/") + Helper.encodeValue(spliter[spliter.length - 1]));
                    continue;
                }
                job.setFolder("root");
                if (!Strings.isNullOrEmpty((String)job.getUrl())) continue;
                job.setUrl(jenkinsUrl + "/" + "job" + "/" + Helper.encodeValue(job.getJobName()));
            }
        }
        return data;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @DataBoundSetter
    public void setData(@CheckForNull List<Data> data) {
        this.data = data;
    }

    @DataBoundSetter
    public void setRecipientsList(@CheckForNull String recipientsList) {
        this.recipientsList = recipientsList;
    }

    @DataBoundSetter
    public void setOutOfDateResults(@CheckForNull String outOfDateResults) {
        this.outOfDateResults = outOfDateResults;
    }

    @DataBoundSetter
    public void setBeforebody(@CheckForNull String beforebody) {
        this.beforebody = beforebody;
    }

    @DataBoundSetter
    public void setAfterbody(@CheckForNull String afterbody) {
        this.afterbody = afterbody;
    }

    @DataBoundSetter
    public void setTheme(@CheckForNull String theme) {
        this.theme = theme;
    }

    @DataBoundSetter
    public void setSortresults(@CheckForNull String sortresults) {
        this.sortresults = sortresults;
    }

    @DataBoundSetter
    public void setSubject(@CheckForNull String subject) {
        this.subject = subject;
    }

    @DataBoundSetter
    public void setColumns(@CheckForNull List<LocalMessages> columns) {
        this.columns = columns;
    }

    @DataBoundSetter
    public void setSelectedColumns(@CheckForNull String selectedColumns) {
        this.selectedColumns = selectedColumns;
    }

    @DataBoundSetter
    public void setCompareWithPreviousRun(Boolean compareWithPreviousRun) {
        this.compareWithPreviousRun = compareWithPreviousRun;
    }

    @DataBoundSetter
    public void setIgnoreNotFoundJobs(Boolean ignoreNotFoundJobs) {
        this.ignoreNotFoundJobs = ignoreNotFoundJobs;
    }

    @DataBoundSetter
    public void setIgnoreDisabledJobs(Boolean ignoreDisabledJobs) {
        this.ignoreDisabledJobs = ignoreDisabledJobs;
    }

    @DataBoundSetter
    public void setIgnoreAbortedJobs(Boolean ignoreAbortedJobs) {
        this.ignoreAbortedJobs = ignoreAbortedJobs;
    }

    public String getRecipientsList() {
        return this.recipientsList;
    }

    public String getOutOfDateResults() {
        return this.outOfDateResults;
    }

    public List<Data> getData() {
        return this.data;
    }

    public List<LocalMessages> getColumns() {
        return this.columns;
    }

    public String getSelectedColumns() {
        return this.selectedColumns;
    }

    public String getSubject() {
        if (this.subject == null) {
            this.subject = "";
        }
        return this.subject;
    }

    public String getSortresults() {
        return this.sortresults;
    }

    public String getTheme() {
        return this.theme;
    }

    public String getBeforebody() {
        return this.beforebody;
    }

    public String getAfterbody() {
        return this.afterbody;
    }

    public Boolean isCompareWithPreviousRun() {
        return this.compareWithPreviousRun;
    }

    public Boolean isIgnoreNotFoundJobs() {
        return this.ignoreNotFoundJobs;
    }

    public Boolean isIgnoreDisabledJobs() {
        return this.ignoreDisabledJobs;
    }

    public boolean compareWithPrevious() {
        if (this.compareWithPreviousRun == null) {
            this.compareWithPreviousRun = true;
        }
        return this.compareWithPreviousRun;
    }

    public boolean ignoreNotFoundJobs() {
        if (this.ignoreNotFoundJobs == null) {
            this.ignoreNotFoundJobs = false;
        }
        return this.ignoreNotFoundJobs;
    }

    public boolean ignoreDisabledJobs() {
        if (this.ignoreDisabledJobs == null) {
            this.ignoreDisabledJobs = false;
        }
        return this.ignoreDisabledJobs;
    }

    public boolean ignoreAbortedJobs() {
        if (this.ignoreAbortedJobs == null) {
            this.ignoreAbortedJobs = false;
        }
        return this.ignoreAbortedJobs;
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Publisher> {
        private String jenkinsUrl;
        private String username;
        private Secret password;
        private String mailNotificationFrom;

        public String getUsername() {
            return this.username;
        }

        public Secret getPassword() {
            return this.password;
        }

        public String getJenkinsUrl() {
            return this.jenkinsUrl;
        }

        public String getMailNotificationFrom() {
            return this.mailNotificationFrom;
        }

        public String defaultMailNotificationFrom() {
            return "Jenkins";
        }

        public Descriptor() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return jobType == FreeStyleProject.class;
        }

        public String getDisplayName() {
            return TestResultsAggregator.displayName;
        }

        public boolean configure(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            this.username = jsonObject.getString("username");
            this.password = Secret.fromString((String)((String)jsonObject.get("password")));
            this.jenkinsUrl = jsonObject.getString("jenkinsUrl");
            this.mailNotificationFrom = jsonObject.getString("mailNotificationFrom");
            this.save();
            return super.configure(req, jsonObject);
        }

        public FormValidation doCheckOutOfDateResults(@QueryParameter String outOfDateResults) {
            if (!Strings.isNullOrEmpty((String)outOfDateResults)) {
                try {
                    int hours = Integer.parseInt(outOfDateResults);
                    if (hours < 0) {
                        return FormValidation.error((String)LocalMessages.VALIDATION_POSITIVE_NUMBER.toString());
                    }
                    return FormValidation.ok();
                }
                catch (NumberFormatException e) {
                    return FormValidation.error((String)LocalMessages.VALIDATION_INTEGER_NUMBER.toString());
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doTestApiConnection(@QueryParameter String jenkinsUrl, @QueryParameter String username, @QueryParameter Secret password) {
            try {
                new Collector(null, username, password, jenkinsUrl).getAPIConnection();
                return FormValidation.ok((String)LocalMessages.SUCCESS.toString());
            }
            catch (Exception e) {
                return FormValidation.error((String)(LocalMessages.ERROR_OCCURRED.toString() + ": " + e.getMessage()));
            }
        }
    }

    public static enum Theme {
        dark,
        light;

    }

    public static enum SortResultsBy {
        NAME,
        STATUS,
        TOTAL_TEST,
        PASS,
        FAIL,
        SKIP,
        LAST_RUN,
        COMMITS,
        DURATION,
        PERCENTAGE,
        CC_PACKAGES,
        CC_FILES,
        CC_CLASSES,
        CC_METHODS,
        CC_LINES,
        CC_CONDITIONS,
        SONAR_URL;

    }

    public static enum AggregatorProperties {
        OUT_OF_DATE_RESULTS_ARG,
        TEST_PERCENTAGE_PREFIX,
        TEXT_BEFORE_MAIL_BODY,
        TEXT_AFTER_MAIL_BODY,
        THEME,
        SORT_JOBS_BY,
        SUBJECT_PREFIX,
        RECIPIENTS_LIST;

    }
}

