/*
 * Decompiled with CFR 0.152.
 */
package org.boozallen.plugins.jte.init.primitives.injectors;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.boozallen.plugins.jte.init.primitives.ReservedVariableName;
import org.boozallen.plugins.jte.init.primitives.hooks.HookContext;
import org.boozallen.plugins.jte.init.primitives.injectors.StageInjector;
import org.jenkinsci.plugins.workflow.cps.CpsScript;

public abstract class StepWrapperScript
extends CpsScript {
    LinkedHashMap config = new LinkedHashMap();
    HookContext hookContext = new HookContext();
    StageInjector.StageContext stageContext = new StageInjector.StageContext();
    private String resourcesPath;
    private String buildRootDir;

    public void setConfig(LinkedHashMap config) {
        this.config = config;
    }

    public LinkedHashMap getConfig() {
        return this.config;
    }

    public void setHookContext(HookContext hookContext) {
        this.hookContext = hookContext;
    }

    public HookContext getHookContext() {
        return this.hookContext;
    }

    public void setStageContext(StageInjector.StageContext stageContext) {
        this.stageContext = stageContext;
    }

    public StageInjector.StageContext getStageContext() {
        return this.stageContext;
    }

    public void setBuildRootDir(File rootDir) {
        this.buildRootDir = rootDir.getPath();
    }

    public void setResourcesPath(String resourcesPath) {
        this.resourcesPath = resourcesPath;
    }

    public String resource(String path) throws IOException, InterruptedException {
        if (path.startsWith("/")) {
            throw new AbortException("JTE: library step requested a resource that is not a relative path.");
        }
        File f = new File(this.buildRootDir);
        FilePath runRoot = new FilePath(f);
        FilePath resourcesBaseDir = runRoot.child(this.resourcesPath);
        FilePath resourceFile = resourcesBaseDir.child(path);
        if (!resourceFile.exists()) {
            String oopsMsg = String.format("JTE: library step requested a resource '%s' that does not exist", path);
            throw new AbortException(oopsMsg);
        }
        if (resourceFile.isDirectory()) {
            String oopsMsg = String.format("JTE: library step requested a resource '%s' that is not a file.", path);
            throw new AbortException(oopsMsg);
        }
        return resourceFile.readToString();
    }

    @Extension
    public static class ResourceReservedVariable
    extends ReservedVariableName {
        @Override
        public String getName() {
            return "resource";
        }

        @Override
        public String getDescription() {
            return String.format("Variable name %s is reserved for steps to access library resources", this.getName());
        }
    }

    @Extension
    public static class StageContextReservedVariable
    extends ReservedVariableName {
        @Override
        public String getName() {
            return "stageContext";
        }

        @Override
        public String getDescription() {
            return String.format("Variable name %s is reserved for steps to access their stage context", this.getName());
        }
    }

    @Extension
    public static class HookContextReservedVariable
    extends ReservedVariableName {
        @Override
        public String getName() {
            return "hookContext";
        }

        @Override
        public String getDescription() {
            return String.format("Variable name %s is reserved for steps to access their hook context", this.getName());
        }
    }

    @Extension
    public static class ConfigReservedVariable
    extends ReservedVariableName {
        @Override
        public String getName() {
            return "config";
        }

        @Override
        public String getDescription() {
            return String.format("Variable name %s is reserved for steps to access their library configuration", this.getName());
        }
    }
}

