/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.templateproject;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import java.util.Map;
import java.util.logging.Logger;

public class TemplateUtils {
    private static final Logger logger = Logger.getLogger("TemplateProject");

    public static AbstractProject<?, ?> getProject(String projectName, AbstractBuild<?, ?> build) {
        String pName = projectName;
        if (build != null) {
            pName = TemplateUtils.getExpandedProjectName(projectName, build);
            if (Hudson.getInstance().getItemByFullName(pName) == null) {
                logger.info("[TemplateProject] Template Project '" + pName + "' not found. Skipping.");
            }
        }
        return (AbstractProject)Hudson.getInstance().getItemByFullName(pName);
    }

    public static String getExpandedProjectName(String projectName, AbstractBuild<?, ?> build) {
        return Util.replaceMacro((String)projectName, (Map)build.getBuildVariables());
    }
}

