/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.templateproject;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.HyperlinkNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.templateproject.TemplateUtils;
import hudson.scm.ChangeLogParser;
import hudson.scm.NullSCM;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.security.AccessControlled;
import hudson.tasks.Messages;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.multiplescms.MultiSCMRevisionState;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ProxySCM
extends SCM {
    private final String projectName;

    @DataBoundConstructor
    public ProxySCM(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getExpandedProjectName(AbstractBuild<?, ?> build) {
        return TemplateUtils.getExpandedProjectName(this.projectName, build);
    }

    public AbstractProject<?, ?> getProject() {
        return TemplateUtils.getProject(this.projectName, null);
    }

    public SCM getProjectScm(AbstractBuild<?, ?> build) {
        try {
            return TemplateUtils.getProject(this.projectName, build).getScm();
        }
        catch (Exception e) {
            return new NullSCM();
        }
    }

    public SCM getProjectScm() {
        return this.getProjectScm(null);
    }

    public void checkout(@Nonnull Run<?, ?> build, @Nonnull Launcher launcher, @Nonnull FilePath workspace, @Nonnull TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState baseline) throws IOException, InterruptedException {
        if (this.getProjectScm((AbstractBuild)build).toString().contains("multiplescms") && (baseline == SCMRevisionState.NONE || baseline == null)) {
            baseline = new MultiSCMRevisionState();
        }
        AbstractProject<?, ?> p = TemplateUtils.getProject(this.getProjectName(), (AbstractBuild)build);
        listener.getLogger().println("[TemplateProject] Using SCM from: " + HyperlinkNote.encodeTo((String)('/' + p.getUrl()), (String)p.getFullDisplayName()));
        this.getProjectScm((AbstractBuild)build).checkout(build, launcher, workspace, listener, changelogFile, baseline);
    }

    public ChangeLogParser createChangeLogParser() {
        return this.getProjectScm().createChangeLogParser();
    }

    @Deprecated
    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        return this.getProjectScm().pollChanges(project, launcher, workspace, listener);
    }

    public RepositoryBrowser getBrowser() {
        return this.getProjectScm().getBrowser();
    }

    public FilePath getModuleRoot(FilePath workspace) {
        return this.getProjectScm().getModuleRoot(workspace);
    }

    public FilePath[] getModuleRoots(FilePath workspace) {
        return this.getProjectScm().getModuleRoots(workspace);
    }

    public boolean processWorkspaceBeforeDeletion(AbstractProject<?, ?> project, FilePath workspace, Node node) throws IOException, InterruptedException {
        return this.getProjectScm().processWorkspaceBeforeDeletion(project, workspace, node);
    }

    public boolean requiresWorkspaceForPolling() {
        return this.getProjectScm().requiresWorkspaceForPolling();
    }

    public boolean supportsPolling() {
        return this.getProjectScm().supportsPolling();
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        this.getProjectScm(build).buildEnvVars(build, env);
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> paramAbstractBuild, Launcher paramLauncher, TaskListener paramTaskListener) throws IOException, InterruptedException {
        return this.getProjectScm(paramAbstractBuild).calcRevisionsFromBuild(paramAbstractBuild, paramLauncher, paramTaskListener);
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        return this.getProjectScm().poll(project, launcher, workspace, listener, baseline);
    }

    @Extension
    public static class DescriptorImpl
    extends SCMDescriptor {
        public DescriptorImpl() {
            super(null);
        }

        public String getDisplayName() {
            return "Use SCM from another project";
        }

        public FormValidation doCheckProjectName(@AncestorInPath AccessControlled anc, @QueryParameter String value) {
            if (!anc.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)"Project cannot be empty");
            }
            Item item = Hudson.getInstance().getItemByFullName(value, Item.class);
            if (item == null) {
                return FormValidation.error((String)Messages.BuildTrigger_NoSuchProject((Object)value, (Object)AbstractProject.findNearest((String)value).getName()));
            }
            if (!(item instanceof AbstractProject)) {
                return FormValidation.error((String)Messages.BuildTrigger_NotBuildable((Object)value));
            }
            return FormValidation.ok();
        }
    }
}

