/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.templateproject;

import hudson.Extension;
import hudson.Launcher;
import hudson.console.HyperlinkNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.plugins.templateproject.TemplateUtils;
import hudson.security.AccessControlled;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Messages;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ProxyPublisher
extends Recorder
implements DependecyDeclarer {
    private final String projectName;

    @DataBoundConstructor
    public ProxyPublisher(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getExpandedProjectName(AbstractBuild<?, ?> build) {
        return TemplateUtils.getExpandedProjectName(this.projectName, build);
    }

    public AbstractProject<?, ?> getProject() {
        return TemplateUtils.getProject(this.projectName, null);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean needsToRunAfterFinalized() {
        return false;
    }

    public List<Publisher> getProjectPublishersList(AbstractBuild<?, ?> build) {
        return TemplateUtils.getProject(this.projectName, build).getPublishersList().toList();
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        for (Publisher publisher : this.getProjectPublishersList(build)) {
            if (publisher.prebuild(build, listener)) continue;
            return false;
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean publishersResult = true;
        for (Publisher publisher : this.getProjectPublishersList(build)) {
            AbstractProject<?, ?> p = TemplateUtils.getProject(this.getProjectName(), build);
            listener.getLogger().println("[TemplateProject] Starting publishers from: " + HyperlinkNote.encodeTo((String)('/' + p.getUrl()), (String)p.getFullDisplayName()));
            if (!publisher.perform(build, launcher, listener)) {
                listener.getLogger().println("[TemplateProject] FAILED performing publishers from: '" + p.getFullDisplayName() + "'");
                publishersResult = false;
                continue;
            }
            listener.getLogger().println("[TemplateProject] Successfully performed publishers from: '" + p.getFullDisplayName() + "'");
        }
        return publishersResult;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        ArrayList actions = new ArrayList();
        AbstractProject<?, ?> templateProject = this.getProject();
        if (templateProject != null) {
            for (Publisher publisher : templateProject.getPublishersList().toList()) {
                actions.addAll(publisher.getProjectActions(project));
            }
        }
        return actions;
    }

    public void buildDependencyGraph(AbstractProject project, DependencyGraph graph) {
        AbstractProject<?, ?> templateProject = this.getProject();
        if (templateProject != null) {
            for (Publisher publisher : templateProject.getPublishersList().toList()) {
                if (!(publisher instanceof DependecyDeclarer)) continue;
                ((DependecyDeclarer)publisher).buildDependencyGraph(project, graph);
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Use publishers from another project";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doCheckProjectName(@AncestorInPath AccessControlled anc, @QueryParameter String value) {
            if (!anc.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            Item item = Hudson.getInstance().getItemByFullName(value, Item.class);
            if (item == null) {
                return FormValidation.error((String)Messages.BuildTrigger_NoSuchProject((Object)value, (Object)AbstractProject.findNearest((String)value).getName()));
            }
            if (!(item instanceof AbstractProject)) {
                return FormValidation.error((String)Messages.BuildTrigger_NotBuildable((Object)value));
            }
            return FormValidation.ok();
        }
    }
}

