/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import com.google.common.collect.Lists;
import hudson.Plugin;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.plugins.swarm.SwarmSlave;
import hudson.plugins.swarm.UDPFragmentImpl;
import hudson.slaves.SlaveComputer;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolLocationNodeProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.apache.commons.lang.ArrayUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginImpl
extends Plugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCreateSlave(StaplerRequest req, StaplerResponse rsp, @QueryParameter String name, @QueryParameter String description, @QueryParameter int executors, @QueryParameter String remoteFsRoot, @QueryParameter String labels, @QueryParameter String secret, @QueryParameter Node.Mode mode, @QueryParameter(fixEmpty=true) String hash, @QueryParameter boolean deleteExistingClients) throws IOException {
        if (!PluginImpl.getSwarmSecret().equals(secret)) {
            rsp.setStatus(403);
            return;
        }
        try {
            Computer c;
            Node n;
            Jenkins jenkins = Jenkins.getInstance();
            jenkins.checkPermission(SlaveComputer.CREATE);
            Object[] toolLocations = req.getParameterValues("toolLocation");
            ArrayList nodeProperties = Lists.newArrayList();
            if (!ArrayUtils.isEmpty((Object[])toolLocations)) {
                List<ToolLocationNodeProperty.ToolLocation> parsedToolLocations = this.parseToolLocations((String[])toolLocations);
                nodeProperties = Lists.newArrayList((Object[])new ToolLocationNodeProperty[]{new ToolLocationNodeProperty(parsedToolLocations)});
            }
            if (hash == null && jenkins.getNode(name) != null && !deleteExistingClients) {
                rsp.setStatus(409);
                rsp.setContentType("text/plain; UTF-8");
                rsp.getWriter().printf("A slave called '%s' already exists and legacy clients do not support name disambiguation%n", name);
                return;
            }
            if (hash != null) {
                name = name + '-' + hash;
            }
            if ((n = jenkins.getNode(name)) != null && !deleteExistingClients && (c = n.toComputer()) != null && c.isOnline()) {
                rsp.setStatus(409);
                rsp.setContentType("text/plain; UTF-8");
                rsp.getWriter().printf("A slave called '%s' is already created and on-line%n", name);
                return;
            }
            SwarmSlave slave = new SwarmSlave(name, "Swarm slave from " + req.getRemoteHost() + " : " + description, remoteFsRoot, String.valueOf(executors), mode, "swarm " + Util.fixNull((String)labels), nodeProperties);
            c = jenkins;
            synchronized (c) {
                Node n2 = jenkins.getNode(name);
                if (n2 != null) {
                    jenkins.removeNode(n2);
                }
                jenkins.addNode((Node)slave);
            }
            rsp.setContentType("text/plain; charset=iso-8859-1");
            Properties props = new Properties();
            props.put("name", name);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            props.store(bos, "");
            byte[] response = bos.toByteArray();
            rsp.setContentLength(response.length);
            ServletOutputStream outputStream = rsp.getOutputStream();
            outputStream.write(response);
            outputStream.flush();
        }
        catch (Descriptor.FormException e) {
            e.printStackTrace();
        }
    }

    private List<ToolLocationNodeProperty.ToolLocation> parseToolLocations(String[] toolLocations) {
        ArrayList result = Lists.newArrayList();
        for (String toolLocKeyValue : toolLocations) {
            boolean found = false;
            String[] toolLoc = toolLocKeyValue.split(":", 2);
            for (ToolDescriptor desc : ToolInstallation.all()) {
                for (ToolInstallation inst : desc.getInstallations()) {
                    if (!inst.getName().equals(toolLoc[0])) continue;
                    found = true;
                    String location = toolLoc[1];
                    ToolLocationNodeProperty.ToolLocation toolLocation = new ToolLocationNodeProperty.ToolLocation(desc, inst.getName(), location);
                    result.add(toolLocation);
                }
            }
            if (found) continue;
            throw new RuntimeException("No tool '" + toolLoc[0] + "' is defined on Jenkins.");
        }
        return result;
    }

    static String getSwarmSecret() {
        return ((UDPFragmentImpl)((Object)UDPFragmentImpl.all().get(UDPFragmentImpl.class))).secret.toString();
    }

    public void doSlaveInfo(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Jenkins jenkins = Jenkins.getInstance();
        jenkins.checkPermission(SlaveComputer.CREATE);
        rsp.setContentType("text/xml");
        Writer w = rsp.getCompressedWriter((HttpServletRequest)req);
        w.write("<slaveInfo><swarmSecret>" + PluginImpl.getSwarmSecret() + "</swarmSecret></slaveInfo>");
        w.close();
    }
}

