/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import hudson.Plugin;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.plugins.swarm.SwarmSlave;
import hudson.plugins.swarm.UDPFragmentImpl;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class PluginImpl
extends Plugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCreateSlave(StaplerRequest req, StaplerResponse rsp, @QueryParameter String name, @QueryParameter String description, @QueryParameter int executors, @QueryParameter String remoteFsRoot, @QueryParameter String labels, @QueryParameter String secret) throws IOException, Descriptor.FormException {
        if (!PluginImpl.getSwarmSecret().equals(secret)) {
            rsp.setStatus(403);
            return;
        }
        try {
            Jenkins jenkins = Jenkins.getInstance();
            jenkins.checkPermission(SlaveComputer.CREATE);
            if (jenkins.getNode(name) != null) {
                name = name + '-' + req.getRemoteAddr();
            }
            SwarmSlave slave = new SwarmSlave(name, "Swarm slave from " + req.getRemoteHost() + " : " + description, remoteFsRoot, String.valueOf(executors), "swarm " + Util.fixNull((String)labels));
            Jenkins jenkins2 = jenkins;
            synchronized (jenkins2) {
                Node n = jenkins.getNode(name);
                if (n != null) {
                    jenkins.removeNode(n);
                }
                jenkins.addNode((Node)slave);
            }
        }
        catch (Descriptor.FormException e) {
            e.printStackTrace();
        }
    }

    static String getSwarmSecret() {
        return ((UDPFragmentImpl)((Object)UDPFragmentImpl.all().get(UDPFragmentImpl.class))).secret.toString();
    }

    public void doSlaveInfo(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Jenkins jenkins = Jenkins.getInstance();
        jenkins.checkPermission(SlaveComputer.CREATE);
        rsp.setContentType("text/xml");
        Writer w = rsp.getCompressedWriter((HttpServletRequest)req);
        w.write("<slaveInfo><swarmSecret>" + PluginImpl.getSwarmSecret() + "</swarmSecret></slaveInfo>");
        w.close();
    }
}

