/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import com.google.common.collect.Lists;
import hudson.Plugin;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.plugins.swarm.SwarmSlave;
import hudson.plugins.swarm.UDPFragmentImpl;
import hudson.slaves.SlaveComputer;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolLocationNodeProperty;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginImpl
extends Plugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCreateSlave(StaplerRequest req, StaplerResponse rsp, @QueryParameter String name, @QueryParameter String description, @QueryParameter int executors, @QueryParameter String remoteFsRoot, @QueryParameter String labels, @QueryParameter String secret, @QueryParameter Node.Mode mode, @QueryParameter String toolLocations) throws IOException {
        if (!PluginImpl.getSwarmSecret().equals(secret)) {
            rsp.setStatus(403);
            return;
        }
        try {
            Jenkins jenkins = Jenkins.getInstance();
            jenkins.checkPermission(SlaveComputer.CREATE);
            ToolLocationNodeProperty toolLocationNodeProperty = new ToolLocationNodeProperty(this.parseToolLocations(toolLocations));
            if (jenkins.getNode(name) != null) {
                name = name + '-' + req.getRemoteAddr();
            }
            SwarmSlave slave = new SwarmSlave(name, "Swarm slave from " + req.getRemoteHost() + " : " + description, remoteFsRoot, String.valueOf(executors), mode, "swarm " + Util.fixNull((String)labels), Lists.newArrayList((Object[])new ToolLocationNodeProperty[]{toolLocationNodeProperty}));
            Jenkins jenkins2 = jenkins;
            synchronized (jenkins2) {
                Node n = jenkins.getNode(name);
                if (n != null) {
                    jenkins.removeNode(n);
                }
                jenkins.addNode((Node)slave);
            }
        }
        catch (Descriptor.FormException e) {
            e.printStackTrace();
        }
    }

    private List<ToolLocationNodeProperty.ToolLocation> parseToolLocations(String toolLocations) {
        String[] toolLocsArray;
        ArrayList result = Lists.newArrayList();
        for (String toolLocKeyValue : toolLocsArray = toolLocations.split(" ")) {
            boolean found = false;
            String[] toolLoc = toolLocKeyValue.split(":");
            for (ToolDescriptor desc : ToolInstallation.all()) {
                for (ToolInstallation inst : desc.getInstallations()) {
                    if (!inst.getName().equals(toolLoc[0])) continue;
                    found = true;
                    String key = inst.getClass().getCanonicalName().toString() + "$DescriptorImpl@" + inst.getName();
                    String location = toolLoc[1];
                    ToolLocationNodeProperty.ToolLocation toolLocation = new ToolLocationNodeProperty.ToolLocation(key, location);
                    result.add(toolLocation);
                }
            }
            if (found) continue;
            throw new RuntimeException("No tool '" + toolLoc[0] + "' is defined on Jenkins.");
        }
        return result;
    }

    static String getSwarmSecret() {
        return ((UDPFragmentImpl)((Object)UDPFragmentImpl.all().get(UDPFragmentImpl.class))).secret.toString();
    }

    public void doSlaveInfo(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Jenkins jenkins = Jenkins.getInstance();
        jenkins.checkPermission(SlaveComputer.CREATE);
        rsp.setContentType("text/xml");
        Writer w = rsp.getCompressedWriter((HttpServletRequest)req);
        w.write("<slaveInfo><swarmSecret>" + PluginImpl.getSwarmSecret() + "</swarmSecret></slaveInfo>");
        w.close();
    }
}

