/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.protocol;

import hudson.remoting.Future;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import org.jenkinsci.remoting.protocol.ApplicationLayer;
import org.jenkinsci.remoting.protocol.FilterLayer;
import org.jenkinsci.remoting.protocol.NetworkLayer;
import org.jenkinsci.remoting.protocol.ProtocolLayer;
import org.jenkinsci.remoting.util.ByteBufferPool;

public class ProtocolStack<T>
implements Closeable,
ByteBufferPool {
    private static final Logger LOGGER = Logger.getLogger(ProtocolStack.class.getName());
    private final ReadWriteLock stackLock = new ReentrantReadWriteLock();
    private final NetworkLayer network;
    private final ApplicationLayer<T> application;
    private final Ptr recvHead;
    private String name;
    @GuardedBy(value="stackLock")
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final long handshakingTimeout = 10L;
    private final TimeUnit handshakingUnits = TimeUnit.SECONDS;

    private ProtocolStack(String name, NetworkLayer network, List<FilterLayer> filters, ApplicationLayer<T> application, List<Listener> listeners) {
        this.name = name;
        this.network = network;
        this.application = application;
        this.recvHead = new Ptr(network);
        this.listeners.addAll(listeners);
        Ptr sendHead = this.recvHead;
        for (FilterLayer protocol : filters) {
            sendHead = new Ptr(sendHead, protocol);
        }
        new Ptr(sendHead, application);
    }

    public static Builder on(NetworkLayer network) {
        return new Builder(network);
    }

    private void init() throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "[{0}] Initializing", this.name());
        }
        assert (this.recvHead.layer == this.network);
        Ptr p = this.recvHead;
        while (p != null) {
            p.layer.init(p);
            p = p.getNextRecv();
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "[{0}] Starting", this.name());
        }
        p = this.recvHead;
        while (p != null) {
            try {
                p.layer.start();
            }
            catch (IOException e) {
                Ptr nextRecv;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LogRecord record = new LogRecord(Level.FINEST, "[{0}] Start failure");
                    record.setParameters(new Object[]{this.name()});
                    record.setThrown(e);
                    LOGGER.log(record);
                }
                if ((nextRecv = p.getNextRecv()) != null) {
                    p.onRecvClosed(e);
                }
                throw e;
            }
            p = p.getNextRecv();
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "[{0}] Started", this.name());
        }
    }

    public T get() {
        return this.application.get();
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        if (!(this.name != null ? this.name.equals(name) : name == null)) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "[{0}] is now known as [{1}]", new Object[]{this.name, name});
            }
            this.name = name != null && !name.isEmpty() ? name : this.name;
        }
    }

    @Override
    public void close() throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "[{0}] Closing", this.name());
        }
        try {
            this.application.doCloseWrite();
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LogRecord record = new LogRecord(Level.FINEST, "[{0}] Abnormal close");
                record.setParameters(new Object[]{this.name()});
                record.setThrown(e);
                LOGGER.log(record);
            }
            throw e;
        }
        finally {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "[{0}] Closed", this.name());
            }
        }
    }

    public void addListener(Listener listener) {
        this.stackLock.writeLock().lock();
        try {
            this.listeners.add(listener);
        }
        finally {
            this.stackLock.writeLock().unlock();
        }
    }

    public void removeListener(Listener listener) {
        this.stackLock.writeLock().lock();
        try {
            this.listeners.remove(listener);
        }
        finally {
            this.stackLock.writeLock().unlock();
        }
    }

    void doCloseRecv() {
        this.network.doCloseRecv();
    }

    boolean isRecvOpen() {
        return this.network.isRecvOpen();
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ProtocolStack{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(",[");
        assert (this.recvHead.layer == this.network);
        Ptr p = this.recvHead;
        while (p != null) {
            if (p != this.recvHead) {
                sb.append(',');
            }
            sb.append(p.layer);
            p = p.getNextRecv();
        }
        sb.append("]}");
        return sb.toString();
    }

    void onClosed(IOException cause) {
        ArrayList<Listener> listeners = new ArrayList<Listener>();
        this.stackLock.readLock().lock();
        try {
            listeners.addAll(this.listeners);
        }
        finally {
            this.stackLock.readLock().unlock();
        }
        for (Listener listener : listeners) {
            listener.onClosed(this, cause);
        }
    }

    @OverridingMethodsMustInvokeSuper
    public void execute(Runnable task) {
        this.network.getIoHub().execute(task);
    }

    @OverridingMethodsMustInvokeSuper
    public Future<?> executeLater(Runnable task, long delay, TimeUnit units) {
        return this.network.getIoHub().executeLater(task, delay, units);
    }

    public long getHandshakingTimeout() {
        return 10L;
    }

    public TimeUnit getHandshakingUnits() {
        return this.handshakingUnits;
    }

    @Override
    public ByteBuffer acquire(int size) {
        return this.network.getIoHub().acquire(size);
    }

    @Override
    public void release(ByteBuffer buffer) {
        this.network.getIoHub().release(buffer);
    }

    public static interface Listener {
        public void onClosed(ProtocolStack var1, IOException var2);
    }

    public class Ptr {
        private final ProtocolLayer layer;
        @GuardedBy(value="ProtocolStack.stackLock")
        private Ptr nextSend;
        @GuardedBy(value="ProtocolStack.stackLock")
        private Ptr nextRecv;
        @GuardedBy(value="ProtocolStack.stackLock")
        private boolean recvOnClosed;
        @GuardedBy(value="ProtocolStack.stackLock")
        private boolean sendDoClosed;
        @GuardedBy(value="ProtocolStack.stackLock")
        private boolean removed;

        private Ptr(NetworkLayer network) {
            ProtocolStack.this.stackLock.writeLock().lock();
            try {
                this.nextSend = null;
            }
            finally {
                ProtocolStack.this.stackLock.writeLock().unlock();
            }
            this.layer = network;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Ptr(Ptr nextSend, FilterLayer filter) {
            ProtocolStack.this.stackLock.writeLock().lock();
            try {
                this.nextSend = nextSend;
                nextSend.nextRecv = this;
            }
            finally {
                ProtocolStack.this.stackLock.writeLock().unlock();
            }
            this.layer = filter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Ptr(Ptr nextSend, ApplicationLayer<? extends Object> application) {
            ProtocolStack.this.stackLock.writeLock().lock();
            try {
                this.nextSend = nextSend;
                nextSend.nextRecv = this;
            }
            finally {
                ProtocolStack.this.stackLock.writeLock().unlock();
            }
            this.layer = application;
        }

        public void onRecv(ByteBuffer data) throws IOException {
            if (!data.hasRemaining()) {
                return;
            }
            Ptr nextRecv = this.getNextRecv();
            if (nextRecv == null) {
                throw new UnsupportedOperationException("Application layer is not supposed to call onRecv");
            }
            ProtocolLayer.Recv recv = (ProtocolLayer.Recv)nextRecv.layer;
            if (!recv.isRecvOpen()) {
                throw new ClosedChannelException();
            }
            recv.onRecv(data);
        }

        public void doSend(ByteBuffer data) throws IOException {
            if (!data.hasRemaining()) {
                return;
            }
            Ptr nextSend = this.getNextSend();
            if (nextSend == null) {
                throw new UnsupportedOperationException("Network layer is not supposed to call doSend");
            }
            ProtocolLayer.Send send = (ProtocolLayer.Send)nextSend.layer;
            if (!send.isSendOpen()) {
                throw new ClosedChannelException();
            }
            send.doSend(data);
        }

        public boolean isRecvOpen() {
            Ptr nextRecv;
            ProtocolStack.this.stackLock.readLock().lock();
            try {
                nextRecv = this.getNextRecv();
                if (nextRecv == null) {
                    throw new UnsupportedOperationException("Application layer is not supposed to call isRecvOpen");
                }
                if (this.recvOnClosed) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                ProtocolStack.this.stackLock.readLock().unlock();
            }
            return ((ProtocolLayer.Recv)nextRecv.layer).isRecvOpen();
        }

        public boolean isSendOpen() {
            Ptr nextSend;
            ProtocolStack.this.stackLock.readLock().lock();
            try {
                nextSend = this.getNextSend();
                if (nextSend == null) {
                    throw new UnsupportedOperationException("Network layer is not supposed to call isSendOpen");
                }
                if (this.sendDoClosed) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                ProtocolStack.this.stackLock.readLock().unlock();
            }
            return ((ProtocolLayer.Send)nextSend.layer).isSendOpen();
        }

        public ProtocolStack<?> stack() {
            return ProtocolStack.this;
        }

        public void remove() {
            ProtocolStack.this.stackLock.readLock().lock();
            try {
                if (this.removed) {
                    return;
                }
                if (this.nextSend == null) {
                    throw new UnsupportedOperationException("Network layer is not supposed to call remove");
                }
                if (this.nextRecv == null) {
                    throw new UnsupportedOperationException("Application layer is not supposed to call remove");
                }
                this.removed = true;
            }
            finally {
                ProtocolStack.this.stackLock.readLock().unlock();
            }
        }

        public void doCloseSend() throws IOException {
            if (this.getNextSend() == null) {
                throw new UnsupportedOperationException("Network layer is not allowed to call doClose()");
            }
            ProtocolStack.this.stackLock.readLock().lock();
            try {
                if (this.sendDoClosed) {
                    return;
                }
            }
            finally {
                ProtocolStack.this.stackLock.readLock().unlock();
            }
            ProtocolStack.this.stackLock.writeLock().lock();
            try {
                if (this.sendDoClosed) {
                    return;
                }
                this.sendDoClosed = true;
            }
            finally {
                ProtocolStack.this.stackLock.writeLock().unlock();
            }
            if (this.nextSend().isSendOpen()) {
                this.nextSend().doCloseSend();
            }
        }

        public void onRecvClosed(IOException cause) throws IOException {
            if (this.getNextRecv() == null) {
                throw new UnsupportedOperationException("Application layer is not supposed to call onClose");
            }
            ProtocolStack.this.stackLock.readLock().lock();
            try {
                if (this.recvOnClosed) {
                    return;
                }
            }
            finally {
                ProtocolStack.this.stackLock.readLock().unlock();
            }
            ProtocolStack.this.stackLock.writeLock().lock();
            try {
                if (this.recvOnClosed) {
                    return;
                }
                this.recvOnClosed = true;
            }
            finally {
                ProtocolStack.this.stackLock.writeLock().unlock();
            }
            if (this.nextRecv().isRecvOpen()) {
                this.nextRecv().onRecvClosed(cause);
            }
        }

        @Nonnull
        private ProtocolLayer.Send nextSend() {
            return (ProtocolLayer.Send)this.getNextSend().layer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Ptr getNextSend() {
            Ptr nextSend;
            ProtocolStack.this.stackLock.readLock().lock();
            try {
                nextSend = this.nextSend;
                while (nextSend != null && nextSend.removed && nextSend.nextSend != null) {
                    nextSend = nextSend.nextSend;
                }
                if (nextSend == this.nextSend) {
                    Ptr ptr = nextSend;
                    return ptr;
                }
            }
            finally {
                ProtocolStack.this.stackLock.readLock().unlock();
            }
            if (ProtocolStack.this.stackLock.writeLock().tryLock()) {
                try {
                    while (this.nextSend != nextSend && this.nextSend != null && this.nextSend.removed) {
                        assert (this.nextSend.layer instanceof FilterLayer) : "this is the layer before and there is a layer after nextSend thus nextSend *must* be a FilterLayer";
                        ((FilterLayer)this.nextSend.layer).onSendRemoved();
                        Ptr tmp = this.nextSend.nextSend;
                        this.nextSend.nextSend = null;
                        this.nextSend = tmp;
                    }
                }
                finally {
                    ProtocolStack.this.stackLock.writeLock().unlock();
                }
            }
            return nextSend;
        }

        @Nonnull
        private ProtocolLayer.Recv nextRecv() {
            return (ProtocolLayer.Recv)this.getNextRecv().layer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Ptr getNextRecv() {
            Ptr nextRecv;
            ProtocolStack.this.stackLock.readLock().lock();
            try {
                nextRecv = this.nextRecv;
                while (nextRecv != null && nextRecv.removed && nextRecv.nextRecv != null) {
                    nextRecv = nextRecv.nextRecv;
                }
                if (nextRecv == this.nextRecv) {
                    Ptr ptr = this.nextRecv;
                    return ptr;
                }
            }
            finally {
                ProtocolStack.this.stackLock.readLock().unlock();
            }
            if (ProtocolStack.this.stackLock.writeLock().tryLock()) {
                try {
                    while (this.nextRecv != nextRecv && this.nextRecv != null && this.nextRecv.removed) {
                        assert (this.nextRecv.layer instanceof FilterLayer) : "this is the layer before and there is a layer after nextRecv thus nextRecv *must* be a FilterLayer";
                        ((FilterLayer)this.nextRecv.layer).onRecvRemoved();
                        Ptr tmp = this.nextRecv.nextRecv;
                        this.nextRecv.nextRecv = null;
                        this.nextRecv = tmp;
                    }
                }
                finally {
                    ProtocolStack.this.stackLock.writeLock().unlock();
                }
            }
            return nextRecv;
        }
    }

    @NotThreadSafe
    public static class Builder {
        private static final AtomicInteger id = new AtomicInteger();
        private final NetworkLayer network;
        private final List<FilterLayer> filters;
        private final List<Listener> listeners = new ArrayList<Listener>();
        @CheckForNull
        private String name;
        private boolean built;

        private Builder(NetworkLayer network) {
            if (network.stack() != null) {
                throw new IllegalArgumentException();
            }
            this.network = network;
            this.filters = new ArrayList<FilterLayer>();
        }

        public Builder filter(@CheckForNull FilterLayer filter) {
            if (filter != null) {
                if (filter.stack() != null) {
                    throw new IllegalArgumentException();
                }
                this.checkNotBuilt();
                this.filters.add(filter);
            }
            return this;
        }

        public Builder named(String name) {
            this.checkNotBuilt();
            this.name = name;
            return this;
        }

        public Builder listener(Listener listener) {
            this.checkNotBuilt();
            this.listeners.add(listener);
            return this;
        }

        public <T> ProtocolStack<T> build(ApplicationLayer<T> application) throws IOException {
            if (application.stack() != null) {
                throw new IllegalArgumentException();
            }
            this.checkNotBuilt();
            this.built = true;
            ProtocolStack stack = new ProtocolStack(this.name == null || this.name.isEmpty() ? String.format("Stack-%d", id.incrementAndGet()) : this.name, this.network, this.filters, application, this.listeners);
            stack.init();
            return stack;
        }

        private void checkNotBuilt() {
            if (this.built) {
                throw new IllegalStateException("Builder is single-shot as Network layers cannot be reused");
            }
        }
    }
}

