/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.swarm.Candidate;
import hudson.plugins.swarm.LabelFileWatcher;
import hudson.plugins.swarm.Options;
import hudson.plugins.swarm.RetryException;
import hudson.plugins.swarm.SwarmClient;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public class Client {
    private static final Logger logger = Logger.getLogger(Client.class.getPackage().getName());
    private final Options options;
    private final Thread labelFileWatcherThread = null;

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Suppressed for now")
    public static void main(String ... args) throws InterruptedException, IOException {
        String s = Arrays.toString(args);
        s = s.replaceAll("\n", "");
        s = s.replaceAll("\r", "");
        s = s.replaceAll(",", "");
        logger.info("Client.main invoked with: " + s);
        Options options = new Options();
        Client client = new Client(options);
        CmdLineParser p = new CmdLineParser(options);
        try {
            p.parseArgument(args);
        }
        catch (CmdLineException e) {
            logger.log(Level.SEVERE, "CmdLineException occurred during parseArgument", e);
            p.printUsage(System.out);
            System.exit(-1);
        }
        if (options.help) {
            p.printUsage(System.out);
            System.exit(0);
        }
        if (options.logFile != null) {
            logger.severe("-logFile has been deprecated. Use logging properties file syntax instead: -Djava.util.logging.config.file=" + Paths.get("", new String[0]).toAbsolutePath().toString() + File.separator + "logging.properties");
            System.exit(-1);
        }
        if (options.pidFile != null) {
            String pidName = ManagementFactory.getRuntimeMXBean().getName();
            String[] pidNameParts = pidName.split("@");
            String pid = pidNameParts[0];
            try {
                File pidFile = new File(options.pidFile);
                FileWriter pidFileWriter = new FileWriter(pidFile);
                pidFileWriter.write(pid);
                pidFileWriter.close();
                pidFile.deleteOnExit();
            }
            catch (IOException exception) {
                logger.severe("Failed writing PID file: " + options.pidFile);
                System.exit(-1);
            }
        }
        if (options.passwordEnvVariable != null) {
            options.password = System.getenv(options.passwordEnvVariable);
        }
        if (options.password == null && options.passwordFile != null) {
            options.password = new String(Files.readAllBytes(Paths.get(options.passwordFile, new String[0])), "UTF-8");
        }
        if (options.name == null) {
            try {
                client.options.name = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (IOException e) {
                logger.severe("Failed to lookup the canonical hostname of this slave, please check system settings.");
                logger.severe("If not possible to resolve please specify a node name using the '-name' option");
                System.exit(-1);
            }
        }
        SwarmClient swarmClient = new SwarmClient(options);
        client.run(swarmClient, args);
    }

    public Client(Options options) {
        this.options = options;
        logger.finest("Client created with " + options);
    }

    public void run(SwarmClient swarmClient, String ... args) throws InterruptedException {
        logger.info("Discovering Jenkins master");
        int retry = 0;
        while (true) {
            block13: {
                try {
                    Candidate target;
                    if (this.options.master == null) {
                        logger.info("No Jenkins master supplied on command line, performing auto-discovery");
                        target = swarmClient.discoverFromBroadcast();
                    } else {
                        target = swarmClient.discoverFromMasterUrl();
                    }
                    if (this.options.password == null && this.options.username == null) {
                        swarmClient.verifyThatUrlIsHudson(target);
                    }
                    if (this.options.labelsFile != null && this.labelFileWatcherThread == null) {
                        logger.info("Setting up LabelFileWatcher");
                        LabelFileWatcher l = new LabelFileWatcher(target, this.options, args);
                        Thread labelFileWatcherThread = new Thread((Runnable)l, "LabelFileWatcher");
                        labelFileWatcherThread.setDaemon(true);
                        labelFileWatcherThread.start();
                    }
                    logger.info("Attempting to connect to " + target.url + " " + target.secret + " with ID " + swarmClient.getHash());
                    swarmClient.createSwarmSlave(target);
                    swarmClient.connect(target);
                    if (this.options.noRetryAfterConnected) {
                        logger.warning("Connection closed, exiting...");
                        swarmClient.exitWithStatus(0);
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "IOexception occurred", e);
                    e.printStackTrace();
                }
                catch (ParserConfigurationException e) {
                    logger.log(Level.SEVERE, "ParserConfigurationException occurred", e);
                    e.printStackTrace();
                }
                catch (RetryException e) {
                    logger.log(Level.SEVERE, "RetryException occurred", e);
                    if (e.getCause() == null) break block13;
                    e.getCause().printStackTrace();
                }
            }
            int waitTime = this.options.retryBackOffStrategy.waitForRetry(retry++, this.options.retryInterval, this.options.maxRetryInterval);
            if (this.options.retry >= 0) {
                if (retry >= this.options.retry) {
                    logger.severe("Retry limit reached, exiting...");
                    swarmClient.exitWithStatus(-1);
                } else {
                    logger.warning("Remaining retries: " + (this.options.retry - retry));
                }
            }
            logger.info("Retrying in " + waitTime + " seconds");
            swarmClient.sleepSeconds(waitTime);
        }
    }
}

