/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.ClassParser;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.IllegalAnnotationError;
import org.kohsuke.args4j.Messages;
import org.kohsuke.args4j.NamedOptionDef;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.OptionHandlerFilter;
import org.kohsuke.args4j.ParserProperties;
import org.kohsuke.args4j.spi.BooleanOptionHandler;
import org.kohsuke.args4j.spi.ByteOptionHandler;
import org.kohsuke.args4j.spi.CharOptionHandler;
import org.kohsuke.args4j.spi.DoubleOptionHandler;
import org.kohsuke.args4j.spi.EnumOptionHandler;
import org.kohsuke.args4j.spi.FileOptionHandler;
import org.kohsuke.args4j.spi.FloatOptionHandler;
import org.kohsuke.args4j.spi.InetAddressOptionHandler;
import org.kohsuke.args4j.spi.IntOptionHandler;
import org.kohsuke.args4j.spi.LongOptionHandler;
import org.kohsuke.args4j.spi.MapOptionHandler;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.PathOptionHandler;
import org.kohsuke.args4j.spi.PatternOptionHandler;
import org.kohsuke.args4j.spi.Setter;
import org.kohsuke.args4j.spi.ShortOptionHandler;
import org.kohsuke.args4j.spi.StringOptionHandler;
import org.kohsuke.args4j.spi.URIOptionHandler;
import org.kohsuke.args4j.spi.URLOptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdLineParser {
    private final List<OptionHandler> options = new ArrayList<OptionHandler>();
    private final List<OptionHandler> arguments = new ArrayList<OptionHandler>();
    private boolean parsingOptions = true;
    private OptionHandler currentOptionHandler = null;
    private ParserProperties parserProperties;
    private static final Map<Class, Constructor<? extends OptionHandler>> handlerClasses = Collections.synchronizedMap(new HashMap());

    public CmdLineParser(Object bean) {
        this(bean, ParserProperties.defaults());
    }

    public CmdLineParser(Object bean, ParserProperties parserProperties) {
        this.parserProperties = parserProperties;
        if (bean == null) {
            return;
        }
        new ClassParser().parse(bean, this);
        if (parserProperties.getOptionSorter() != null) {
            Collections.sort(this.options, parserProperties.getOptionSorter());
        }
    }

    public ParserProperties getProperties() {
        return this.parserProperties;
    }

    private static void checkNonNull(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException(name + " is null");
        }
    }

    public void addArgument(Setter setter, Argument a) {
        CmdLineParser.checkNonNull(setter, "Setter");
        CmdLineParser.checkNonNull(a, "Argument");
        OptionHandler h = this.createOptionHandler(new OptionDef(a, setter.isMultiValued()), setter);
        int index = a.index();
        while (index >= this.arguments.size()) {
            this.arguments.add(null);
        }
        if (this.arguments.get(index) != null) {
            throw new IllegalAnnotationError(Messages.MULTIPLE_USE_OF_ARGUMENT.format(index));
        }
        this.arguments.set(index, h);
    }

    public void addOption(Setter setter, Option o) {
        CmdLineParser.checkNonNull(setter, "Setter");
        CmdLineParser.checkNonNull(o, "Option");
        this.checkOptionNotInMap(o.name());
        for (String alias : o.aliases()) {
            this.checkOptionNotInMap(alias);
        }
        this.options.add(this.createOptionHandler(new NamedOptionDef(o), setter));
    }

    public List<OptionHandler> getArguments() {
        return this.arguments;
    }

    public List<OptionHandler> getOptions() {
        return this.options;
    }

    private void checkOptionNotInMap(String name) throws IllegalAnnotationError {
        CmdLineParser.checkNonNull(name, "name");
        if (this.findOptionByName(name) != null) {
            throw new IllegalAnnotationError(Messages.MULTIPLE_USE_OF_OPTION.format(name));
        }
    }

    protected OptionHandler createOptionHandler(OptionDef o, Setter setter) {
        Constructor<? extends OptionHandler> handlerType;
        CmdLineParser.checkNonNull(o, "OptionDef is null");
        CmdLineParser.checkNonNull(setter, "Setter is null");
        Class<? extends OptionHandler> h = o.handler();
        if (h == OptionHandler.class) {
            Class t = setter.getType();
            if (Enum.class.isAssignableFrom(t)) {
                return new EnumOptionHandler(this, o, setter, t);
            }
            handlerType = handlerClasses.get(t);
            if (handlerType == null) {
                throw new IllegalAnnotationError(Messages.UNKNOWN_HANDLER.format(t));
            }
        } else {
            handlerType = CmdLineParser.getConstructor(h);
        }
        try {
            return handlerType.newInstance(this, o, setter);
        }
        catch (InstantiationException e) {
            throw new IllegalAnnotationError(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAnnotationError(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalAnnotationError(e);
        }
    }

    public String printExample(OptionHandlerFilter filter) {
        return this.printExample(filter, null);
    }

    public String printExample(ExampleMode mode) {
        return this.printExample(mode, null);
    }

    public String printExample(OptionHandlerFilter mode, ResourceBundle rb) {
        StringBuilder buf = new StringBuilder();
        CmdLineParser.checkNonNull(mode, "mode");
        for (OptionHandler h : this.options) {
            OptionDef option = h.option;
            if (option.usage().length() == 0 || !mode.select(h)) continue;
            buf.append(' ');
            buf.append(h.getNameAndMeta(rb, this.parserProperties));
        }
        return buf.toString();
    }

    public String printExample(ExampleMode mode, ResourceBundle rb) {
        return this.printExample((OptionHandlerFilter)mode, rb);
    }

    public void printUsage(OutputStream out) {
        this.printUsage(new OutputStreamWriter(out), null);
    }

    public void printUsage(Writer out, ResourceBundle rb) {
        this.printUsage(out, rb, OptionHandlerFilter.PUBLIC);
    }

    public void printUsage(Writer out, ResourceBundle rb, OptionHandlerFilter filter) {
        int curLen;
        PrintWriter w = new PrintWriter(out);
        int len = 0;
        for (OptionHandler h : this.arguments) {
            curLen = this.getPrefixLen(h, rb);
            len = Math.max(len, curLen);
        }
        for (OptionHandler h : this.options) {
            curLen = this.getPrefixLen(h, rb);
            len = Math.max(len, curLen);
        }
        for (OptionHandler h : this.arguments) {
            this.printOption(w, h, len, rb, filter);
        }
        for (OptionHandler h : this.options) {
            this.printOption(w, h, len, rb, filter);
        }
        w.flush();
    }

    protected void printOption(PrintWriter out, OptionHandler handler, int len, ResourceBundle rb, OptionHandlerFilter filter) {
        if (handler.option.usage() == null || handler.option.usage().length() == 0 || !filter.select(handler)) {
            return;
        }
        int totalUsageWidth = this.parserProperties.getUsageWidth();
        int widthMetadata = Math.min(len, (totalUsageWidth - 4) / 2);
        int widthUsage = totalUsageWidth - 4 - widthMetadata;
        List<String> namesAndMetas = this.wrapLines(handler.getNameAndMeta(rb, this.parserProperties), widthMetadata);
        List<String> usages = this.wrapLines(this.localize(handler.option.usage(), rb), widthUsage);
        for (int i = 0; i < Math.max(namesAndMetas.size(), usages.size()); ++i) {
            String nameAndMeta = i >= namesAndMetas.size() ? "" : namesAndMetas.get(i);
            String usage = i >= usages.size() ? "" : usages.get(i);
            String format = nameAndMeta.length() > 0 && i == 0 ? " %1$-" + widthMetadata + "s : %2$-1s" : " %1$-" + widthMetadata + "s   %2$-1s";
            String output = String.format(format, nameAndMeta, usage);
            out.println(output);
        }
    }

    private String localize(String s, ResourceBundle rb) {
        if (rb != null) {
            return rb.getString(s);
        }
        return s;
    }

    private List<String> wrapLines(String line, int maxLength) {
        ArrayList<String> rv = new ArrayList<String>();
        for (String restOfLine : line.split("\\n")) {
            while (restOfLine.length() > maxLength) {
                String candidate = restOfLine.substring(0, maxLength);
                int sp = candidate.lastIndexOf(32);
                int lineLength = sp > maxLength * 3 / 5 ? sp : maxLength;
                rv.add(restOfLine.substring(0, lineLength));
                restOfLine = restOfLine.substring(lineLength).trim();
            }
            rv.add(restOfLine);
        }
        return rv;
    }

    private int getPrefixLen(OptionHandler h, ResourceBundle rb) {
        if (h.option.usage().length() == 0) {
            return 0;
        }
        return h.getNameAndMeta(rb, this.parserProperties).length();
    }

    private String getOptionName() {
        return this.currentOptionHandler.option.toString();
    }

    public void parseArgument(Collection<String> args) throws CmdLineException {
        this.parseArgument(args.toArray(new String[args.size()]));
    }

    public void parseArgument(String ... args) throws CmdLineException {
        CmdLineParser.checkNonNull(args, "args");
        String[] expandedArgs = this.expandAtFiles(args);
        CmdLineImpl cmdLine = new CmdLineImpl(expandedArgs);
        HashSet<OptionHandler> present = new HashSet<OptionHandler>();
        int argIndex = 0;
        while (cmdLine.hasMore()) {
            String arg = cmdLine.getCurrentToken();
            if (this.isOption(arg)) {
                boolean isKeyValuePair = arg.contains(this.parserProperties.getOptionValueDelimiter()) || arg.indexOf(61) != -1;
                OptionHandler optionHandler = this.currentOptionHandler = isKeyValuePair ? this.findOptionHandler(arg) : this.findOptionByName(arg);
                if (this.currentOptionHandler == null) {
                    throw new CmdLineException(this, Messages.UNDEFINED_OPTION, arg);
                }
                if (isKeyValuePair) {
                    cmdLine.splitToken();
                } else {
                    cmdLine.proceed(1);
                }
            } else {
                if (argIndex >= this.arguments.size()) {
                    Messages msg = this.arguments.size() == 0 ? Messages.NO_ARGUMENT_ALLOWED : Messages.TOO_MANY_ARGUMENTS;
                    throw new CmdLineException(this, msg, arg);
                }
                this.currentOptionHandler = this.arguments.get(argIndex);
                if (this.currentOptionHandler == null) {
                    throw new IllegalStateException("@Argument with index=" + argIndex + " is undefined");
                }
                if (!this.currentOptionHandler.option.isMultiValued()) {
                    ++argIndex;
                }
            }
            int diff = this.currentOptionHandler.parseArguments(cmdLine);
            cmdLine.proceed(diff);
            present.add(this.currentOptionHandler);
        }
        boolean helpSet = false;
        for (OptionHandler handler : this.options) {
            if (!handler.option.help() || !present.contains(handler)) continue;
            helpSet = true;
        }
        if (!helpSet) {
            this.checkRequiredOptionsAndArguments(present);
        }
    }

    private String[] expandAtFiles(String[] args) throws CmdLineException {
        ArrayList<String> result = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("@")) {
                File file = new File(arg.substring(1));
                if (!file.exists()) {
                    throw new CmdLineException(this, Messages.NO_SUCH_FILE, file.getPath());
                }
                try {
                    result.addAll(CmdLineParser.readAllLines(file));
                    continue;
                }
                catch (IOException ex) {
                    throw new CmdLineException(this, "Failed to parse " + file, ex);
                }
            }
            result.add(arg);
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readAllLines(File f) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(f));
        try {
            String line;
            ArrayList<String> result = new ArrayList<String>();
            while ((line = r.readLine()) != null) {
                result.add(line);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            r.close();
        }
    }

    private void checkRequiredOptionsAndArguments(Set<OptionHandler> present) throws CmdLineException {
        for (OptionHandler handler : this.options) {
            if (!handler.option.required() || present.contains(handler)) continue;
            throw new CmdLineException(this, Messages.REQUIRED_OPTION_MISSING, handler.option.toString());
        }
        for (OptionHandler handler : this.arguments) {
            if (!handler.option.required() || present.contains(handler)) continue;
            throw new CmdLineException(this, Messages.REQUIRED_ARGUMENT_MISSING, handler.option.toString());
        }
        for (OptionHandler handler : present) {
            if (!(handler.option instanceof NamedOptionDef) || this.isHandlerHasHisOptions((NamedOptionDef)handler.option, present)) continue;
            throw new CmdLineException(this, Messages.REQUIRES_OPTION_MISSING, handler.option.toString(), Arrays.toString(((NamedOptionDef)handler.option).depends()));
        }
        for (OptionHandler handler : present) {
            if (!(handler.option instanceof NamedOptionDef) || this.isHandlerAllowOtherOptions((NamedOptionDef)handler.option, present)) continue;
            throw new CmdLineException(this, Messages.FORBIDDEN_OPTION_PRESENT, handler.option.toString(), Arrays.toString(((NamedOptionDef)handler.option).forbids()));
        }
    }

    private boolean isHandlerHasHisOptions(NamedOptionDef option, Set<OptionHandler> present) {
        for (String depend : option.depends()) {
            if (present.contains(this.findOptionHandler(depend))) continue;
            return false;
        }
        return true;
    }

    private boolean isHandlerAllowOtherOptions(NamedOptionDef option, Set<OptionHandler> present) {
        for (String forbid : option.forbids()) {
            if (!present.contains(this.findOptionHandler(forbid))) continue;
            return false;
        }
        return true;
    }

    private OptionHandler findOptionHandler(String name) {
        int pos = name.indexOf(this.parserProperties.getOptionValueDelimiter());
        if (pos < 0) {
            pos = name.indexOf(61);
        }
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        return this.findOptionByName(name);
    }

    private OptionHandler findOptionByName(String name) {
        for (OptionHandler h : this.options) {
            NamedOptionDef option = (NamedOptionDef)h.option;
            if (name.equals(option.name())) {
                return h;
            }
            for (String alias : option.aliases()) {
                if (!name.equals(alias)) continue;
                return h;
            }
        }
        return null;
    }

    protected boolean isOption(String arg) {
        CmdLineParser.checkNonNull(arg, "arg");
        return this.parsingOptions && arg.startsWith("-");
    }

    public static void registerHandler(Class valueType, Class<? extends OptionHandler> handlerClass) {
        CmdLineParser.checkNonNull(valueType, "valueType");
        CmdLineParser.checkNonNull(handlerClass, "handlerClass");
        if (!OptionHandler.class.isAssignableFrom(handlerClass)) {
            throw new IllegalArgumentException(Messages.NO_OPTIONHANDLER.format(new Object[0]));
        }
        Constructor<? extends OptionHandler> c = CmdLineParser.getConstructor(handlerClass);
        handlerClasses.put(valueType, c);
    }

    private static Constructor<? extends OptionHandler> getConstructor(Class<? extends OptionHandler> handlerClass) {
        try {
            return handlerClass.getConstructor(CmdLineParser.class, OptionDef.class, Setter.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(Messages.NO_CONSTRUCTOR_ON_HANDLER.format(handlerClass));
        }
    }

    public void setUsageWidth(int usageWidth) {
        this.parserProperties.withUsageWidth(usageWidth);
    }

    public void stopOptionParsing() {
        this.parsingOptions = false;
    }

    public void printSingleLineUsage(OutputStream out) {
        CmdLineParser.checkNonNull(out, "OutputStream");
        this.printSingleLineUsage(new OutputStreamWriter(out), null);
    }

    public void printSingleLineUsage(Writer w, ResourceBundle rb) {
        CmdLineParser.checkNonNull(w, "Writer");
        PrintWriter pw = new PrintWriter(w);
        for (OptionHandler h : this.arguments) {
            this.printSingleLineOption(pw, h, rb);
        }
        for (OptionHandler h : this.options) {
            this.printSingleLineOption(pw, h, rb);
        }
        pw.flush();
    }

    private void printSingleLineOption(PrintWriter pw, OptionHandler h, ResourceBundle rb) {
        pw.print(' ');
        if (!h.option.required()) {
            pw.print('[');
        }
        pw.print(h.getNameAndMeta(rb, this.parserProperties));
        if (h.option.isMultiValued()) {
            pw.print(" ...");
        }
        if (!h.option.required()) {
            pw.print(']');
        }
    }

    static {
        CmdLineParser.registerHandler(Boolean.class, BooleanOptionHandler.class);
        CmdLineParser.registerHandler(Boolean.TYPE, BooleanOptionHandler.class);
        CmdLineParser.registerHandler(File.class, FileOptionHandler.class);
        CmdLineParser.registerHandler(URL.class, URLOptionHandler.class);
        CmdLineParser.registerHandler(URI.class, URIOptionHandler.class);
        CmdLineParser.registerHandler(Integer.class, IntOptionHandler.class);
        CmdLineParser.registerHandler(Integer.TYPE, IntOptionHandler.class);
        CmdLineParser.registerHandler(Double.class, DoubleOptionHandler.class);
        CmdLineParser.registerHandler(Double.TYPE, DoubleOptionHandler.class);
        CmdLineParser.registerHandler(String.class, StringOptionHandler.class);
        CmdLineParser.registerHandler(Byte.class, ByteOptionHandler.class);
        CmdLineParser.registerHandler(Byte.TYPE, ByteOptionHandler.class);
        CmdLineParser.registerHandler(Character.class, CharOptionHandler.class);
        CmdLineParser.registerHandler(Character.TYPE, CharOptionHandler.class);
        CmdLineParser.registerHandler(Float.class, FloatOptionHandler.class);
        CmdLineParser.registerHandler(Float.TYPE, FloatOptionHandler.class);
        CmdLineParser.registerHandler(Long.class, LongOptionHandler.class);
        CmdLineParser.registerHandler(Long.TYPE, LongOptionHandler.class);
        CmdLineParser.registerHandler(Short.class, ShortOptionHandler.class);
        CmdLineParser.registerHandler(Short.TYPE, ShortOptionHandler.class);
        CmdLineParser.registerHandler(InetAddress.class, InetAddressOptionHandler.class);
        CmdLineParser.registerHandler(Pattern.class, PatternOptionHandler.class);
        CmdLineParser.registerHandler(Map.class, MapOptionHandler.class);
        try {
            Class<?> p = Class.forName("java.nio.file.Path");
            CmdLineParser.registerHandler(p, PathOptionHandler.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private class CmdLineImpl
    implements Parameters {
        private final String[] args;
        private int pos;

        CmdLineImpl(String[] args) {
            this.args = args;
            this.pos = 0;
        }

        protected boolean hasMore() {
            return this.pos < this.args.length;
        }

        protected String getCurrentToken() {
            return this.args[this.pos];
        }

        private void proceed(int n) {
            this.pos += n;
        }

        public String getParameter(int idx) throws CmdLineException {
            if (this.pos + idx >= this.args.length || this.pos + idx < 0) {
                throw new CmdLineException(CmdLineParser.this, Messages.MISSING_OPERAND, CmdLineParser.this.getOptionName());
            }
            return this.args[this.pos + idx];
        }

        public int size() {
            return this.args.length - this.pos;
        }

        void splitToken() {
            int idx;
            if (this.pos < this.args.length && this.pos >= 0 && (idx = this.args[this.pos].indexOf("=")) > 0) {
                this.args[this.pos] = this.args[this.pos].substring(idx + 1);
            }
        }
    }
}

