/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.protocol.impl;

import hudson.remoting.AbstractByteBufferCommandTransport;
import hudson.remoting.BinarySafeStream;
import hudson.remoting.Capability;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.ChannelClosedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.remoting.protocol.ApplicationLayer;
import org.jenkinsci.remoting.util.ByteBufferUtils;
import org.jenkinsci.remoting.util.SettableFuture;
import org.jenkinsci.remoting.util.ThrowableUtils;

public class ChannelApplicationLayer
extends ApplicationLayer<Future<Channel>> {
    private final ExecutorService executorService;
    private final SettableFuture<Channel> futureChannel = SettableFuture.create();
    @Nullable
    private AbstractByteBufferCommandTransport transport;
    @CheckForNull
    private Channel channel;
    private ByteBuffer capabilityLength = ByteBuffer.allocate(2);
    private ByteBuffer capabilityContent;
    private Listener listener;

    public ChannelApplicationLayer(@Nonnull ExecutorService executorService, @CheckForNull Listener listener) {
        this.executorService = executorService;
        this.listener = listener;
    }

    @Override
    public Future<Channel> get() {
        return this.futureChannel;
    }

    @Override
    public boolean isReadOpen() {
        return this.channel == null || !this.channel.isInClosed();
    }

    @Override
    public void onRead(@Nonnull ByteBuffer data) throws IOException {
        if (!this.futureChannel.isDone()) {
            assert (this.channel == null && this.transport == null && this.capabilityLength != null);
            if (this.capabilityLength.hasRemaining()) {
                ByteBufferUtils.put(data, this.capabilityLength);
                if (this.capabilityLength.hasRemaining()) {
                    return;
                }
                this.capabilityContent = ByteBuffer.allocate(((this.capabilityLength.get(0) & 0xFF) << 8) + (this.capabilityLength.get(1) & 0xFF));
            }
            assert (this.capabilityContent != null);
            if (this.capabilityContent.hasRemaining()) {
                ByteBufferUtils.put(data, this.capabilityContent);
                if (this.capabilityContent.hasRemaining()) {
                    return;
                }
                byte[] capabilityBytes = new byte[this.capabilityContent.capacity()];
                this.capabilityContent.flip();
                this.capabilityContent.get(capabilityBytes);
                if (this.capabilityContent.hasRemaining()) {
                    return;
                }
                Capability remoteCapability = Capability.read(new ByteArrayInputStream(capabilityBytes));
                this.transport = new ByteBufferCommandTransport(remoteCapability);
                try {
                    ChannelBuilder builder = new ChannelBuilder(this.stack().name(), this.executorService).withMode(Channel.Mode.BINARY);
                    this.channel = this.listener instanceof ChannelDecorator ? this.decorate(((ChannelDecorator)this.listener).decorate(builder)).build(this.transport) : this.decorate(builder).build(this.transport);
                }
                catch (IOException e) {
                    try {
                        this.doCloseWrite();
                    }
                    catch (IOException suppressed) {
                        ThrowableUtils.addSuppressed(e, suppressed);
                    }
                    this.transport = null;
                    this.futureChannel.setException(e);
                    throw e;
                }
                this.futureChannel.set(this.channel);
                this.capabilityContent = null;
                this.capabilityLength = null;
                if (this.listener != null) {
                    this.listener.onChannel(this.channel);
                }
            }
        }
        if (this.channel == null) {
            assert (this.futureChannel.isDone());
            try {
                this.channel = this.futureChannel.get();
            }
            catch (InterruptedException e) {
                data.position(data.limit());
                throw new IOException(e);
            }
            catch (ExecutionException e) {
                data.position(data.limit());
                throw new IOException(e);
            }
        }
        assert (this.channel != null && this.transport != null) : "If futureChannel.isDone() then we have a channel and transport";
        try {
            this.transport.receive(data);
        }
        catch (IOException e) {
            this.channel.terminate(e);
            data.position(data.limit());
            throw e;
        }
        catch (InterruptedException e) {
            IOException reason = new IOException(e);
            this.channel.terminate(reason);
            data.position(data.limit());
            throw reason;
        }
    }

    @Override
    public void onReadClosed(IOException cause) throws IOException {
        if (this.futureChannel.isDone()) {
            if (this.channel != null) {
                this.channel.terminate(cause == null ? new ClosedChannelException() : cause);
            }
        } else {
            this.futureChannel.setException(cause == null ? new ClosedChannelException() : cause);
        }
    }

    @Override
    public void start() throws IOException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(BinarySafeStream.wrap(bos));){
                oos.writeObject(new Capability());
            }
            ByteBuffer buffer = ByteBufferUtils.wrapUTF8(bos.toString("US-ASCII"));
            this.write(buffer);
        }
        catch (IOException e) {
            this.futureChannel.setException(e);
        }
    }

    public ChannelBuilder decorate(ChannelBuilder builder) {
        return builder;
    }

    private class ByteBufferCommandTransport
    extends AbstractByteBufferCommandTransport {
        private final Capability remoteCapability;

        public ByteBufferCommandTransport(Capability remoteCapability) {
            this.remoteCapability = remoteCapability;
        }

        @Override
        protected void write(ByteBuffer header, ByteBuffer data) throws IOException {
            if (ChannelApplicationLayer.this.isWriteOpen()) {
                try {
                    ChannelApplicationLayer.this.write(header);
                    ChannelApplicationLayer.this.write(data);
                }
                catch (ClosedChannelException e) {
                    throw new ChannelClosedException(e);
                }
            } else {
                throw new ChannelClosedException(new ClosedChannelException());
            }
        }

        @Override
        public void closeWrite() throws IOException {
            ChannelApplicationLayer.this.doCloseWrite();
        }

        @Override
        public void closeRead() throws IOException {
            ChannelApplicationLayer.this.doCloseRead();
        }

        @Override
        public Capability getRemoteCapability() throws IOException {
            return this.remoteCapability;
        }
    }

    public static interface ChannelDecorator
    extends Listener {
        @Nonnull
        public ChannelBuilder decorate(@Nonnull ChannelBuilder var1);
    }

    public static interface Listener {
        public void onChannel(@Nonnull Channel var1);
    }
}

