/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.IReadResolve;
import hudson.remoting.JarLoader;
import hudson.remoting.RemoteClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

class MultiClassLoaderSerializer {
    private static final int TAG_SYSTEMCLASSLOADER = -3;
    private static final int TAG_EXPORTED_CLASSLOADER = -2;
    private static final int TAG_LOCAL_CLASSLOADER = -1;

    MultiClassLoaderSerializer() {
    }

    static final class Input
    extends ObjectInputStream {
        private final Channel channel;
        private final List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();

        Input(Channel channel, InputStream in) throws IOException {
            super(in);
            this.channel = channel;
        }

        private ClassLoader readClassLoader() throws IOException, ClassNotFoundException {
            int code = this.readInt();
            switch (code) {
                case -3: {
                    return null;
                }
                case -1: {
                    Object proxyObject;
                    int oid = this.readInt();
                    try {
                        proxyObject = this.channel.getExportedObject(oid);
                    }
                    catch (ExecutionException ex) {
                        throw new IOException("Cannot locate RemoteClassLoader.ClassLoaderProxy(" + oid + ") in the channel exported table", ex);
                    }
                    ClassLoader cl = ((RemoteClassLoader.ClassLoaderProxy)proxyObject).cl;
                    this.classLoaders.add(cl);
                    return cl;
                }
                case -2: {
                    ClassLoader cl = this.channel.importedClassLoaders.get(this.readInt());
                    this.classLoaders.add(cl);
                    return cl;
                }
            }
            return this.classLoaders.get(code);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            this.channel.classFilter.check(name);
            try {
                ClassLoader cl = this.readClassLoader();
                Class<?> c = Class.forName(name, false, cl);
                this.channel.classFilter.check(c);
                return c;
            }
            catch (ClassNotFoundException ex) {
                return super.resolveClass(desc);
            }
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            ClassLoader cl = this.readClassLoader();
            Class[] classes = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                classes[i] = Class.forName(interfaces[i], false, cl);
            }
            if (classes.length == 2 && classes[0] == JarLoader.class && classes[1] == IReadResolve.class) {
                return Channel.jarLoaderProxy;
            }
            return Proxy.getProxyClass(cl, classes);
        }
    }

    static final class Output
    extends ObjectOutputStream {
        private final Channel channel;
        private final Map<ClassLoader, Integer> classLoaders = new HashMap<ClassLoader, Integer>();

        Output(Channel channel, OutputStream out) throws IOException {
            super(out);
            this.channel = channel;
        }

        @Override
        protected void annotateClass(Class<?> c) throws IOException {
            ClassLoader cl = c.getClassLoader();
            if (cl == null) {
                this.writeInt(-3);
                return;
            }
            Integer idx = this.classLoaders.get(cl);
            if (idx == null) {
                int oid;
                this.classLoaders.put(cl, this.classLoaders.size());
                if (cl instanceof RemoteClassLoader && (oid = ((RemoteClassLoader)cl).getOid(this.channel)) >= 0) {
                    this.writeInt(-1);
                    this.writeInt(oid);
                    return;
                }
                this.writeInt(-2);
                this.writeInt(RemoteClassLoader.exportId(cl, this.channel));
            } else {
                this.writeInt(idx);
            }
        }

        @Override
        protected void annotateProxyClass(Class<?> cl) throws IOException {
            this.annotateClass(cl);
        }
    }
}

