/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.Checksum;
import hudson.remoting.JarCacheSupport;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;

public class FileSystemJarCache
extends JarCacheSupport {
    public final File rootDir;
    private final boolean touch;
    private final Set<Checksum> notified = Collections.synchronizedSet(new HashSet());
    @GuardedBy(value="itself")
    private final Map<String, Checksum> checksumsByPath = new HashMap<String, Checksum>();
    private static final Logger LOGGER = Logger.getLogger(FileSystemJarCache.class.getName());

    public FileSystemJarCache(@Nonnull File rootDir, boolean touch) {
        this.rootDir = rootDir;
        this.touch = touch;
        if (rootDir == null) {
            throw new IllegalArgumentException("Root directory is null");
        }
        try {
            Util.mkdirs(rootDir);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Root directory not writable: " + rootDir, ex);
        }
    }

    public String toString() {
        return String.format("FileSystem JAR Cache: path=%s, touch=%s", this.rootDir, Boolean.toString(this.touch));
    }

    @Override
    protected URL lookInCache(Channel channel, long sum1, long sum2) throws IOException, InterruptedException {
        File jar = this.map(sum1, sum2);
        if (jar.exists()) {
            LOGGER.log(Level.FINER, String.format("Jar file cache hit %16X%16X", sum1, sum2));
            if (this.touch) {
                jar.setLastModified(System.currentTimeMillis());
            }
            if (this.notified.add(new Checksum(sum1, sum2))) {
                this.getJarLoader(channel).notifyJarPresence(sum1, sum2);
            }
            return jar.toURI().toURL();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected URL retrieve(Channel channel, long sum1, long sum2) throws IOException, InterruptedException {
        URL uRL;
        Checksum expected = new Checksum(sum1, sum2);
        File target = this.map(sum1, sum2);
        if (target.exists()) {
            Checksum actual = this.fileChecksum(target);
            if (expected.equals(actual)) {
                LOGGER.fine(String.format("Jar file already exists: %s", expected));
                return target.toURI().toURL();
            }
            LOGGER.warning(String.format("Cached file checksum mismatch: %s%nExpected: %s%n Actual: %s", target.getAbsolutePath(), expected, actual));
            target.delete();
            Map<String, Checksum> map = this.checksumsByPath;
            synchronized (map) {
                this.checksumsByPath.remove(target.getCanonicalPath());
            }
        }
        File tmp = this.createTempJar(target);
        try {
            try (RemoteOutputStream o = new RemoteOutputStream(new FileOutputStream(tmp));){
                LOGGER.log(Level.FINE, String.format("Retrieving jar file %16X%16X", sum1, sum2));
                this.getJarLoader(channel).writeJarTo(sum1, sum2, o);
            }
            Checksum actual = Checksum.forFile(tmp);
            if (!expected.equals(actual)) {
                throw new IOException(String.format("Incorrect checksum of retrieved jar: %s%nExpected: %s%nActual: %s", tmp.getAbsolutePath(), expected, actual));
            }
            if (!tmp.renameTo(target)) {
                if (!target.exists()) {
                    throw new IOException("Unable to create " + target + " from " + tmp);
                }
                actual = this.fileChecksum(target);
                if (!expected.equals(actual)) {
                    throw new IOException(String.format("Incorrect checksum of previous jar: %s%nExpected: %s%nActual: %s", target.getAbsolutePath(), expected, actual));
                }
            }
            uRL = target.toURI().toURL();
            tmp.delete();
        }
        catch (Throwable throwable) {
            try {
                tmp.delete();
                throw throwable;
            }
            catch (IOException e) {
                throw (IOException)new IOException("Failed to write to " + target).initCause(e);
            }
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Checksum fileChecksum(File file) throws IOException {
        String location = file.getCanonicalPath();
        Map<String, Checksum> map = this.checksumsByPath;
        synchronized (map) {
            Checksum checksum = this.checksumsByPath.get(location);
            if (checksum != null) {
                return checksum;
            }
            checksum = Checksum.forFile(file);
            this.checksumsByPath.put(location, checksum);
            return checksum;
        }
    }

    File createTempJar(@Nonnull File target) throws IOException {
        File parent = target.getParentFile();
        Util.mkdirs(parent);
        return File.createTempFile(target.getName(), "tmp", parent);
    }

    File map(long sum1, long sum2) {
        return new File(this.rootDir, String.format("%02X/%014X%016X.jar", (int)(sum1 >>> 56), sum1 & 0xFFFFFFFFFFFFFFL, sum2));
    }
}

