/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.jenkinsci.remoting.util.ByteBufferQueue;

public class ByteBufferQueueInputStream
extends InputStream {
    private final ByteBufferQueue queue;
    private final int length;
    private int pos;
    private ByteBuffer mark = null;

    public ByteBufferQueueInputStream(ByteBufferQueue queue) {
        this.queue = queue;
        this.length = -1;
    }

    public ByteBufferQueueInputStream(ByteBufferQueue queue, int length) {
        this.queue = queue;
        this.length = length;
    }

    @Override
    public int read() throws IOException {
        if (this.length != -1) {
            if (this.pos >= this.length) {
                return -1;
            }
            if (this.mark != null) {
                if (this.mark.hasRemaining()) {
                    ++this.pos;
                    byte b = this.queue.get();
                    this.mark.put(b);
                    return b & 0xFF;
                }
                this.mark = null;
            }
            ++this.pos;
            return this.queue.get() & 0xFF;
        }
        try {
            byte b = this.queue.get();
            ++this.pos;
            if (this.mark != null) {
                if (this.mark.hasRemaining()) {
                    this.mark.put(b);
                } else {
                    this.mark = null;
                }
            }
            return b & 0xFF;
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    @Override
    public int read(@NonNull byte[] b, int off, int len) throws IOException {
        int read;
        if (this.length != -1) {
            int rem = this.length - this.pos;
            if (rem <= 0) {
                return -1;
            }
            if (len > rem) {
                len = rem;
            }
        }
        if ((read = this.queue.get(b, off, len)) <= 0) {
            return -1;
        }
        this.pos += read;
        if (this.mark != null) {
            if (this.mark.remaining() > read) {
                this.mark.put(b, off, read);
            } else {
                this.mark = null;
            }
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.mark == null || (long)this.mark.remaining() < n) {
            this.mark = null;
            if (this.length != -1) {
                if (this.pos >= this.length) {
                    return -1L;
                }
                if ((long)this.pos + n >= (long)this.length) {
                    n = this.length - this.pos;
                }
            }
            long skipped = this.queue.skip(n);
            this.pos = (int)((long)this.pos + skipped);
            return skipped;
        }
        int l = this.mark.limit();
        int p = this.mark.position();
        ((Buffer)this.mark).limit(this.mark.position() + (int)n);
        this.queue.get(this.mark);
        int skipped = this.mark.position() - p;
        ((Buffer)this.mark).limit(l);
        return skipped;
    }

    @Override
    public int available() throws IOException {
        if (this.length == -1) {
            long remaining = this.queue.remaining();
            return remaining > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)remaining;
        }
        return this.pos >= this.length ? -1 : this.length - this.pos;
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.mark != null && this.mark.capacity() <= readlimit) {
            ((Buffer)this.mark).clear();
            ((Buffer)this.mark).limit(readlimit);
            return;
        }
        this.mark = ByteBuffer.allocate(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark == null) {
            throw new IOException();
        }
        ((Buffer)this.mark).flip();
        this.pos -= this.mark.remaining();
        this.queue.unget(this.mark);
        ((Buffer)this.mark).clear();
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

