/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.remoting.Channel;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.jenkinsci.remoting.engine.JnlpConnectionState;
import org.jenkinsci.remoting.engine.JnlpConnectionStateListener;
import org.jenkinsci.remoting.engine.JnlpProtocol4Handler;
import org.jenkinsci.remoting.engine.JnlpProtocolHandler;

public final class JnlpProtocol4ProxyHandler
extends JnlpProtocolHandler<JnlpConnectionState> {
    public static final String NAME = "JNLP4-connect-proxy";
    private static final Logger LOGGER = Logger.getLogger(JnlpProtocol4ProxyHandler.class.getName());
    private final JnlpProtocol4Handler delegate;

    public JnlpProtocol4ProxyHandler(JnlpProtocol4Handler delegate) {
        super(null, false);
        this.delegate = delegate;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    @NonNull
    public Future<Channel> connect(@NonNull Socket socket, @NonNull Map<String, String> headers, @NonNull List<? extends JnlpConnectionStateListener> listeners) throws IOException {
        LOGGER.fine("sending my name");
        DataOutputStream dos = new DataOutputStream(socket.getOutputStream());
        dos.writeUTF("Protocol:JNLP4-connect-proxy");
        LOGGER.fine(() -> "connecting with headers " + headers);
        String nodeName = headers.get("Node-Name");
        if (nodeName == null) {
            throw new IOException("expecting Node-Name");
        }
        PrintStream ps = new PrintStream(socket.getOutputStream(), true, StandardCharsets.UTF_8);
        ps.println("Node-Name: " + nodeName);
        ps.println();
        LOGGER.fine("sent headers, now delegating to regular protocol");
        return this.delegate.connect(socket, headers, listeners);
    }

    @Override
    @NonNull
    public Future<Channel> handle(@NonNull Socket socket, @NonNull Map<String, String> headers, @NonNull List<? extends JnlpConnectionStateListener> listeners) throws IOException {
        throw new UnsupportedOperationException("unused, API design mistake");
    }

    @Override
    @NonNull
    protected JnlpConnectionState createConnectionState(@NonNull Socket socket, @NonNull List<? extends JnlpConnectionStateListener> listeners) throws IOException {
        throw new UnsupportedOperationException("unused, API design mistake");
    }
}

