/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jenkinsci.remoting.util.AnonymousClassWarnings;

public abstract class ClassFilter {
    @Deprecated
    public static final String FILE_OVERRIDE_LOCATION_PROPERTY = "hudson.remoting.ClassFilter.DEFAULTS_OVERRIDE_LOCATION";
    private static final Logger LOGGER = Logger.getLogger(ClassFilter.class.getName());
    private static final String[] DEFAULT_PATTERNS = new String[]{"^bsh[.].*", "^com[.]google[.]inject[.].*", "^com[.]mchange[.]v2[.]c3p0[.].*", "^com[.]sun[.]jndi[.].*", "^com[.]sun[.]corba[.].*", "^com[.]sun[.]javafx[.].*", "^com[.]sun[.]org[.]apache[.]regex[.]internal[.].*", "^java[.]awt[.].*", "^java[.]lang[.]reflect[.]Method$", "^java[.]rmi[.].*", "^javax[.]management[.].*", "^javax[.]naming[.].*", "^javax[.]script[.].*", "^javax[.]swing[.].*", "^net[.]sf[.]json[.].*", "^org[.]apache[.]commons[.]beanutils[.].*", "^org[.]apache[.]commons[.]collections[.]functors[.].*", "^org[.]apache[.]myfaces[.].*", "^org[.]apache[.]wicket[.].*", ".*org[.]apache[.]xalan.*", "^org[.]codehaus[.]groovy[.]runtime[.].*", "^org[.]hibernate[.].*", "^org[.]python[.].*", "^org[.]springframework[.](?!(\\p{Alnum}+[.])*\\p{Alnum}*Exception$).*", "^sun[.]rmi[.].*", "^javax[.]imageio[.].*", "^java[.]util[.]ServiceLoader$", "^java[.]net[.]URLClassLoader$", "^java[.]security[.]SignedObject$"};
    public static final ClassFilter DEFAULT = new ClassFilter(){

        @Override
        public boolean isBlacklisted(@NonNull Class<?> c) {
            return CURRENT_DEFAULT.isBlacklisted(c);
        }

        @Override
        public boolean isBlacklisted(@NonNull String name) {
            return CURRENT_DEFAULT.isBlacklisted(name);
        }
    };
    @NonNull
    private static ClassFilter CURRENT_DEFAULT;
    public static final ClassFilter STANDARD;
    public static final ClassFilter NONE;

    public boolean isBlacklisted(@NonNull String name) {
        return false;
    }

    public boolean isBlacklisted(@NonNull Class<?> c) {
        return false;
    }

    public final String check(String name) {
        if (this.isBlacklisted(name)) {
            throw new SecurityException("Rejected: " + name + "; see https://jenkins.io/redirect/class-filter/");
        }
        return name;
    }

    public final Class<?> check(Class<?> c) {
        if (this.isBlacklisted(c)) {
            throw new SecurityException("Rejected: " + c.getName() + "; see https://jenkins.io/redirect/class-filter/");
        }
        return c;
    }

    public static void setDefault(@NonNull ClassFilter filter) {
        CURRENT_DEFAULT = filter;
    }

    @Deprecated
    public static void appendDefaultFilter(Pattern filter) throws ClassFilterException {
        if (System.getProperty(FILE_OVERRIDE_LOCATION_PROPERTY) == null) {
            ((RegExpClassFilter)STANDARD).add(filter.toString());
        }
    }

    static ClassFilter createDefaultInstance() throws ClassFilterException {
        try {
            List<String> patternOverride = ClassFilter.loadPatternOverride();
            if (patternOverride != null) {
                LOGGER.log(Level.FINE, "Using user specified overrides for class blacklisting");
                return new RegExpClassFilter(patternOverride.toArray(new String[0]));
            }
            LOGGER.log(Level.FINE, "Using default in built class blacklisting");
            return new RegExpClassFilter(DEFAULT_PATTERNS);
        }
        catch (Error e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize the default class filter", e);
            throw e;
        }
    }

    @CheckForNull
    private static List<String> loadPatternOverride() {
        String prop = System.getProperty(FILE_OVERRIDE_LOCATION_PROPERTY);
        if (prop == null) {
            return null;
        }
        LOGGER.log(Level.FINE, "Attempting to load user provided overrides for ClassFiltering from ''{0}''.", prop);
        File f = new File(prop);
        if (!f.exists() || !f.canRead()) {
            throw new Error("Could not load user provided overrides for ClassFiltering from as " + prop + " does not exist or is not readable.");
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(prop), Charset.defaultCharset()));
            ArrayList<String> patterns = new ArrayList<String>();
            String line = br.readLine();
            while (line != null) {
                try {
                    Pattern.compile(line);
                    patterns.add(line);
                }
                catch (PatternSyntaxException pex) {
                    throw new Error("Error compiling blacklist expressions - '" + line + "' is not a valid regular expression.", pex);
                }
                line = br.readLine();
            }
            ArrayList<String> arrayList = patterns;
            return arrayList;
        }
        catch (IOException ex) {
            throw new Error("Could not load user provided overrides for ClassFiltering from as " + prop + " does not exist or is not readable.", ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioEx) {
                    LOGGER.log(Level.WARNING, "Failed to cleanly close input stream", ioEx);
                }
            }
        }
    }

    static {
        try {
            STANDARD = ClassFilter.createDefaultInstance();
        }
        catch (ClassFilterException ex) {
            LOGGER.log(Level.SEVERE, "Default class filter cannot be initialized. Remoting will not start", ex);
            throw new ExceptionInInitializerError(ex);
        }
        CURRENT_DEFAULT = STANDARD;
        NONE = new ClassFilter(){};
    }

    @SuppressFBWarnings(value={"REDOS"}, justification="In an odd usage, this pattern is used to determine if another pattern matches it and not to match a string to it. REDOS doesn't apply.")
    private static final class RegExpClassFilter
    extends ClassFilter {
        private static final Pattern OPTIMIZE1 = Pattern.compile("^\\^(([\\p{L}_$][\\p{L}\\p{N}_$]*(\\.|\\[\\.\\])?)+)\\.\\*$");
        private static final Pattern OPTIMIZE2 = Pattern.compile("^\\^\\Q[^\\\\]+\\\\E\\.\\*$");
        private final List<Object> blacklistPatterns;

        RegExpClassFilter(String[] patterns) throws ClassFilterException {
            this.blacklistPatterns = new ArrayList<Object>(patterns.length);
            for (String pattern : patterns) {
                this.add(pattern);
            }
        }

        void add(String pattern) throws ClassFilterException {
            if (OPTIMIZE1.matcher(pattern).matches()) {
                this.blacklistPatterns.add(pattern.substring(1, pattern.length() - 2).replace("[.]", "."));
            } else if (OPTIMIZE2.matcher(pattern).matches()) {
                this.blacklistPatterns.add(pattern.substring(3, pattern.length() - 4));
            } else {
                Pattern regex;
                try {
                    regex = Pattern.compile(pattern);
                }
                catch (PatternSyntaxException ex) {
                    throw new ClassFilterException("Cannot add RegExp class filter", ex);
                }
                this.blacklistPatterns.add(regex);
            }
        }

        @Override
        public boolean isBlacklisted(@NonNull String name) {
            for (Object p : this.blacklistPatterns) {
                if (p instanceof Pattern && ((Pattern)p).matcher(name).matches()) {
                    return true;
                }
                if (!(p instanceof String) || !name.startsWith((String)p)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isBlacklisted(@NonNull Class<?> c) {
            AnonymousClassWarnings.check(c);
            return false;
        }

        public String toString() {
            return this.blacklistPatterns.toString();
        }
    }

    @Deprecated
    public static class ClassFilterException
    extends Exception {
        @CheckForNull
        final String pattern;

        public ClassFilterException(String message, PatternSyntaxException ex) {
            this(message, ex, ex.getPattern());
        }

        public ClassFilterException(String message, @CheckForNull String pattern) {
            this(message, new IllegalStateException(message), pattern);
        }

        public ClassFilterException(String message, Throwable cause, @CheckForNull String pattern) {
            super(message, cause);
            this.pattern = pattern;
        }

        @CheckForNull
        public String getPattern() {
            return this.pattern;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + ". Pattern: " + this.pattern;
        }
    }
}

