/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.protocol.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.jenkinsci.remoting.protocol.FilterLayer;
import org.jenkinsci.remoting.protocol.impl.ConnectionRefusalException;
import org.jenkinsci.remoting.util.ByteBufferUtils;
import org.jenkinsci.remoting.util.ThrowableUtils;

public class SSLEngineFilterLayer
extends FilterLayer {
    private static final Logger LOGGER = Logger.getLogger(SSLEngineFilterLayer.class.getName());
    @NonNull
    private final SSLEngine sslEngine;
    @CheckForNull
    private final Listener listener;
    private final Object wrapLock = new Object();
    @NonNull
    private State state = State.CREDENTIALS_NOT_YET_AVAILABLE;
    @NonNull
    private final ConcurrentLinkedQueue<ByteBuffer> messages = new ConcurrentLinkedQueue();
    @CheckForNull
    private ByteBuffer previous;
    private final AtomicReference<ByteBuffer> directBufferRef = new AtomicReference();

    public SSLEngineFilterLayer(@NonNull SSLEngine engine, @CheckForNull Listener listener) {
        this.sslEngine = engine;
        this.listener = listener;
        this.previous = null;
    }

    @Override
    public void start() throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "{0} Starting {1}", new Object[]{this.stack().name(), this.sslEngine.getHandshakeStatus()});
        }
        this.sslEngine.beginHandshake();
        this.onRecv(EMPTY_BUFFER);
    }

    @Override
    public void onRecv(@NonNull ByteBuffer readBuffer) throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "[{0}] RECV: {1} bytes plus {2} retained", new Object[]{this.stack().name(), readBuffer.remaining(), this.previous == null ? 0 : this.previous.remaining()});
        }
        try {
            this.processRead(readBuffer);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            while (cause instanceof RuntimeException) {
                cause = cause.getCause();
            }
            if (cause instanceof GeneralSecurityException) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "[" + this.stack().name() + "] ", e);
                }
                this.abort(new IOException(cause));
            }
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "[" + this.stack().name() + "] ", e);
            }
            throw e;
        }
        catch (SSLException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "[" + this.stack().name() + "] ", e);
            }
            this.abort(e);
        }
        catch (ClosedChannelException | ConnectionRefusalException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "[" + this.stack().name() + "] ", e);
            }
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "[" + this.stack().name() + "] ", e);
            }
            throw e;
        }
    }

    @Override
    public void onRecvClosed(IOException cause) throws IOException {
        if (!this.sslEngine.isInboundDone() && this.isSendOpen()) {
            IOException ioe = null;
            try {
                this.sslEngine.closeInbound();
                this.doSend(EMPTY_BUFFER);
            }
            catch (IOException e) {
                ioe = e;
                throw e;
            }
            finally {
                try {
                    super.onRecvClosed(cause);
                }
                catch (IOException e) {
                    if (ioe != null) {
                        ThrowableUtils.chain(e, ioe);
                    }
                    throw e;
                }
            }
        }
        super.onRecvClosed(cause);
    }

    @Override
    public boolean isRecvOpen() {
        return !this.sslEngine.isInboundDone() && super.isRecvOpen();
    }

    @Override
    public void doSend(@NonNull ByteBuffer message) throws IOException {
        this.messages.add(ByteBufferUtils.duplicate(message));
        if (State.CREDENTAILS_AVAILABLE.equals((Object)this.state)) {
            this.processQueuedWrites();
        }
    }

    @Override
    public void doCloseSend() throws IOException {
        if (!this.sslEngine.isOutboundDone() && this.isSendOpen()) {
            IOException ioe = null;
            try {
                this.sslEngine.closeOutbound();
                this.doSend(EMPTY_BUFFER);
            }
            catch (IOException e) {
                ioe = e;
                throw e;
            }
            finally {
                try {
                    super.doCloseSend();
                }
                catch (IOException e) {
                    if (ioe != null) {
                        ThrowableUtils.chain(e, ioe);
                    }
                    throw e;
                }
            }
        }
        super.doCloseSend();
    }

    @Override
    public boolean isSendOpen() {
        return !this.sslEngine.isOutboundDone() && super.isSendOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueuedWrites() {
        Object object = this.wrapLock;
        synchronized (object) {
            ByteBuffer request;
            while (null != (request = this.messages.poll())) {
                try {
                    this.processWrite(request);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void processHandshakeStarted() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "[{0}] Handshake started", this.stack().name());
        }
    }

    private void processHandshakeCompleted() throws ConnectionRefusalException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "[{0}] Handshake completed", this.stack().name());
        }
        if (this.listener != null) {
            this.listener.onHandshakeCompleted(this.sslEngine.getSession());
        }
    }

    private void switchToNoSecure() {
        block2: {
            try {
                this.state = State.NO_CREDENTIALS;
                this.onRecvClosed(null);
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LogRecord record = new LogRecord(Level.FINE, "[{0}] Could not complete close of read after closure of SSL session");
                record.setParameters(new Object[]{this.stack().name()});
                record.setThrown(e);
                LOGGER.log(record);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRead(@NonNull ByteBuffer readBuffer) throws IOException {
        ByteBuffer tempBuffer = this.previous != null ? (this.previous = ByteBufferUtils.accumulate(readBuffer, this.previous)) : readBuffer;
        boolean done = false;
        ByteBuffer appBuffer = this.stack().acquire(this.sslEngine.getSession().getApplicationBufferSize());
        SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
        while (!done) {
            switch (handshakeStatus) {
                case NEED_UNWRAP: 
                case NOT_HANDSHAKING: 
                case FINISHED: {
                    ((Buffer)appBuffer).clear();
                    if (!tempBuffer.hasRemaining() && handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                        done = true;
                        break;
                    }
                    SSLEngineResult result = this.sslEngine.unwrap(tempBuffer, appBuffer);
                    this.processResult(handshakeStatus, result);
                    switch (result.getStatus()) {
                        case BUFFER_UNDERFLOW: 
                        case CLOSED: {
                            done = true;
                            break;
                        }
                        case BUFFER_OVERFLOW: {
                            int newCapacity = appBuffer.capacity() * 2;
                            this.stack().release(appBuffer);
                            appBuffer = this.stack().acquire(newCapacity);
                            break;
                        }
                        case OK: {
                            if (handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || result.bytesProduced() <= 0) break;
                            ((Buffer)appBuffer).flip();
                            if (LOGGER.isLoggable(Level.FINEST)) {
                                LOGGER.log(Level.FINEST, "[{0}] DECODE: {1} bytes", new Object[]{this.stack().name(), appBuffer.remaining()});
                            }
                            this.next().onRecv(appBuffer);
                            ((Buffer)appBuffer).clear();
                        }
                    }
                    handshakeStatus = this.sslEngine.getHandshakeStatus();
                    break;
                }
                case NEED_TASK: {
                    Runnable task;
                    while ((task = this.sslEngine.getDelegatedTask()) != null) {
                        task.run();
                    }
                    handshakeStatus = this.sslEngine.getHandshakeStatus();
                    break;
                }
                case NEED_WRAP: {
                    SSLEngineResult result;
                    Object object = this.wrapLock;
                    synchronized (object) {
                        ((Buffer)appBuffer).clear();
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.FINEST, "[{0}] HANDSHAKE ENCODE: 0 bytes", this.stack().name());
                        }
                        result = this.sslEngine.wrap(EMPTY_BUFFER, appBuffer);
                        switch (result.getStatus()) {
                            case BUFFER_OVERFLOW: {
                                int newCapacity = appBuffer.capacity() * 2;
                                this.stack().release(appBuffer);
                                appBuffer = this.stack().acquire(newCapacity);
                                break;
                            }
                            case BUFFER_UNDERFLOW: {
                                done = true;
                                break;
                            }
                            case CLOSED: 
                            case OK: {
                                ((Buffer)appBuffer).flip();
                                if (!appBuffer.hasRemaining()) break;
                                if (LOGGER.isLoggable(Level.FINEST)) {
                                    LOGGER.log(Level.FINEST, "[{0}] HANDSHAKE SEND: {1} bytes", new Object[]{this.stack().name(), appBuffer.remaining()});
                                }
                                this.next().doSend(appBuffer);
                            }
                        }
                    }
                    this.processResult(handshakeStatus, result);
                    handshakeStatus = this.sslEngine.getHandshakeStatus();
                }
            }
            if (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) continue;
            this.state = State.CREDENTAILS_AVAILABLE;
        }
        this.stack().release(appBuffer);
        this.previous = tempBuffer.remaining() > 0 ? ByteBufferUtils.duplicate(tempBuffer) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResult(SSLEngineResult.HandshakeStatus sessionStatus, SSLEngineResult operationStatus) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "[{0}] Handshake status: {1} engine result: {2}", new Object[]{this.stack().name(), sessionStatus, operationStatus});
        }
        switch (sessionStatus) {
            case NEED_UNWRAP: 
            case NEED_TASK: 
            case NEED_WRAP: {
                if (operationStatus.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                    Object object = this.wrapLock;
                    synchronized (object) {
                        if (this.state == State.CREDENTIALS_NOT_YET_AVAILABLE) {
                            this.state = State.CREDENTAILS_AVAILABLE;
                            try {
                                this.processHandshakeCompleted();
                            }
                            catch (ConnectionRefusalException e) {
                                this.abort(e);
                                break;
                            }
                        }
                        this.processQueuedWrites();
                    }
                }
                if (operationStatus.getStatus() != SSLEngineResult.Status.CLOSED) break;
                this.switchToNoSecure();
                break;
            }
            case NOT_HANDSHAKING: 
            case FINISHED: {
                if (operationStatus.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK || this.state != State.CREDENTIALS_NOT_YET_AVAILABLE) break;
                this.processHandshakeStarted();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + sessionStatus);
            }
        }
    }

    private void processWrite(@NonNull ByteBuffer message) throws IOException {
        ByteBuffer appBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
        boolean done = false;
        while (!done) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "[{0}] APP ENCODE: {1} bytes", new Object[]{this.stack().name(), message.remaining()});
            }
            SSLEngineResult result = this.sslEngine.wrap(message, appBuffer);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "[{0}] Handshake status: {1} engine result: {2}", new Object[]{this.stack().name(), result.getHandshakeStatus(), result});
            }
            switch (result.getStatus()) {
                case BUFFER_OVERFLOW: {
                    appBuffer = ByteBuffer.allocate(appBuffer.capacity() + 4096);
                    break;
                }
                case CLOSED: {
                    this.switchToNoSecure();
                    done = true;
                    break;
                }
                case BUFFER_UNDERFLOW: 
                case OK: {
                    ((Buffer)appBuffer).flip();
                    boolean bl = done = !message.hasRemaining();
                    if (!appBuffer.hasRemaining()) break;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "[{0}] APP SEND: {1} bytes", new Object[]{this.stack().name(), appBuffer.remaining()});
                    }
                    while (appBuffer.hasRemaining()) {
                        this.next().doSend(appBuffer);
                    }
                    break;
                }
            }
            if (done) continue;
            ((Buffer)appBuffer).clear();
        }
    }

    static enum State {
        CREDENTIALS_NOT_YET_AVAILABLE,
        CREDENTAILS_AVAILABLE,
        NO_CREDENTIALS;

    }

    public static interface Listener {
        public void onHandshakeCompleted(SSLSession var1) throws ConnectionRefusalException;
    }
}

