/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.protocol.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jenkinsci.remoting.protocol.IOHub;
import org.jenkinsci.remoting.protocol.IOHubReadyListener;
import org.jenkinsci.remoting.protocol.IOHubRegistrationCallback;
import org.jenkinsci.remoting.protocol.NetworkLayer;
import org.jenkinsci.remoting.util.ByteBufferQueue;
import org.jenkinsci.remoting.util.IOUtils;

public class NIONetworkLayer
extends NetworkLayer
implements IOHubReadyListener {
    private static final Logger LOGGER = Logger.getLogger(NIONetworkLayer.class.getName());
    private final Lock sendLock = new ReentrantLock();
    private final Lock recvLock = new ReentrantLock();
    private final ByteBufferQueue sendQueue;
    private final ReadableByteChannel in;
    private final WritableByteChannel out;
    private SelectionKey sendKey;
    private SelectionKey recvKey;

    public NIONetworkLayer(IOHub ioHub, ReadableByteChannel in, WritableByteChannel out) {
        super(ioHub);
        if (!(in instanceof SelectableChannel)) {
            throw new IllegalArgumentException("Input channel must be a SelectableChannel");
        }
        if (((SelectableChannel)((Object)in)).isBlocking()) {
            try {
                ((SelectableChannel)((Object)in)).configureBlocking(false);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not configure input channel for non-blocking", e);
            }
        }
        if (!(out instanceof SelectableChannel)) {
            throw new IllegalArgumentException("Output channel must be a SelectableChannel");
        }
        if (((SelectableChannel)((Object)out)).isBlocking()) {
            try {
                ((SelectableChannel)((Object)out)).configureBlocking(false);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not configure output channel for non-blocking", e);
            }
        }
        this.in = in;
        this.out = out;
        this.sendQueue = this.newByteBufferQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void ready(boolean accept, boolean connect, boolean read, boolean write) {
        block54: {
            block52: {
                if (NIONetworkLayer.LOGGER.isLoggable(Level.FINEST)) {
                    NIONetworkLayer.LOGGER.log(Level.FINEST, "{0} - entering ready({1}, {2}, {3}, {4})", new Object[]{Thread.currentThread().getName(), accept, connect, read, write});
                }
                if (read) {
                    this.recvLock.lock();
                    try {
                        if (this.in.isOpen()) {
                            logFinest = NIONetworkLayer.LOGGER.isLoggable(Level.FINEST);
                            recv = this.acquire();
                            try {
                                block34: while (true) {
                                    switch (this.in.read(recv)) {
                                        case -1: {
                                            this.onRecvClosed();
                                            ** break;
lbl15:
                                            // 1 sources

                                            break block52;
                                        }
                                        case 0: {
                                            if (this.recvKey.isValid() && this.in.isOpen()) {
                                                this.getIoHub().addInterestRead(this.recvKey);
                                                ** break;
lbl20:
                                                // 1 sources

                                            } else {
                                                this.recvKey.cancel();
                                                this.onRecvClosed();
                                                ** break;
                                            }
lbl24:
                                            // 1 sources

                                            break block52;
                                        }
                                        default: {
                                            recv.flip();
                                            if (logFinest) {
                                                NIONetworkLayer.LOGGER.log(Level.FINEST, "[{0}] RECV: {1} bytes", new Object[]{this.stack().name(), recv.remaining()});
                                            }
                                            while (recv.hasRemaining()) {
                                                this.onRead(recv);
                                            }
                                            recv.clear();
                                            continue block34;
                                        }
                                    }
                                    break;
                                }
                            }
                            catch (ClosedChannelException e) {
                                this.recvKey.cancel();
                                this.onRecvClosed();
                                break block52;
                            }
                            catch (IOException e) {
                                if (NIONetworkLayer.LOGGER.isLoggable(Level.FINER)) {
                                    record = new LogRecord(Level.FINER, "[{0}] Unexpected I/O exception");
                                    record.setThrown(e);
                                    record.setParameters(new Object[]{this.stack().name()});
                                    NIONetworkLayer.LOGGER.log(record);
                                }
                                this.recvKey.cancel();
                                this.onRecvClosed();
                                break block52;
                            }
                            catch (Throwable t) {
                                block53: {
                                    try {
                                        if (NIONetworkLayer.LOGGER.isLoggable(Level.SEVERE)) {
                                            record = new LogRecord(Level.SEVERE, "[{0}] Uncaught {1}");
                                            record.setThrown(t);
                                            record.setParameters(new Object[]{this.stack().name(), t.getClass().getSimpleName()});
                                            NIONetworkLayer.LOGGER.log(record);
                                        }
                                        break block53;
                                    }
                                    finally {
                                        this.recvKey.cancel();
                                        this.onRecvClosed();
                                    }
                                    {
                                        catch (Throwable var10_19) {
                                            throw var10_19;
                                        }
                                    }
                                }
                                this.release(recv);
                                break block52;
                            }
                            finally {
                                this.release(recv);
                            }
                        }
                        this.onRecvClosed();
                    }
                    finally {
                        this.recvLock.unlock();
                    }
                }
            }
            if (write && this.out.isOpen()) {
                send = this.acquire();
                this.sendLock.lock();
                try {
                    t = this.sendQueue;
                    synchronized (t) {
                        this.sendQueue.get(send);
                        sendHasRemaining = this.sendQueue.hasRemaining();
                    }
                    if (NIONetworkLayer.LOGGER.isLoggable(Level.FINEST)) {
                        NIONetworkLayer.LOGGER.log(Level.FINEST, "[{0}] sendHasRemaining - has remaining: {1}", new Object[]{Thread.currentThread().getName(), sendHasRemaining});
                    }
                    send.flip();
                    try {
                        sentBytes = this.out.write(send);
                        if (NIONetworkLayer.LOGGER.isLoggable(Level.FINEST)) {
                            NIONetworkLayer.LOGGER.log(Level.FINEST, "[{0}] sentBytes - sent {1} bytes", new Object[]{Thread.currentThread().getName(), sentBytes});
                        }
                        if (sentBytes == -1) {
                            this.sendKey.cancel();
                            return;
                        }
                    }
                    catch (ClosedChannelException e) {
                        this.sendKey.cancel();
                        return;
                    }
                    catch (IOException e) {
                        if (NIONetworkLayer.LOGGER.isLoggable(Level.FINER)) {
                            record = new LogRecord(Level.FINER, "[{0}] Unexpected I/O exception");
                            record.setThrown(e);
                            record.setParameters(new Object[]{this.stack().name()});
                            NIONetworkLayer.LOGGER.log(record);
                        }
                        this.sendKey.cancel();
                        this.sendLock.unlock();
                        this.release(send);
                        return;
                    }
                    if (!this.out.isOpen() || !this.sendKey.isValid()) break block54;
                    if (send.hasRemaining()) {
                        var7_16 = this.sendQueue;
                        synchronized (var7_16) {
                            this.sendQueue.unget(send);
                            sendHasRemaining = true;
                        }
                    }
                    if (sendHasRemaining) {
                        this.getIoHub().addInterestWrite(this.sendKey);
                    }
                    break block54;
                    {
                        catch (Throwable var14_23) {
                            throw var14_23;
                        }
                    }
                }
                finally {
                    this.sendLock.unlock();
                    this.release(send);
                }
            }
        }
        if (NIONetworkLayer.LOGGER.isLoggable(Level.FINEST)) {
            NIONetworkLayer.LOGGER.log(Level.FINEST, "{0} - leaving ready(...)", Thread.currentThread().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(@NonNull ByteBuffer data) throws IOException {
        boolean sendHadRemaining;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "[{0}] SEND: {1} bytes", new Object[]{this.stack().name(), data.remaining()});
        }
        if (!data.hasRemaining()) {
            return;
        }
        if (!this.out.isOpen()) {
            throw new ClosedChannelException();
        }
        ByteBufferQueue byteBufferQueue = this.sendQueue;
        synchronized (byteBufferQueue) {
            sendHadRemaining = this.sendQueue.hasRemaining();
            this.sendQueue.put(data);
        }
        if (!sendHadRemaining && this.out.isOpen() && this.sendKey != null && this.sendKey.isValid()) {
            this.getIoHub().addInterestWrite(this.sendKey);
        }
    }

    @Override
    public void doCloseRecv() {
        if (this.in.isOpen()) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "[{0}] Closing RECV", this.stack().name());
            }
            IOUtils.closeQuietly(this.in);
            this.onRecvClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        boolean pendingWrite;
        ByteBufferQueue byteBufferQueue = this.sendQueue;
        synchronized (byteBufferQueue) {
            pendingWrite = this.sendQueue.hasRemaining();
        }
        SelectableChannel in = (SelectableChannel)((Object)this.in);
        SelectableChannel out = (SelectableChannel)((Object)this.out);
        if (in == out) {
            in.configureBlocking(false);
            this.getIoHub().register(in, this, false, false, true, pendingWrite, new RegistrationCallbackImpl(true, true, pendingWrite));
        } else {
            in.configureBlocking(false);
            out.configureBlocking(false);
            this.getIoHub().register(out, this, false, false, false, pendingWrite, new RegistrationCallbackImpl(true, false, pendingWrite));
            this.getIoHub().register(in, this, false, false, true, false, new RegistrationCallbackImpl(false, true, false));
        }
        super.start();
    }

    @Override
    public void doCloseSend() {
        if (this.out.isOpen()) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "[{0}] Closing SEND", this.stack().name());
            }
            IOUtils.closeQuietly(this.out);
        }
    }

    @Override
    public boolean isSendOpen() {
        return this.out.isOpen();
    }

    private class RegistrationCallbackImpl
    implements IOHubRegistrationCallback {
        private final boolean setSendKey;
        private final boolean setRecvKey;
        private final boolean pendingWrite;

        private RegistrationCallbackImpl(boolean setSendKey, boolean setRecvKey, boolean pendingWrite) {
            this.setSendKey = setSendKey;
            this.setRecvKey = setRecvKey;
            this.pendingWrite = pendingWrite;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRegistered(SelectionKey selectionKey) {
            block9: {
                if (this.setRecvKey) {
                    NIONetworkLayer.this.recvKey = selectionKey;
                }
                if (this.setSendKey) {
                    NIONetworkLayer.this.sendLock.lock();
                    try {
                        boolean nowPendingWrite;
                        NIONetworkLayer.this.sendKey = selectionKey;
                        if (this.pendingWrite) break block9;
                        ByteBufferQueue byteBufferQueue = NIONetworkLayer.this.sendQueue;
                        synchronized (byteBufferQueue) {
                            nowPendingWrite = NIONetworkLayer.this.sendQueue.hasRemaining();
                        }
                        if (nowPendingWrite) {
                            NIONetworkLayer.this.sendKey.interestOps(NIONetworkLayer.this.sendKey.interestOps() | 4);
                        }
                    }
                    finally {
                        NIONetworkLayer.this.sendLock.unlock();
                    }
                }
            }
        }

        @Override
        public void onClosedChannel(ClosedChannelException e) {
            NIONetworkLayer.this.onRecvClosed();
        }
    }
}

