/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class URLDeserializationHelper {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    private static boolean AVOID_URL_WRAPPING = Boolean.getBoolean(URLDeserializationHelper.class + ".avoidUrlWrapping");
    private static final SafeURLStreamHandler SAFE_HANDLER = new SafeURLStreamHandler();

    @NonNull
    public static URL wrapIfRequired(@NonNull URL url) throws IOException {
        if (AVOID_URL_WRAPPING) {
            return url;
        }
        if (url.getHost() == null || url.getHost().isEmpty()) {
            return url;
        }
        return new URL(null, url.toString(), SAFE_HANDLER);
    }

    private static class SafeURLStreamHandler
    extends URLStreamHandler {
        private SafeURLStreamHandler() {
        }

        @Override
        @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Used for safely handling URLs, not for opening a connection.")
        protected URLConnection openConnection(URL u, Proxy p) throws IOException {
            return new URL(u.toString()).openConnection(p);
        }

        @Override
        @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Used for safely handling URLs, not for opening a connection.")
        protected URLConnection openConnection(URL u) throws IOException {
            return new URL(u.toString()).openConnection();
        }

        @Override
        protected int hashCode(URL u) {
            return u.toExternalForm().hashCode();
        }

        @Override
        protected boolean equals(URL u1, URL u2) {
            return u1.toExternalForm().equals(u2.toExternalForm());
        }
    }
}

