/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Channel;
import hudson.remoting.Command;
import hudson.remoting.ErrorPropagatingOutputStream;
import hudson.remoting.FastPipedInputStream;
import hudson.remoting.FastPipedOutputStream;
import hudson.remoting.ProxyOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.SerializableOnlyOverRemoting;

public final class Pipe
implements SerializableOnlyOverRemoting,
ErrorPropagatingOutputStream {
    private InputStream in;
    private OutputStream out;
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Pipe.class.getName());

    private Pipe(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    public InputStream getIn() {
        return this.in;
    }

    public OutputStream getOut() {
        return this.out;
    }

    @Override
    public void error(Throwable t) throws IOException {
        if (this.out instanceof ErrorPropagatingOutputStream) {
            ErrorPropagatingOutputStream eo = (ErrorPropagatingOutputStream)((Object)this.out);
            eo.error(t);
        } else {
            this.out.close();
        }
    }

    public static Pipe createRemoteToLocal() {
        return new Pipe(new FastPipedInputStream(), null);
    }

    public static Pipe createLocalToRemote() {
        return new Pipe(null, new ProxyOutputStream());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Channel ch = this.getChannelForSerialization();
        if (this.in != null && this.out == null) {
            FastPipedOutputStream pos = new FastPipedOutputStream((FastPipedInputStream)this.in);
            int oid = ch.internalExport(Object.class, pos, false);
            oos.writeBoolean(true);
            oos.writeInt(oid);
        } else {
            int oid = ch.internalExport(Object.class, this.out, false);
            oos.writeBoolean(false);
            oos.writeInt(oid);
        }
    }

    @SuppressFBWarnings(value={"DESERIALIZATION_GADGET"}, justification="Serializable only over remoting. Class filtering is done through JEP-200.")
    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Channel channel = this.getChannelForSerialization();
        if (ois.readBoolean()) {
            this.in = null;
            this.out = new ProxyOutputStream(channel, ois.readInt());
        } else {
            int oidRos = ois.readInt();
            FastPipedOutputStream pos = new FastPipedOutputStream();
            FastPipedInputStream pis = new FastPipedInputStream(pos);
            int oidPos = channel.internalExport(Object.class, pos, false);
            channel.send(new ConnectCommand(oidRos, oidPos));
            this.out = null;
            this.in = pis;
        }
    }

    private static class ConnectCommand
    extends Command {
        private final int oidRos;
        private final int oidPos;
        static final long serialVersionUID = -9128735897846418140L;

        public ConnectCommand(int oidRos, int oidPos) {
            this.oidRos = oidRos;
            this.oidPos = oidPos;
        }

        @Override
        protected void execute(Channel channel) throws ExecutionException {
            channel.pipeWriter.submit(0, () -> {
                try {
                    ProxyOutputStream ros = (ProxyOutputStream)channel.getExportedObject(this.oidRos);
                    channel.unexport(this.oidRos, this.createdAt);
                    ros.connect(channel, this.oidPos);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Failed to connect to pipe", e);
                }
                catch (ExecutionException ex) {
                    throw new IllegalStateException(ex);
                }
            });
        }

        @Override
        public String toString() {
            return "Pipe.Connect";
        }
    }
}

