/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Channel;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.Checksum;
import hudson.remoting.DaemonThreadFactory;
import hudson.remoting.JarCache;
import hudson.remoting.JarLoader;
import hudson.remoting.NamingThreadFactory;
import hudson.remoting.RequestAbortedException;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class JarCacheSupport
extends JarCache {
    private final ConcurrentMap<Checksum, CompletableFuture<URL>> inprogress = new ConcurrentHashMap<Checksum, CompletableFuture<URL>>();
    private final ExecutorService downloader = JarCacheSupport.newCachingSingleThreadExecutor(new NamingThreadFactory(new DaemonThreadFactory(), JarCacheSupport.class.getSimpleName()));
    private static final Logger LOGGER = Logger.getLogger(JarCacheSupport.class.getName());

    protected abstract URL lookInCache(Channel var1, long var2, long var4) throws IOException, InterruptedException;

    protected abstract URL retrieve(Channel var1, long var2, long var4) throws IOException, InterruptedException;

    private static ExecutorService newCachingSingleThreadExecutor(ThreadFactory threadFactory) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return threadPoolExecutor;
    }

    @Override
    @NonNull
    public CompletableFuture<URL> resolve(@NonNull Channel channel, long sum1, long sum2) throws IOException, InterruptedException {
        URL jar = this.lookInCache(channel, sum1, sum2);
        if (jar != null) {
            return CompletableFuture.completedFuture(jar);
        }
        Checksum key = new Checksum(sum1, sum2);
        return this.inprogress.computeIfAbsent(key, unused -> this.submitDownload(channel, sum1, sum2, key));
    }

    @NonNull
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="API compatibility")
    private CompletableFuture<URL> submitDownload(Channel channel, long sum1, long sum2, Checksum key) {
        CompletableFuture<URL> promise = new CompletableFuture<URL>();
        this.downloader.submit(new DownloadRunnable(channel, sum1, sum2, key, promise));
        return promise;
    }

    protected JarLoader getJarLoader(Channel channel) throws InterruptedException {
        JarLoader jl = channel.getProperty(JarLoader.THEIRS);
        if (jl == null) {
            jl = (JarLoader)channel.waitForRemoteProperty(JarLoader.OURS);
            channel.setProperty(JarLoader.THEIRS, jl);
        }
        return jl;
    }

    private class DownloadRunnable
    implements Runnable {
        final Channel channel;
        final long sum1;
        final long sum2;
        final Checksum key;
        final CompletableFuture<URL> promise;

        public DownloadRunnable(Channel channel, long sum1, long sum2, Checksum key, CompletableFuture<URL> promise) {
            this.channel = channel;
            this.sum1 = sum1;
            this.sum2 = sum2;
            this.key = key;
            this.promise = promise;
        }

        @Override
        public void run() {
            try {
                URL url = JarCacheSupport.this.retrieve(this.channel, this.sum1, this.sum2);
                if (JarCacheSupport.this.inprogress.remove(this.key, this.promise)) {
                    this.promise.complete(url);
                } else {
                    this.promise.completeExceptionally(new IllegalStateException("Download is (unexpectedly) no longer in progress"));
                }
            }
            catch (ChannelClosedException | RequestAbortedException e) {
                this.bailout(e);
            }
            catch (InterruptedException e) {
                this.bailout(e);
                LOGGER.log(Level.WARNING, String.format("Interrupted while resolving a jar %016x%016x", this.sum1, this.sum2), e);
                Thread.currentThread().interrupt();
            }
            catch (Throwable e) {
                if (this.channel.isClosingOrClosed()) {
                    this.bailout(e);
                }
                this.promise.completeExceptionally(e);
                LOGGER.log(Level.WARNING, String.format("Failed to resolve a jar %016x%016x", this.sum1, this.sum2), e);
            }
        }

        private void bailout(Throwable e) {
            JarCacheSupport.this.inprogress.remove(this.key, this.promise);
            this.promise.completeExceptionally(e);
        }
    }
}

