/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import java.nio.ByteBuffer;
import org.jenkinsci.remoting.util.ByteBufferQueue;

public class ChunkHeader {
    public static final int SIZE = 2;

    public static int read(ByteBuffer buf) {
        return ChunkHeader.parse(buf.get(), (int)buf.get());
    }

    public static int peek(ByteBuffer buf) {
        return ChunkHeader.peek(buf, 0);
    }

    public static int peek(ByteBuffer buf, int pos) {
        return ChunkHeader.parse(buf.get(pos), (int)buf.get(pos + 1));
    }

    public static int parse(byte[] buf) {
        return ChunkHeader.parse(buf, 0);
    }

    public static int parse(byte[] buf, int pos) {
        return ChunkHeader.parse(buf[pos], (int)buf[pos + 1]);
    }

    public static int parse(int b1, int b2) {
        return (b1 & 0xFF) << 8 | b2 & 0xFF;
    }

    public static boolean isLast(int header) {
        return (header & 0x8000) == 0;
    }

    public static int length(int header) {
        return header & Short.MAX_VALUE;
    }

    public static void write(ByteBuffer buf, int length, boolean hasMore) {
        buf.put((byte)((hasMore ? 128 : 0) | length >> 8));
        buf.put((byte)length);
    }

    public static void write(ByteBufferQueue buf, int length, boolean hasMore) {
        buf.put((byte)((hasMore ? 128 : 0) | length >> 8));
        buf.put((byte)length);
    }

    public static byte[] pack(int length, boolean hasMore) {
        byte[] header = new byte[]{(byte)((hasMore ? 128 : 0) | length >> 8), (byte)length};
        return header;
    }
}

