/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.swarm.Options;
import hudson.plugins.swarm.RetryException;
import hudson.plugins.swarm.SoftLabelUpdateException;
import hudson.plugins.swarm.SwarmClient;
import hudson.plugins.swarm.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class LabelFileWatcher
implements Runnable {
    private static final Logger logger = Logger.getLogger(LabelFileWatcher.class.getName());
    private static final long LABEL_FILE_WATCHER_INTERVAL_MILLIS = Long.getLong(LabelFileWatcher.class.getName() + ".labelFileWatcherIntervalMillis", TimeUnit.SECONDS.toMillis(30L));
    private boolean isRunning = false;
    private final Options options;
    private final String name;
    private String labels;
    private final String[] args;
    private final URL url;

    public LabelFileWatcher(URL url, Options options, String name, String ... args) throws IOException {
        logger.config("LabelFileWatcher() constructed with: " + options.labelsFile + " and " + String.join((CharSequence)", ", args));
        this.url = url;
        this.options = options;
        this.name = name;
        this.labels = Files.readString(Paths.get(options.labelsFile, new String[0]), StandardCharsets.UTF_8);
        this.args = args;
        logger.config("Labels loaded: " + this.labels);
    }

    private void softLabelUpdate(String sNewLabels) throws SoftLabelUpdateException {
        String msg;
        Document xml;
        logger.log(Level.CONFIG, "NOTICE: " + this.options.labelsFile + " has changed.  Attempting soft label update (no node restart)");
        logger.log(Level.CONFIG, "Getting current labels from controller");
        HttpClient client = SwarmClient.createHttpClient(this.options);
        HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(this.url + "plugin/swarm/getSlaveLabels?name=" + this.name)).GET();
        SwarmClient.addAuthorizationHeader(builder, this.options);
        HttpRequest request = builder.build();
        try {
            HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() != 200) {
                logger.log(Level.CONFIG, "Failed to retrieve labels from controller -- Response code: " + response.statusCode());
                throw new SoftLabelUpdateException("Unable to acquire labels from controller to begin removal process.");
            }
            try {
                xml = XmlUtils.parse(response.body());
            }
            catch (SAXException e) {
                String msg2 = "Invalid XML received from " + this.url;
                logger.log(Level.SEVERE, msg2, e);
                throw new SoftLabelUpdateException(msg2);
            }
        }
        catch (IOException | InterruptedException e) {
            String msg3 = "Exception when reading from " + this.url;
            logger.log(Level.SEVERE, msg3, e);
            throw new SoftLabelUpdateException(msg3);
        }
        String labelStr = SwarmClient.getChildElementString(xml.getDocumentElement(), "labels");
        labelStr = labelStr.replace("swarm", "");
        logger.log(Level.CONFIG, "Labels to be removed: " + labelStr);
        List<String> lLabels = List.of(labelStr.split("\\s+"));
        StringBuilder sb = new StringBuilder();
        for (String s : lLabels) {
            sb.append(s);
            sb.append(" ");
            if (sb.length() <= 1000) continue;
            try {
                SwarmClient.postLabelRemove(this.name, sb.toString(), client, this.options, this.url);
            }
            catch (RetryException | IOException | InterruptedException e) {
                String msg4 = "Exception when removing label from " + this.url;
                logger.log(Level.SEVERE, msg4, e);
                throw new SoftLabelUpdateException(msg4);
            }
            sb = new StringBuilder();
        }
        if (sb.length() > 0) {
            try {
                SwarmClient.postLabelRemove(this.name, sb.toString(), client, this.options, this.url);
            }
            catch (RetryException | IOException | InterruptedException e) {
                msg = "Exception when removing label from " + this.url;
                logger.log(Level.SEVERE, msg, e);
                throw new SoftLabelUpdateException(msg);
            }
        }
        logger.log(Level.CONFIG, "Labels to be added: " + sNewLabels);
        lLabels = List.of(sNewLabels.split("\\s+"));
        sb = new StringBuilder();
        for (String s : lLabels) {
            sb.append(s);
            sb.append(" ");
            if (sb.length() <= 1000) continue;
            try {
                SwarmClient.postLabelAppend(this.name, sb.toString(), client, this.options, this.url);
            }
            catch (RetryException | IOException | InterruptedException e) {
                String msg5 = "Exception when appending label to " + this.url;
                logger.log(Level.SEVERE, msg5, e);
                throw new SoftLabelUpdateException(msg5);
            }
            sb = new StringBuilder();
        }
        if (sb.length() > 0) {
            try {
                SwarmClient.postLabelAppend(this.name, sb.toString(), client, this.options, this.url);
            }
            catch (RetryException | IOException | InterruptedException e) {
                msg = "Exception when appending label to " + this.url;
                logger.log(Level.SEVERE, msg, e);
                throw new SoftLabelUpdateException(msg);
            }
        }
    }

    private void hardLabelUpdate() throws IOException {
        logger.config("NOTICE: " + this.options.labelsFile + " has changed.  Hard node restart attempt initiated.");
        this.isRunning = false;
        String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        try {
            File currentJar = new File(LabelFileWatcher.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (!currentJar.getName().endsWith(".jar")) {
                throw new URISyntaxException(currentJar.getName(), "Doesn't end in .jar");
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add(javaBin);
            if (System.getProperty("java.util.logging.config.file") == null) {
                logger.warning("NOTE:  You do not have a -Djava.util.logging.config.file specified, but your labels file has changed.  You will lose logging for the new client instance. Although the client will continue to work, you will have no logging.");
            } else {
                command.add("-Djava.util.logging.config.file=" + System.getProperty("java.util.logging.config.file"));
            }
            command.add("-jar");
            command.add(currentJar.getPath());
            Collections.addAll(command, this.args);
            String sCommandString = Arrays.toString(command.toArray());
            sCommandString = sCommandString.replaceAll("\n", "").replaceAll("\r", "").replaceAll(",", "");
            logger.config("Invoking: " + sCommandString);
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.start();
            logger.config("New node instance started, ignore subsequent warning.");
        }
        catch (URISyntaxException e) {
            logger.log(Level.SEVERE, "ERROR: LabelFileWatcher unable to determine current running jar. Node failure. URISyntaxException.", e);
        }
    }

    @Override
    @SuppressFBWarnings(value={"DM_EXIT"}, justification="behavior is intentional")
    public void run() {
        this.isRunning = true;
        logger.config("LabelFileWatcher running, monitoring file: " + this.options.labelsFile);
        while (this.isRunning) {
            try {
                logger.log(Level.FINE, String.format("LabelFileWatcher sleeping %d milliseconds", LABEL_FILE_WATCHER_INTERVAL_MILLIS));
                Thread.sleep(LABEL_FILE_WATCHER_INTERVAL_MILLIS);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "LabelFileWatcher InterruptedException occurred.", e);
            }
            try {
                String sTempLabels = Files.readString(Paths.get(this.options.labelsFile, new String[0]), StandardCharsets.UTF_8);
                if (sTempLabels.equalsIgnoreCase(this.labels)) {
                    logger.log(Level.FINEST, "Nothing to do. " + this.options.labelsFile + " has not changed.");
                    continue;
                }
                try {
                    this.softLabelUpdate(sTempLabels);
                    this.labels = Files.readString(Paths.get(this.options.labelsFile, new String[0]), StandardCharsets.UTF_8);
                }
                catch (SoftLabelUpdateException e) {
                    logger.log(Level.WARNING, "WARNING: Normal process, soft label update failed. " + e.getLocalizedMessage() + ", forcing Swarm client restart. This can be disruptive to Jenkins jobs. Check your Swarm client log files to see why this is happening.");
                    this.hardLabelUpdate();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "WARNING: unable to read " + this.options.labelsFile + ", node may not be reporting proper labels to controller.", e);
            }
        }
        logger.warning("LabelFileWatcher no longer running. Shutting down this Swarm client.");
        System.exit(0);
    }
}

