/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.protocol;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.OverrideMustInvoke;
import hudson.remoting.Future;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jcip.annotations.GuardedBy;
import org.jenkinsci.remoting.protocol.IOHubReadyListener;
import org.jenkinsci.remoting.protocol.IOHubRegistrationCallback;
import org.jenkinsci.remoting.protocol.IOHubRegistrationFutureAdapterImpl;
import org.jenkinsci.remoting.util.ByteBufferPool;
import org.jenkinsci.remoting.util.DirectByteBufferPool;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class IOHub
implements Executor,
Closeable,
Runnable,
ByteBufferPool {
    private static final Logger LOGGER = Logger.getLogger(IOHub.class.getName());
    private static final long SELECTOR_WAKEUP_TIMEOUT_MS = Long.getLong(IOHub.class.getName() + ".selectorWakeupTimeout", 1000L);
    private static final AtomicInteger nextId = new AtomicInteger(1);
    private final int _id = nextId.getAndIncrement();
    private final Selector selector;
    private volatile boolean ioHubRunning = true;
    private final Object selectorLockObject = new Object();
    private final Executor executor;
    private final DelayQueue<DelayedRunnable> scheduledTasks = new DelayQueue();
    private final Queue<Runnable> selectorTasks = new ConcurrentLinkedQueue<Runnable>();
    private final Queue<Registration> registrations = new ConcurrentLinkedQueue<Registration>();
    private final Queue<InterestOps> interestOps = new ConcurrentLinkedQueue<InterestOps>();
    private long gen;
    private final ByteBufferPool bufferPool;

    private IOHub(Executor executor) throws IOException {
        this.selector = Selector.open();
        this.executor = executor;
        this.bufferPool = new DirectByteBufferPool(16916, Runtime.getRuntime().availableProcessors() * 4);
    }

    public static IOHub create(Executor executor) throws IOException {
        IOHub result = new IOHub(executor);
        executor.execute(result);
        LOGGER.log(Level.FINE, "Starting an additional Selector wakeup thread. See JENKINS-47965 for more information.");
        executor.execute(new IOHubSelectorWatcher(result));
        return result;
    }

    @Override
    public ByteBuffer acquire(int size) {
        return this.bufferPool.acquire(size);
    }

    @Override
    public void release(ByteBuffer buffer) {
        this.bufferPool.release(buffer);
    }

    @NonNull
    public final Selector getSelector() {
        return this.selector;
    }

    @Override
    @OverrideMustInvoke
    public void execute(@NonNull Runnable task) {
        this.executor.execute(task);
    }

    @OverrideMustInvoke
    public void executeOnSelector(Runnable task) {
        if (task == null) {
            throw new NullPointerException("Task is null");
        }
        if (!this.selector.isOpen()) {
            throw new RejectedExecutionException("IOHub#" + this._id + " Selector is closed");
        }
        try {
            this.selectorTasks.add(task);
        }
        catch (IllegalStateException e) {
            throw new RejectedExecutionException("IOHub#" + this._id + "Selector task list is full", e);
        }
        this.selector.wakeup();
    }

    @OverrideMustInvoke
    public Future<?> executeLater(Runnable task, long delay, TimeUnit units) {
        if (task == null) {
            throw new NullPointerException("Task is null");
        }
        if (!this.selector.isOpen()) {
            throw new RejectedExecutionException("IOHub#" + this._id + " Selector is closed");
        }
        DelayedRunnable future = new DelayedRunnable(task, delay, units);
        this.scheduledTasks.add(future);
        return future;
    }

    @OverrideMustInvoke
    public boolean isOpen() {
        return this.selector.isOpen();
    }

    @Override
    @OverrideMustInvoke
    public void close() throws IOException {
        this.selector.close();
    }

    public final void addInterestAccept(SelectionKey key) {
        this.interestOps.add(new InterestOps(key, 16, 0));
        this.selector.wakeup();
    }

    public final void removeInterestAccept(SelectionKey key) {
        this.interestOps.add(new InterestOps(key, 0, 16));
        this.selector.wakeup();
    }

    public final void addInterestConnect(SelectionKey key) {
        this.interestOps.add(new InterestOps(key, 8, 0));
        this.selector.wakeup();
    }

    public final void removeInterestConnect(SelectionKey key) {
        this.interestOps.add(new InterestOps(key, 0, 8));
        this.selector.wakeup();
    }

    public final void addInterestRead(SelectionKey key) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Scheduling adding OP_READ to {0}", key);
        }
        this.interestOps.add(new InterestOps(key, 1, 0));
        this.selector.wakeup();
    }

    public final void removeInterestRead(SelectionKey key) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Scheduling removing OP_READ to {0}", key);
        }
        this.interestOps.add(new InterestOps(key, 0, 1));
        this.selector.wakeup();
    }

    public final void addInterestWrite(SelectionKey key) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Scheduling adding OP_WRITE to {0}", key);
        }
        this.interestOps.add(new InterestOps(key, 4, 0));
        this.selector.wakeup();
    }

    public final void removeInterestWrite(SelectionKey key) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Scheduling removing OP_WRITE to {0}", key);
        }
        this.interestOps.add(new InterestOps(key, 0, 4));
        this.selector.wakeup();
    }

    public final void register(SelectableChannel channel, IOHubReadyListener listener, boolean accept, boolean connect, boolean read, boolean write, IOHubRegistrationCallback callback) {
        int ops = 0;
        if (accept) {
            ops |= 0x10;
        }
        if (connect) {
            ops |= 8;
        }
        if (read) {
            ops |= 1;
        }
        if (write) {
            ops |= 4;
        }
        this.registrations.add(new Registration(ops, channel, listener, callback));
        this.selector.wakeup();
    }

    public final Future<SelectionKey> register(SelectableChannel channel, IOHubReadyListener listener, boolean accept, boolean connect, boolean read, boolean write) {
        IOHubRegistrationFutureAdapterImpl callback = new IOHubRegistrationFutureAdapterImpl();
        this.register(channel, listener, accept, connect, read, write, callback);
        return callback.getFuture();
    }

    public final void unregister(SelectableChannel channel) {
        SelectionKey selectionKey = channel.keyFor(this.selector);
        if (selectionKey == null) {
            return;
        }
        selectionKey.cancel();
        selectionKey.attach(null);
    }

    private String getThreadNameBase(String executorThreadName) {
        int keySize;
        try {
            keySize = this.selector.keys().size();
        }
        catch (ClosedSelectorException x) {
            keySize = -1;
        }
        return "IOHub#" + this._id + ": Selector[keys:" + keySize + ", gen:" + this.gen + "] / " + executorThreadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Restricted(value={NoExternalUse.class})
    public final void run() {
        block27: {
            Thread selectorThread = Thread.currentThread();
            String oldName = selectorThread.getName();
            long cpuOverheatProtection = System.nanoTime();
            block20: while (true) {
                try {
                    while (this.isOpen()) {
                        selectorThread.setName(this.getThreadNameBase(oldName));
                        try {
                            this.processScheduledTasks();
                            boolean wantSelectNow = this.processRegistrations();
                            wantSelectNow = this.processInterestOps() || wantSelectNow;
                            wantSelectNow = this.processSelectorTasks() || wantSelectNow;
                            int selected = wantSelectNow ? this.selector.selectNow() : this.selector.select();
                            if (selected == 0) continue;
                            Set<SelectionKey> keys = this.selector.selectedKeys();
                            ++this.gen;
                            Iterator<SelectionKey> keyIterator = keys.iterator();
                            while (keyIterator.hasNext()) {
                                SelectionKey key = keyIterator.next();
                                if (key.isValid()) {
                                    try {
                                        int ops = key.readyOps();
                                        key.interestOps(key.interestOps() & ~ops);
                                        IOHubReadyListener listener = (IOHubReadyListener)key.attachment();
                                        if (listener != null) {
                                            this.execute(new OnReady(this._id, key, listener, ops));
                                        }
                                    }
                                    catch (CancelledKeyException cancelledKeyException) {
                                        // empty catch block
                                    }
                                }
                                keyIterator.remove();
                            }
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.WARNING, "Unexpected selector thread exception", e);
                            long sleepNanos = System.nanoTime() - cpuOverheatProtection;
                            if (sleepNanos > 0L) {
                                if (LOGGER.isLoggable(Level.FINEST)) {
                                    LOGGER.log(Level.FINEST, "Sleeping for {0,number}ns to prevent selector thread CPU monopolization!", sleepNanos);
                                }
                                try {
                                    TimeUnit.NANOSECONDS.sleep(sleepNanos);
                                }
                                catch (InterruptedException interruptedException) {
                                    continue;
                                }
                                continue block20;
                            }
                            cpuOverheatProtection = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(100L);
                            Thread.yield();
                        }
                    }
                    break block27;
                }
                catch (ClosedSelectorException closedSelectorException) {
                    selectorThread.setName(oldName);
                    this.ioHubRunning = false;
                    Object object = this.selectorLockObject;
                    synchronized (object) {
                        this.selectorLockObject.notifyAll();
                        break block27;
                    }
                }
                break;
            }
            finally {
                selectorThread.setName(oldName);
                this.ioHubRunning = false;
                Object object = this.selectorLockObject;
                synchronized (object) {
                    this.selectorLockObject.notifyAll();
                }
            }
        }
    }

    private void processScheduledTasks() {
        int tasksWaiting = this.scheduledTasks.size();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "{0} scheduled tasks to process", tasksWaiting);
        }
        if (tasksWaiting > 4) {
            ArrayList scheduledWork = new ArrayList();
            this.scheduledTasks.drainTo(scheduledWork);
            for (DelayedRunnable task : scheduledWork) {
                if (task.isCancelled()) continue;
                this.execute(task);
            }
        } else {
            DelayedRunnable task = (DelayedRunnable)this.scheduledTasks.poll();
            while (task != null) {
                if (!task.isCancelled()) {
                    this.execute(task);
                }
                task = (DelayedRunnable)this.scheduledTasks.poll();
            }
        }
    }

    private boolean processRegistrations() {
        boolean processedSomething = false;
        Registration r = this.registrations.poll();
        while (r != null) {
            try {
                SelectionKey selectionKey = r.channel.register(this.selector, r.ops, r.listener);
                processedSomething = true;
                r.callback.onRegistered(selectionKey);
            }
            catch (ClosedChannelException e) {
                r.callback.onClosedChannel(e);
            }
            r = this.registrations.poll();
        }
        return processedSomething;
    }

    private boolean processInterestOps() {
        boolean processedSomething = false;
        InterestOps ops = this.interestOps.poll();
        while (ops != null) {
            try {
                if (ops.interestOps()) {
                    processedSomething = true;
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
            ops = this.interestOps.poll();
        }
        return processedSomething;
    }

    private boolean processSelectorTasks() {
        boolean processedSomething = false;
        Runnable task = this.selectorTasks.poll();
        while (task != null) {
            processedSomething = true;
            task.run();
            task = this.selectorTasks.poll();
        }
        return processedSomething;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOHub ioHub = (IOHub)o;
        return this._id == ioHub._id;
    }

    public int hashCode() {
        return this._id;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IOHub#");
        sb.append(this._id);
        if (this.selector.isOpen()) {
            sb.append("[open, keys=").append(this.selector.keys().size());
        } else {
            sb.append("[closed");
        }
        sb.append(", gen=").append(this.gen);
        sb.append(']');
        return sb.toString();
    }

    private static class IOHubSelectorWatcher
    implements Runnable {
        private final IOHub iohub;

        public IOHubSelectorWatcher(IOHub iohub) {
            this.iohub = iohub;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread watcherThread = Thread.currentThread();
            String oldName = watcherThread.getName();
            String watcherName = "Windows IOHub Watcher for " + this.iohub.getThreadNameBase(oldName);
            LOGGER.log(Level.FINEST, "{0}: Started", watcherName);
            try {
                watcherThread.setName(watcherName);
                while (true) {
                    Object object = this.iohub.selectorLockObject;
                    synchronized (object) {
                        if (!this.iohub.ioHubRunning) {
                            break;
                        }
                        this.iohub.selectorLockObject.wait(SELECTOR_WAKEUP_TIMEOUT_MS);
                    }
                    this.iohub.selector.wakeup();
                }
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.FINE, "Interrupted", ex);
            }
            finally {
                watcherThread.setName(oldName);
                LOGGER.log(Level.FINEST, "{0}: Finished", watcherName);
            }
        }
    }

    private final class DelayedRunnable
    implements Runnable,
    Delayed,
    Future<Void> {
        @GuardedBy(value="this")
        private Runnable task;
        @GuardedBy(value="this")
        private Throwable failure;
        private final long delayTime;
        @GuardedBy(value="this")
        private boolean done;

        private DelayedRunnable(Runnable task, long delay, TimeUnit unit) {
            this.task = task;
            this.delayTime = System.currentTimeMillis() + unit.toMillis(delay);
        }

        @Override
        public synchronized long getDelay(@NonNull TimeUnit unit) {
            return this.task == null ? Long.MIN_VALUE : unit.convert(this.delayTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public synchronized int compareTo(Delayed o) {
            long x = this.getDelay(TimeUnit.NANOSECONDS);
            long y = o.getDelay(TimeUnit.NANOSECONDS);
            return Long.compare(x, y);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable task;
            DelayedRunnable delayedRunnable = this;
            synchronized (delayedRunnable) {
                task = this.task;
            }
            if (task != null) {
                Thread workerThread = Thread.currentThread();
                String oldName = workerThread.getName();
                try {
                    workerThread.setName(String.format("IOHub#%d: Timeout[%s] / %s", IOHub.this._id, task, oldName));
                    task.run();
                    DelayedRunnable delayedRunnable2 = this;
                    synchronized (delayedRunnable2) {
                        this.done = true;
                        this.notifyAll();
                    }
                }
                catch (Throwable t) {
                    DelayedRunnable delayedRunnable3 = this;
                    synchronized (delayedRunnable3) {
                        this.failure = t;
                        this.done = true;
                        this.notifyAll();
                    }
                }
                finally {
                    workerThread.setName(oldName);
                }
            }
        }

        @Override
        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            if (this.done) {
                return false;
            }
            this.task = null;
            this.notifyAll();
            return true;
        }

        @Override
        public synchronized boolean isCancelled() {
            return this.task == null;
        }

        @Override
        public synchronized boolean isDone() {
            return this.done;
        }

        @Override
        public synchronized Void get() throws InterruptedException, ExecutionException {
            while (!this.done) {
                if (!IOHub.this.isOpen()) {
                    throw new CancellationException("IOHub#" + IOHub.this._id + " Selector is closed");
                }
                if (this.task == null) {
                    throw new CancellationException();
                }
                long remaining = Math.min(30000L, this.delayTime - System.currentTimeMillis());
                this.wait(Math.max(1000L, remaining));
            }
            if (this.failure != null) {
                throw new ExecutionException(this.failure);
            }
            return null;
        }

        @Override
        public synchronized Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long giveUp = System.currentTimeMillis() + unit.toMillis(timeout);
            while (!this.done) {
                if (!IOHub.this.isOpen()) {
                    throw new CancellationException("IOHub#" + IOHub.this._id + " Selector is closed");
                }
                long timeoutin = giveUp - System.currentTimeMillis();
                if (timeoutin <= 0L) {
                    throw new TimeoutException();
                }
                if (this.task == null) {
                    throw new CancellationException();
                }
                long remaining = Math.min(30000L, this.delayTime - System.currentTimeMillis());
                this.wait(Math.min(timeoutin, Math.max(1000L, remaining)));
            }
            if (this.failure != null) {
                throw new ExecutionException(this.failure);
            }
            return null;
        }
    }

    private static final class InterestOps {
        private final SelectionKey key;
        private final int opsAnd;
        private final int opsOr;

        private InterestOps(SelectionKey key, int add, int remove) {
            this.key = key;
            this.opsAnd = ~remove;
            this.opsOr = add;
        }

        private boolean interestOps() {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "updating interest ops &={0} |={1} on {2} with existing ops {3} on key {4}", new Object[]{this.opsAnd, this.opsOr, this.key.channel(), this.key.interestOps(), this.key});
            }
            if (this.key.isValid()) {
                this.key.interestOps(this.key.interestOps() & this.opsAnd | this.opsOr);
                return true;
            }
            return false;
        }
    }

    private static final class Registration {
        private final int ops;
        private final SelectableChannel channel;
        private final IOHubReadyListener listener;
        private final IOHubRegistrationCallback callback;

        Registration(int ops, SelectableChannel channel, IOHubReadyListener listener, IOHubRegistrationCallback callback) {
            this.ops = ops;
            this.channel = channel;
            this.listener = listener;
            this.callback = callback;
        }

        public String toString() {
            return "Registration{ops=" + this.ops + ", channel=" + this.channel + ", listener=" + this.listener + ", callback=" + this.callback + "}";
        }
    }

    private static final class OnReady
    implements Runnable {
        private final int _id;
        private final SelectionKey key;
        private final IOHubReadyListener listener;
        private final int ops;

        OnReady(int _id, SelectionKey key, IOHubReadyListener listener, int ops) {
            this._id = _id;
            this.key = key;
            this.listener = listener;
            this.ops = ops;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread workerThread = Thread.currentThread();
            String oldName = workerThread.getName();
            try {
                workerThread.setName("IOHub#" + this._id + ": Worker[channel:" + this.key.channel() + "] / " + oldName);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Calling listener.ready({0}, {1}, {2}, {3}) for channel {4}", new Object[]{(this.ops & 0x10) == 16, (this.ops & 8) == 8, (this.ops & 1) == 1, (this.ops & 4) == 4, this.key.channel()});
                }
                this.listener.ready((this.ops & 0x10) == 16, (this.ops & 8) == 8, (this.ops & 1) == 1, (this.ops & 4) == 4);
            }
            catch (Throwable e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LogRecord record = new LogRecord(Level.SEVERE, "[{0}] Listener {1} propagated an uncaught {2}");
                    record.setThrown(e);
                    record.setParameters(new Object[]{workerThread.getName(), this.listener, e.getClass().getSimpleName()});
                    LOGGER.log(record);
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
            }
            finally {
                workerThread.setName(oldName);
            }
        }
    }
}

