/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.jenkinsci.remoting.engine.JnlpAgentEndpoint;

public abstract class JnlpEndpointResolver {
    public abstract JnlpAgentEndpoint resolve() throws IOException;

    public abstract void waitForReady() throws InterruptedException;

    protected RSAPublicKey getIdentity(String base64EncodedIdentity) throws InvalidKeySpecException {
        if (base64EncodedIdentity == null) {
            return null;
        }
        try {
            byte[] encodedKey = Base64.getDecoder().decode(base64EncodedIdentity);
            if (encodedKey == null) {
                return null;
            }
            X509EncodedKeySpec spec = new X509EncodedKeySpec(encodedKey);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)kf.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("The Java Language Specification mandates RSA as a supported algorithm.", e);
        }
    }
}

