/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.protocol.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.remoting.AbstractByteBufferCommandTransport;
import hudson.remoting.BinarySafeStream;
import hudson.remoting.Capability;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.ChannelClosedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jenkinsci.remoting.protocol.ApplicationLayer;
import org.jenkinsci.remoting.util.AnonymousClassWarnings;
import org.jenkinsci.remoting.util.ByteBufferUtils;
import org.jenkinsci.remoting.util.SettableFuture;
import org.jenkinsci.remoting.util.ThrowableUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class ChannelApplicationLayer
extends ApplicationLayer<Future<Channel>> {
    private final ExecutorService executorService;
    private final SettableFuture<Channel> futureChannel = SettableFuture.create();
    @Nullable
    private AbstractByteBufferCommandTransport transport;
    @CheckForNull
    private Channel channel;
    private ByteBuffer capabilityLength = ByteBuffer.allocate(2);
    private ByteBuffer capabilityContent;
    private final Listener listener;
    private String cookie;

    public ChannelApplicationLayer(@NonNull ExecutorService executorService, @CheckForNull Listener listener) {
        this.executorService = executorService;
        this.listener = listener;
    }

    @Restricted(value={NoExternalUse.class})
    public ChannelApplicationLayer(@NonNull ExecutorService executorService, @CheckForNull Listener listener, String cookie) {
        this.executorService = executorService;
        this.listener = listener;
        this.cookie = cookie;
    }

    @Override
    public Future<Channel> get() {
        return this.futureChannel;
    }

    @Override
    public boolean isReadOpen() {
        return this.channel == null || !this.channel.isInClosed();
    }

    @Override
    public void onRead(@NonNull ByteBuffer data) throws IOException {
        if (!this.futureChannel.isDone()) {
            assert (this.channel == null && this.transport == null && this.capabilityLength != null);
            if (this.capabilityLength.hasRemaining()) {
                ByteBufferUtils.put(data, this.capabilityLength);
                if (this.capabilityLength.hasRemaining()) {
                    return;
                }
                this.capabilityContent = ByteBuffer.allocate(((this.capabilityLength.get(0) & 0xFF) << 8) + (this.capabilityLength.get(1) & 0xFF));
            }
            assert (this.capabilityContent != null);
            if (this.capabilityContent.hasRemaining()) {
                ByteBufferUtils.put(data, this.capabilityContent);
                if (this.capabilityContent.hasRemaining()) {
                    return;
                }
                byte[] capabilityBytes = new byte[this.capabilityContent.capacity()];
                ((Buffer)this.capabilityContent).flip();
                this.capabilityContent.get(capabilityBytes);
                if (this.capabilityContent.hasRemaining()) {
                    return;
                }
                Capability remoteCapability = Capability.read(new ByteArrayInputStream(capabilityBytes));
                this.transport = new ByteBufferCommandTransport(remoteCapability);
                try {
                    ChannelBuilder builder = new ChannelBuilder(this.stack().name(), this.executorService).withMode(Channel.Mode.BINARY);
                    this.channel = this.listener instanceof ChannelDecorator ? this.decorate(((ChannelDecorator)this.listener).decorate(builder)).build(this.transport) : this.decorate(builder).build(this.transport);
                }
                catch (IOException e) {
                    try {
                        this.doCloseWrite();
                    }
                    catch (IOException suppressed) {
                        ThrowableUtils.chain(e, suppressed);
                    }
                    this.transport = null;
                    this.futureChannel.setException(e);
                    throw e;
                }
                if (this.cookie != null) {
                    Objects.requireNonNull(this.channel).setProperty("JnlpAgentProtocol.cookie", this.cookie);
                }
                this.futureChannel.set(this.channel);
                this.capabilityContent = null;
                this.capabilityLength = null;
                if (this.listener != null) {
                    this.listener.onChannel(this.channel);
                }
            }
        }
        if (this.channel == null) {
            assert (this.futureChannel.isDone());
            try {
                this.channel = this.futureChannel.get();
            }
            catch (InterruptedException e) {
                InterruptedIOException ie = new InterruptedIOException();
                ie.bytesTransferred = data.remaining();
                ((Buffer)data).position(data.limit());
                Thread.currentThread().interrupt();
                throw ie;
            }
            catch (ExecutionException e) {
                ((Buffer)data).position(data.limit());
                throw new IOException(e);
            }
        }
        assert (this.channel != null && this.transport != null) : "If futureChannel.isDone() then we have a channel and transport";
        try {
            this.transport.receive(data);
        }
        catch (IOException e) {
            this.channel.terminate(e);
            ((Buffer)data).position(data.limit());
            throw e;
        }
        catch (InterruptedException e) {
            InterruptedIOException reason = new InterruptedIOException();
            reason.bytesTransferred = data.remaining();
            this.channel.terminate(reason);
            ((Buffer)data).position(data.limit());
            Thread.currentThread().interrupt();
            throw reason;
        }
    }

    @Override
    public void onReadClosed(IOException cause) {
        if (this.futureChannel.isDone()) {
            if (this.channel != null) {
                this.channel.terminate(cause == null ? new ClosedChannelException() : cause);
            }
        } else {
            this.futureChannel.setException(cause == null ? new ClosedChannelException() : cause);
        }
    }

    @Override
    public void start() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = AnonymousClassWarnings.checkingObjectOutputStream(BinarySafeStream.wrap(bos));){
                oos.writeObject(new Capability());
            }
            ByteBuffer buffer = ByteBufferUtils.wrapUTF8(bos.toString(StandardCharsets.US_ASCII));
            this.write(buffer);
        }
        catch (IOException e) {
            this.futureChannel.setException(e);
        }
    }

    public ChannelBuilder decorate(ChannelBuilder builder) {
        return builder;
    }

    private class ByteBufferCommandTransport
    extends AbstractByteBufferCommandTransport {
        private final Capability remoteCapability;

        public ByteBufferCommandTransport(Capability remoteCapability) {
            super(true);
            this.remoteCapability = remoteCapability;
        }

        @Override
        protected void write(ByteBuffer headerAndData) throws IOException {
            if (ChannelApplicationLayer.this.isWriteOpen()) {
                try {
                    ChannelApplicationLayer.this.write(headerAndData);
                }
                catch (ClosedChannelException e) {
                    throw new ChannelClosedException(null, "Protocol stack cannot write data anymore. ChannelApplicationLayer reports that the NIO Channel is closed", e);
                }
            } else {
                throw new ChannelClosedException(null, "Protocol stack cannot write data anymore. It is not open for write", null);
            }
        }

        @Override
        public void closeWrite() throws IOException {
            ChannelApplicationLayer.this.doCloseWrite();
        }

        @Override
        public void closeRead() throws IOException {
            ChannelApplicationLayer.this.doCloseRead();
        }

        @Override
        public Capability getRemoteCapability() {
            return this.remoteCapability;
        }
    }

    public static interface ChannelDecorator
    extends Listener {
        @NonNull
        public ChannelBuilder decorate(@NonNull ChannelBuilder var1);
    }

    public static interface Listener {
        public void onChannel(@NonNull Channel var1);
    }
}

