/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.remoting.Channel;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.jenkinsci.remoting.engine.JnlpClientDatabase;
import org.jenkinsci.remoting.engine.JnlpConnectionState;
import org.jenkinsci.remoting.engine.JnlpConnectionStateListener;

public abstract class JnlpProtocolHandler<STATE extends JnlpConnectionState> {
    @CheckForNull
    private final JnlpClientDatabase clientDatabase;
    private final boolean preferNio;

    JnlpProtocolHandler(@Nullable JnlpClientDatabase clientDatabase, boolean preferNio) {
        this.clientDatabase = clientDatabase;
        this.preferNio = preferNio;
    }

    @CheckForNull
    public JnlpClientDatabase getClientDatabase() {
        return this.clientDatabase;
    }

    public boolean isPreferNio() {
        return this.preferNio;
    }

    public abstract String getName();

    public boolean isEnabled() {
        return !Boolean.getBoolean("org.jenkinsci.remoting.engine." + this.getClass().getSimpleName().replace("Handler", ".disabled"));
    }

    @NonNull
    protected abstract STATE createConnectionState(@NonNull Socket var1, @NonNull List<? extends JnlpConnectionStateListener> var2) throws IOException;

    @NonNull
    public final Future<Channel> handle(@NonNull Socket socket, @NonNull Map<String, String> headers, JnlpConnectionStateListener ... listeners) throws IOException {
        return this.handle(socket, headers, Arrays.asList(listeners));
    }

    @NonNull
    public abstract Future<Channel> handle(@NonNull Socket var1, @NonNull Map<String, String> var2, @NonNull List<? extends JnlpConnectionStateListener> var3) throws IOException;

    @NonNull
    public final Future<Channel> connect(@NonNull Socket socket, @NonNull Map<String, String> headers, JnlpConnectionStateListener ... listeners) throws IOException {
        return this.connect(socket, headers, Arrays.asList(listeners));
    }

    @NonNull
    public abstract Future<Channel> connect(@NonNull Socket var1, @NonNull Map<String, String> var2, @NonNull List<? extends JnlpConnectionStateListener> var3) throws IOException;
}

