/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jenkinsci.remoting.engine.JnlpAgentEndpointResolver;
import org.jenkinsci.remoting.util.KeyUtils;
import org.jenkinsci.remoting.util.ThrowableUtils;

public class JnlpAgentEndpoint {
    @NonNull
    private final String host;
    private final int port;
    @CheckForNull
    private final RSAPublicKey publicKey;
    @CheckForNull
    private final Set<String> protocols;
    @CheckForNull
    private final URL serviceUrl;
    @CheckForNull
    private final String proxyCredentials;

    @Deprecated
    public JnlpAgentEndpoint(@NonNull String host, int port, @CheckForNull RSAPublicKey publicKey, @CheckForNull Set<String> protocols) {
        this(host, port, publicKey, protocols, null, null);
    }

    @Deprecated
    public JnlpAgentEndpoint(@NonNull String host, int port, @CheckForNull RSAPublicKey publicKey, @CheckForNull Set<String> protocols, @CheckForNull URL serviceURL) {
        this(host, port, publicKey, protocols, serviceURL, null);
    }

    public JnlpAgentEndpoint(@NonNull String host, int port, @CheckForNull RSAPublicKey publicKey, @CheckForNull Set<String> protocols, @CheckForNull URL serviceURL, @CheckForNull String proxyCredentials) {
        if (port <= 0 || 65536 <= port) {
            throw new IllegalArgumentException("Port " + port + " is not in the range 1-65535");
        }
        this.host = host;
        this.port = port;
        this.publicKey = publicKey;
        this.protocols = protocols == null || protocols.isEmpty() ? null : Collections.unmodifiableSet(new LinkedHashSet<String>(protocols));
        this.serviceUrl = serviceURL;
        this.proxyCredentials = proxyCredentials;
    }

    @NonNull
    public InetSocketAddress getAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    @CheckForNull
    public URL getServiceUrl() {
        return this.serviceUrl;
    }

    @NonNull
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @CheckForNull
    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    @CheckForNull
    public Set<String> getProtocols() {
        return this.protocols;
    }

    public boolean isProtocolSupported(@NonNull String name) {
        return this.protocols == null || this.protocols.contains(name);
    }

    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="Unsafe endline symbol is a pert of the protocol. Unsafe to fix it. See TODO below")
    public Socket open(int socketTimeout) throws IOException {
        boolean isHttpProxy = false;
        InetSocketAddress targetAddress = null;
        AbstractInterruptibleChannel channel = null;
        try {
            targetAddress = JnlpAgentEndpointResolver.getResolvedHttpProxyAddress(this.host, this.port);
            if (targetAddress == null) {
                targetAddress = new InetSocketAddress(this.host, this.port);
            } else {
                isHttpProxy = true;
            }
            channel = SocketChannel.open(targetAddress);
            Socket socket = ((SocketChannel)channel).socket();
            socket.setTcpNoDelay(true);
            socket.setSoTimeout(socketTimeout);
            if (isHttpProxy) {
                Object connectCommand = String.format("CONNECT %s:%s HTTP/1.1\r\nHost: %s\r\n", this.host, this.port, this.host);
                if (this.proxyCredentials != null) {
                    String encoding = Base64.getEncoder().encodeToString(this.proxyCredentials.getBytes(StandardCharsets.UTF_8));
                    connectCommand = (String)connectCommand + "Proxy-Authorization: Basic " + encoding + "\r\n";
                }
                connectCommand = (String)connectCommand + "\r\n";
                socket.getOutputStream().write(((String)connectCommand).getBytes(StandardCharsets.UTF_8));
                BufferedInputStream is = new BufferedInputStream(socket.getInputStream());
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
                String line = reader.readLine();
                if (line == null) {
                    throw new IOException("Proxy socket closed");
                }
                String[] responseLineParts = line.trim().split(" ");
                if (responseLineParts.length < 2 || !responseLineParts[1].equals("200")) {
                    throw new IOException("Got a bad response from proxy: " + line);
                }
                while ((line = reader.readLine()) != null && !line.trim().isEmpty()) {
                }
            }
            return socket;
        }
        catch (IOException e) {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException suppressed) {
                    e = (IOException)ThrowableUtils.chain(e, suppressed);
                }
            }
            Object suffix = "";
            if (isHttpProxy) {
                suffix = " through proxy " + targetAddress;
            }
            throw new IOException("Failed to connect to " + this.host + ":" + this.port + (String)suffix, e);
        }
    }

    public int hashCode() {
        return this.host.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JnlpAgentEndpoint that = (JnlpAgentEndpoint)o;
        if (this.port != that.port) {
            return false;
        }
        if (!KeyUtils.equals(this.publicKey, that.publicKey)) {
            return false;
        }
        if (!Objects.equals(this.protocols, that.protocols)) {
            return false;
        }
        if (this.host.equals(that.host)) {
            return true;
        }
        InetAddress thisAddr = this.getAddress().getAddress();
        InetAddress thatAddr = that.getAddress().getAddress();
        if (!thisAddr.getClass().equals(thatAddr.getClass())) {
            return false;
        }
        if (thisAddr.isAnyLocalAddress()) {
            return thatAddr.isLinkLocalAddress() || thatAddr.isLoopbackAddress() || thatAddr.isAnyLocalAddress();
        }
        if (thatAddr.isAnyLocalAddress()) {
            return thisAddr.isLinkLocalAddress() || thisAddr.isLoopbackAddress();
        }
        return false;
    }

    public String toString() {
        return "JnlpAgentEndpoint{host=" + this.host + ", port=" + this.port + ", publicKey=" + KeyUtils.fingerprint(this.publicKey) + ", protocols=" + this.protocols + "}";
    }
}

