/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.NoProxyEvaluator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Enumeration;
import java.util.jar.Manifest;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.jenkinsci.remoting.util.PathUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class Util {
    static String getBaseName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    static byte[] readFully(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Util.copy(in, baos);
        return baos.toByteArray();
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        try (InputStream inputStream = in;){
            int len;
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
    }

    @NonNull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="This path exists within a temp directory so the potential traversal is limited.")
    static File makeResource(String name, byte[] image) throws IOException {
        Path tmpDir = Files.createTempDirectory("resource-", new FileAttribute[0]);
        File resource = new File(tmpDir.toFile(), name);
        Files.createDirectories(PathUtils.fileToPath(resource.getParentFile()), new FileAttribute[0]);
        Files.createFile(PathUtils.fileToPath(resource), new FileAttribute[0]);
        try (FileOutputStream fos = new FileOutputStream(resource);){
            fos.write(image);
        }
        Util.deleteDirectoryOnExit(tmpDir.toFile());
        return resource;
    }

    static void deleteDirectoryOnExit(File dir) {
        File[] childFiles;
        dir.deleteOnExit();
        if (dir.isDirectory() && (childFiles = dir.listFiles()) != null) {
            for (File f : childFiles) {
                Util.deleteDirectoryOnExit(f);
            }
        }
    }

    static String indent(String s) {
        return "    " + s.trim().replace("\n", "\n    ");
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Used for retrieving the connection info from the server. We should cleanup the other, unused references.")
    static URLConnection openURLConnection(URL url, String credentials, String proxyCredentials, SSLSocketFactory sslSocketFactory) throws IOException {
        String encoding;
        URLConnection con;
        String httpProxy = null;
        if (System.getProperty("http.proxyHost") == null) {
            httpProxy = System.getenv("http_proxy");
        }
        if (httpProxy != null && "http".equals(url.getProtocol()) && NoProxyEvaluator.shouldProxy(url.getHost())) {
            try {
                URL proxyUrl = new URL(httpProxy);
                InetSocketAddress addr = new InetSocketAddress(proxyUrl.getHost(), proxyUrl.getPort());
                Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
                con = url.openConnection(proxy);
            }
            catch (MalformedURLException e) {
                System.err.println("Not use http_proxy property or environment variable which is invalid: " + e.getMessage());
                con = url.openConnection();
            }
        } else {
            con = url.openConnection();
        }
        if (credentials != null) {
            encoding = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
            con.setRequestProperty("Authorization", "Basic " + encoding);
        }
        if (proxyCredentials != null) {
            encoding = Base64.getEncoder().encodeToString(proxyCredentials.getBytes(StandardCharsets.UTF_8));
            con.setRequestProperty("Proxy-Authorization", "Basic " + encoding);
        }
        if (con instanceof HttpsURLConnection && sslSocketFactory != null) {
            ((HttpsURLConnection)con).setSSLSocketFactory(sslSocketFactory);
        }
        return con;
    }

    static URLConnection openURLConnection(URL url, String credentials, String proxyCredentials) throws IOException {
        return Util.openURLConnection(url, credentials, proxyCredentials, null);
    }

    static URLConnection openURLConnection(URL url) throws IOException {
        return Util.openURLConnection(url, null, null, null);
    }

    @Deprecated
    static void mkdirs(@NonNull File file) throws IOException {
        if (file.isDirectory()) {
            return;
        }
        Files.createDirectories(PathUtils.fileToPath(file), new FileAttribute[0]);
    }

    public static String getVersion() {
        String version = "unknown";
        try {
            Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resEnum.hasMoreElements()) {
                URL url = resEnum.nextElement();
                InputStream is = url.openStream();
                try {
                    Manifest manifest;
                    if (is == null || (version = (manifest = new Manifest(is)).getMainAttributes().getValue("Version")) == null) continue;
                    break;
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            System.out.println("Could not access manifest");
        }
        return version;
    }
}

