/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.jenkinsci.remoting.engine.ChannelCiphers;
import org.jenkinsci.remoting.engine.EngineUtil;
import org.jenkinsci.remoting.engine.HandshakeCiphers;
import org.jenkinsci.remoting.engine.Jnlp3ConnectionState;
import org.jenkinsci.remoting.engine.Jnlp3Util;
import org.jenkinsci.remoting.engine.JnlpClientDatabase;
import org.jenkinsci.remoting.engine.JnlpConnectionStateListener;
import org.jenkinsci.remoting.engine.LegacyJnlpProtocolHandler;
import org.jenkinsci.remoting.nio.NioChannelHub;
import org.jenkinsci.remoting.protocol.impl.ConnectionRefusalException;
import org.jenkinsci.remoting.util.Charsets;

@Deprecated
public class JnlpProtocol3Handler
extends LegacyJnlpProtocolHandler<Jnlp3ConnectionState> {
    private static final Logger LOGGER = Logger.getLogger(JnlpProtocol3Handler.class.getName());
    private static final Random RANDOM = new SecureRandom();
    static final String COOKIE_NAME = "org.jenkinsci.remoting.engine.JnlpProtocol3.cookie";
    public static final String CHALLENGE_KEY = "Challenge";
    static final String NEGOTIATE_LINE = "Negotiate";
    static final String NAME = "JNLP3-connect";

    public JnlpProtocol3Handler(@Nullable JnlpClientDatabase clientDatabase, @Nonnull ExecutorService threadPool, @Nullable NioChannelHub hub, boolean preferNio) {
        super(clientDatabase, threadPool, hub, preferNio);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    @Nonnull
    public Jnlp3ConnectionState createConnectionState(@Nonnull Socket socket, @Nonnull List<? extends JnlpConnectionStateListener> listeners) throws IOException {
        return new Jnlp3ConnectionState(socket, listeners);
    }

    @Override
    void sendHandshake(@Nonnull Jnlp3ConnectionState state, @Nonnull Map<String, String> headers) throws IOException {
        int challengeResponseLength;
        String secretKey = headers.get("Secret-Key");
        if (secretKey == null) {
            throw new ConnectionRefusalException("Client headers missing Secret-Key");
        }
        String clientName = headers.get("Node-Name");
        if (clientName == null) {
            throw new ConnectionRefusalException("Client headers missing Node-Name");
        }
        String cookie = headers.get("Cookie");
        HandshakeCiphers handshakeCiphers = HandshakeCiphers.create(clientName, secretKey);
        String challenge = Jnlp3Util.generateChallenge(RANDOM);
        Properties props = new Properties();
        props.put("Node-Name", clientName);
        props.put(CHALLENGE_KEY, handshakeCiphers.encrypt(challenge));
        if (cookie != null) {
            props.put("Cookie", handshakeCiphers.encrypt(cookie));
        }
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        props.store(o, null);
        state.fireBeforeProperties();
        DataOutputStream outputStream = state.getDataOutputStream();
        outputStream.writeUTF("Protocol:JNLP3-connect");
        outputStream.writeUTF(o.toString("UTF-8"));
        outputStream.flush();
        InputStream inputStream = state.getSocketInputStream();
        String protocolUnderstoodResponse = EngineUtil.readLine(inputStream);
        if (!protocolUnderstoodResponse.equals(NEGOTIATE_LINE)) {
            throw new ConnectionRefusalException("Server didn't accept the handshake: " + protocolUnderstoodResponse);
        }
        try {
            challengeResponseLength = Integer.parseInt(EngineUtil.readLine(inputStream));
        }
        catch (NumberFormatException e) {
            throw new ConnectionRefusalException("JNLP3-connect: Incorrect challenge response from master");
        }
        String encryptedChallengeResponse = EngineUtil.readChars(inputStream, challengeResponseLength);
        String challengeResponse = handshakeCiphers.decrypt(encryptedChallengeResponse);
        if (!Jnlp3Util.validateChallengeResponse(challenge, challengeResponse)) {
            throw new ConnectionRefusalException("JNLP3-connect: Incorrect challenge response from master");
        }
        outputStream.writeUTF("Welcome");
        outputStream.flush();
        Integer challengeLength = Integer.parseInt(EngineUtil.readLine(inputStream));
        String encryptedChallenge = EngineUtil.readChars(inputStream, challengeLength);
        String masterChallenge = handshakeCiphers.decrypt(encryptedChallenge);
        challengeResponse = Jnlp3Util.createChallengeResponse(masterChallenge);
        encryptedChallengeResponse = handshakeCiphers.encrypt(challengeResponse);
        outputStream.writeUTF(encryptedChallengeResponse);
        outputStream.flush();
        String masterResponse = EngineUtil.readLine(inputStream);
        if (!"Welcome".equals(masterResponse)) {
            throw new ConnectionRefusalException("JNLP3-connect: Master rejected connection: " + masterResponse);
        }
        ChannelCiphers channelCiphers = ChannelCiphers.create(RANDOM);
        outputStream.writeUTF(handshakeCiphers.encrypt(Jnlp3Util.keyToString(channelCiphers.getAesKey())));
        outputStream.writeUTF(handshakeCiphers.encrypt(Jnlp3Util.keyToString(channelCiphers.getSpecKey())));
        outputStream.flush();
        state.setChannelCiphers(channelCiphers);
        cookie = handshakeCiphers.decrypt(EngineUtil.readLine(inputStream));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("Cookie", cookie);
        state.fireAfterProperties(properties);
    }

    @Override
    void receiveHandshake(@Nonnull Jnlp3ConnectionState state, @Nonnull Map<String, String> headers) throws IOException {
        PrintWriter out = state.getPrintWriter();
        out.println(NEGOTIATE_LINE);
        Properties request = new Properties();
        DataInputStream in = state.getDataInputStream();
        request.load(new ByteArrayInputStream(in.readUTF().getBytes(Charsets.UTF_8)));
        String clientName = request.getProperty("Node-Name");
        JnlpClientDatabase clientDatabase = this.getClientDatabase();
        if (clientDatabase == null || !clientDatabase.exists(clientName)) {
            throw new ConnectionRefusalException("Unknown client name: " + clientName);
        }
        String secretKey = clientDatabase.getSecretOf(clientName);
        if (secretKey == null) {
            throw new ConnectionRefusalException("Unknown client name: " + clientName);
        }
        HandshakeCiphers handshakeCiphers = HandshakeCiphers.create(clientName, secretKey);
        String challenge = handshakeCiphers.decrypt(request.getProperty(CHALLENGE_KEY));
        String challengeResponse = Jnlp3Util.createChallengeResponse(challenge);
        String encryptedChallengeResponse = handshakeCiphers.encrypt(challengeResponse);
        out.println(encryptedChallengeResponse.getBytes(Charsets.UTF_8).length);
        out.print(encryptedChallengeResponse);
        out.flush();
        String challengeVerificationMessage = null;
        try {
            challengeVerificationMessage = in.readUTF();
        }
        catch (EOFException e) {
            throw new ConnectionRefusalException("Agent did not accept our challenge response");
        }
        if (!challengeVerificationMessage.equals("Welcome")) {
            throw new ConnectionRefusalException("Agent did not accept our challenge response");
        }
        state.fireBeforeProperties();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(request);
        if (properties.get("Cookie") != null) {
            properties.put("Cookie", handshakeCiphers.decrypt((String)properties.get("Cookie")));
        }
        String masterChallenge = Jnlp3Util.generateChallenge(RANDOM);
        String encryptedMasterChallenge = handshakeCiphers.encrypt(masterChallenge);
        out.println(encryptedMasterChallenge.getBytes(Charsets.UTF_8).length);
        out.print(encryptedMasterChallenge);
        out.flush();
        String encryptedMasterChallengeResponse = in.readUTF();
        String masterChallengeResponse = handshakeCiphers.decrypt(encryptedMasterChallengeResponse);
        if (!Jnlp3Util.validateChallengeResponse(masterChallenge, masterChallengeResponse)) {
            LOGGER.log(Level.WARNING, "An attempt was made to connect as {0} from {1} with an incorrect secret", new Object[]{clientName, state.getSocket().getRemoteSocketAddress()});
            throw new ConnectionRefusalException("Incorrect master challenge response from agent");
        }
        state.fireAfterProperties(properties);
        out.println("Welcome");
        String newCookie = null;
        String encryptedCookie = null;
        for (int loopCount = 0; loopCount < 110; ++loopCount) {
            if (loopCount >= 100) {
                throw new IOException("JENKINS-37140 got really unlucky with the random number generator");
            }
            newCookie = this.generateCookie();
            encryptedCookie = handshakeCiphers.encrypt(newCookie);
            if (encryptedCookie.indexOf(10) == -1 || Character.isWhitespace(encryptedCookie.charAt(0)) || Character.isWhitespace(encryptedCookie.charAt(encryptedCookie.length() - 1))) break;
        }
        state.setNewCookie(newCookie);
        out.println(encryptedCookie);
        out.flush();
        String aesKeyString = handshakeCiphers.decrypt(in.readUTF());
        String specKeyString = handshakeCiphers.decrypt(in.readUTF());
        state.setChannelCiphers(ChannelCiphers.create(Jnlp3Util.keyFromString(aesKeyString), Jnlp3Util.keyFromString(specKeyString)));
    }

    private String generateCookie() {
        byte[] cookie = new byte[32];
        RANDOM.nextBytes(cookie);
        return JnlpProtocol3Handler.toHexString(cookie);
    }

    @Nonnull
    private static String toHexString(@Nonnull byte[] bytes) {
        StringBuilder buf = new StringBuilder();
        for (byte bb : bytes) {
            buf.append(Character.forDigit(bb >> 4 & 0xF, 16));
            buf.append(Character.forDigit(bb & 0xF, 16));
        }
        return buf.toString();
    }

    @Override
    @Nonnull
    Channel buildChannel(@Nonnull Jnlp3ConnectionState state) throws IOException {
        ChannelBuilder channelBuilder = state.getChannelBuilder();
        String newCookie = state.getNewCookie();
        if (newCookie != null) {
            channelBuilder.withProperty(COOKIE_NAME, newCookie);
        }
        return channelBuilder.build(new CipherInputStream(state.getSocketInputStream(), state.getChannelCiphers().getDecryptCipher()), new CipherOutputStream(state.getSocketOutputStream(), state.getChannelCiphers().getEncryptCipher()));
    }
}

