/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ExecutorServiceUtils {
    private ExecutorServiceUtils() {
    }

    @Nonnull
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="User of this API explicitly submits the task in the async mode on his own risk")
    public static void submitAsync(@Nonnull ExecutorService es, @Nonnull Runnable runnable) throws ExecutionRejectedException {
        try {
            es.submit(runnable);
        }
        catch (RejectedExecutionException ex) {
            throw new ExecutionRejectedException(runnable, es, ex);
        }
    }

    @Nonnull
    public static RejectedExecutionException createRuntimeException(@Nonnull String message, @Nonnull ExecutionRejectedException cause) {
        if (cause.isFatal()) {
            return new FatalRejectedExecutionException(message, cause);
        }
        return new RejectedExecutionException(message, cause);
    }

    @Restricted(value={NoExternalUse.class})
    public static class ExecutionRejectedException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final String executorServiceDisplayName;
        private final String runnableDisplayName;
        private final boolean fatal;

        public ExecutionRejectedException(Runnable runnable, ExecutorService es, String message, boolean fatal) {
            super(message);
            this.executorServiceDisplayName = es.toString();
            this.runnableDisplayName = es.toString();
            this.fatal = fatal;
        }

        public ExecutionRejectedException(Runnable runnable, ExecutorService es, RejectedExecutionException cause) {
            super(cause);
            this.executorServiceDisplayName = es.toString();
            this.runnableDisplayName = es.toString();
            this.fatal = cause instanceof FatalRejectedExecutionException;
        }

        public String getExecutorServiceDisplayName() {
            return this.executorServiceDisplayName;
        }

        public String getRunnableDisplayName() {
            return this.runnableDisplayName;
        }

        public boolean isFatal() {
            return this.fatal;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class FatalRejectedExecutionException
    extends RejectedExecutionException {
        private static final long serialVersionUID = 1L;

        public FatalRejectedExecutionException(String message) {
            super(message);
        }

        public FatalRejectedExecutionException(String message, Throwable cause) {
            super(message, cause);
        }

        public FatalRejectedExecutionException(Throwable cause) {
            super(cause);
        }
    }
}

