/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.TeeOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.remoting.util.PathUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class WorkDirManager {
    private static final Logger LOGGER = Logger.getLogger(WorkDirManager.class.getName());
    private static WorkDirManager INSTANCE = new WorkDirManager();
    public static final boolean DEFAULT_FAIL_IF_WORKDIR_IS_MISSING = false;
    public static final String SUPPORTED_INTERNAL_DIR_NAME_MASK = "[a-zA-Z0-9._-]*";
    public static final String JUL_CONFIG_FILE_SYSTEM_PROPERTY_NAME = "java.util.logging.config.file";
    boolean loggingInitialized;
    @CheckForNull
    private File loggingConfigFile = null;
    private final Set<DirType> disabledDirectories = new HashSet<DirType>();
    private final Map<DirType, File> directories = new HashMap<DirType, File>();

    private WorkDirManager() {
    }

    @Nonnull
    public static WorkDirManager getInstance() {
        return INSTANCE;
    }

    static void reset() {
        INSTANCE = new WorkDirManager();
        LogManager.getLogManager().reset();
    }

    public void disable(@Nonnull DirType dir) {
        this.disabledDirectories.add(dir);
    }

    @CheckForNull
    public File getLocation(@Nonnull DirType type) {
        return this.directories.get((Object)type);
    }

    @CheckForNull
    public Path getLocationPath(@Nonnull DirType type) throws IOException {
        File location = this.directories.get((Object)type);
        return location != null ? PathUtils.fileToPath(location) : null;
    }

    public void setLoggingConfig(@Nonnull File configFile) {
        this.loggingConfigFile = configFile;
    }

    @CheckForNull
    public File getLoggingConfigFile() {
        if (this.loggingConfigFile != null) {
            return this.loggingConfigFile;
        }
        String property = System.getProperty(JUL_CONFIG_FILE_SYSTEM_PROPERTY_NAME);
        if (property != null && !property.trim().isEmpty()) {
            return new File(property);
        }
        return null;
    }

    @CheckForNull
    public Path initializeWorkDir(@CheckForNull File workDir, @Nonnull String internalDir, boolean failIfMissing) throws IOException {
        if (!internalDir.matches(SUPPORTED_INTERNAL_DIR_NAME_MASK)) {
            throw new IOException(String.format("Name of %s ('%s') is not compliant with the required format: %s", new Object[]{DirType.INTERNAL_DIR, internalDir, SUPPORTED_INTERNAL_DIR_NAME_MASK}));
        }
        if (workDir == null) {
            return null;
        }
        WorkDirManager.verifyDirectory(workDir, DirType.WORK_DIR, failIfMissing);
        this.directories.put(DirType.WORK_DIR, workDir);
        File internalDirFile = new File(workDir, internalDir);
        WorkDirManager.verifyDirectory(internalDirFile, DirType.INTERNAL_DIR, failIfMissing);
        this.directories.put(DirType.INTERNAL_DIR, internalDirFile);
        Path internalDirPath = PathUtils.fileToPath(internalDirFile);
        Files.createDirectories(internalDirPath, new FileAttribute[0]);
        LOGGER.log(Level.INFO, "Using {0} as a remoting work directory", internalDirPath);
        this.createInternalDirIfRequired(internalDirFile, DirType.JAR_CACHE_DIR);
        this.createInternalDirIfRequired(internalDirFile, DirType.LOGS_DIR);
        return internalDirPath;
    }

    private void createInternalDirIfRequired(File internalDir, DirType type) throws IOException {
        if (!this.disabledDirectories.contains((Object)type)) {
            File directory = new File(internalDir, type.getDefaultLocation());
            WorkDirManager.verifyDirectory(directory, type, false);
            Files.createDirectories(PathUtils.fileToPath(directory), new FileAttribute[0]);
            this.directories.put(type, directory);
        } else {
            LOGGER.log(Level.FINE, "Skipping the disabled directory: {0}", type.getName());
        }
    }

    private static void verifyDirectory(@Nonnull File dir, @Nonnull DirType type, boolean failIfMissing) throws IOException {
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new IOException("The specified " + (Object)((Object)type) + " path points to a non-directory file: " + dir.getPath());
            }
            if (!(dir.canWrite() && dir.canRead() && dir.canExecute())) {
                throw new IOException("The specified " + (Object)((Object)type) + " should be fully accessible to the remoting executable (RWX): " + dir.getPath());
            }
        } else if (failIfMissing) {
            throw new IOException("The " + (Object)((Object)type) + " is missing, but it is expected to exist: " + dir.getPath());
        }
    }

    public void setupLogging(@CheckForNull Path internalDirPath, @CheckForNull Path overrideLogPath) throws IOException {
        if (this.loggingInitialized) {
            LOGGER.log(Level.CONFIG, "Logging susystem has been already initialized");
            return;
        }
        File configFile = this.getLoggingConfigFile();
        if (configFile != null) {
            LOGGER.log(Level.FINE, "Reading Logging configuration from file: {0}", configFile);
            try (FileInputStream fis = new FileInputStream(configFile);){
                LogManager.getLogManager().readConfiguration(fis);
            }
        }
        if (overrideLogPath != null) {
            LOGGER.log(Level.INFO, "Using {0} as an agent error log destination; output log will not be generated", overrideLogPath);
            System.out.flush();
            System.err.flush();
            System.setErr(this.legacyCreateTeeStream(System.err, overrideLogPath));
            this.loggingInitialized = true;
        } else if (internalDirPath != null) {
            LOGGER.log(Level.INFO, "Both error and output logs will be printed to {0}", internalDirPath);
            System.out.flush();
            System.err.flush();
            File internalDirFile = internalDirPath.toFile();
            this.createInternalDirIfRequired(internalDirFile, DirType.LOGS_DIR);
            File logsDir = this.getLocation(DirType.LOGS_DIR);
            if (configFile == null) {
                Logger rootLogger = Logger.getLogger("");
                File julLog = new File(logsDir, "remoting.log");
                FileHandler logHandler = new FileHandler(julLog.getAbsolutePath(), 0xA00000, 5, false);
                logHandler.setFormatter(new SimpleFormatter());
                logHandler.setLevel(Level.INFO);
                rootLogger.addHandler(logHandler);
            }
            this.loggingInitialized = true;
        }
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="It is a legacy logging mode. Relying on the default is not fine, but it just behaves as it used to behave for years")
    private PrintStream legacyCreateTeeStream(OutputStream ostream, Path destination) throws FileNotFoundException {
        return new PrintStream(new TeeOutputStream(ostream, new FileOutputStream(destination.toFile())));
    }

    @Restricted(value={NoExternalUse.class})
    public static enum DirType {
        WORK_DIR("working directory", "", null),
        INTERNAL_DIR("remoting internal directory", "remoting", WORK_DIR),
        JAR_CACHE_DIR("JAR Cache directory", "jarCache", INTERNAL_DIR),
        LOGS_DIR("Log directory", "logs", INTERNAL_DIR);

        @Nonnull
        private final String name;
        @Nonnull
        private final String defaultLocation;
        @CheckForNull
        private final DirType parentDir;

        private DirType(@CheckForNull String name, String defaultLocation, DirType parentDir) {
            this.name = name;
            this.defaultLocation = defaultLocation;
            this.parentDir = parentDir;
        }

        public String toString() {
            return this.name;
        }

        @Nonnull
        public String getDefaultLocation() {
            return this.defaultLocation;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @CheckForNull
        public DirType getParentDir() {
            return this.parentDir;
        }
    }
}

