/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Channel;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.Command;
import hudson.remoting.PipeWindow;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;

final class ProxyWriter
extends Writer {
    @GuardedBy(value="this")
    private Channel channel;
    private int oid;
    private PipeWindow window;
    private CharArrayWriter tmp;
    @CheckForNull
    private Throwable closeCause;
    private volatile boolean channelReleased;
    private static final Logger LOGGER = Logger.getLogger(ProxyWriter.class.getName());

    public ProxyWriter() {
    }

    public ProxyWriter(@Nonnull Channel channel, int oid) throws IOException {
        this.connect(channel, oid);
    }

    synchronized void connect(@Nonnull Channel channel, int oid) throws IOException {
        if (this.channel != null) {
            throw new IllegalStateException("Cannot connect twice");
        }
        if (oid == 0) {
            throw new IllegalArgumentException("oid=0");
        }
        this.channel = channel;
        this.oid = oid;
        this.window = channel.getPipeWindow(oid);
        if (this.tmp != null) {
            char[] b = this.tmp.toCharArray();
            this.tmp = null;
            this._write(b, 0, b.length);
        }
        if (this.closeCause != null) {
            this.close();
        }
    }

    @Override
    public void write(int c) throws IOException {
        this.write(new char[]{(char)c}, 0, 1);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.closeCause != null) {
            throw new IOException("stream is already closed");
        }
        this._write(cbuf, off, len);
    }

    private synchronized void _write(char[] cbuf, int off, int len) throws IOException {
        if (this.channel == null) {
            if (this.tmp == null) {
                this.tmp = new CharArrayWriter();
            }
            this.tmp.write(cbuf);
        } else {
            int max = this.window.max();
            while (len > 0) {
                int sendable;
                try {
                    sendable = Math.min(this.window.get(Math.min(max / 10, len)), len);
                    sendable = Math.min(sendable, max / 2);
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException().initCause(e);
                }
                this.channel.send(new Chunk(this.channel.newIoId(), this.oid, cbuf, off, sendable));
                this.window.decrease(sendable);
                off += sendable;
                len -= sendable;
            }
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.channel != null && this.channel.remoteCapability.supportsProxyWriter2_35()) {
            this.channel.send(new Flush(this.channel.newIoId(), this.oid));
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.error(null);
    }

    @CheckForNull
    public Throwable getCloseCause() {
        return this.closeCause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(@CheckForNull Throwable cause) throws IOException {
        Throwable terminationCause;
        Throwable throwable = terminationCause = cause != null ? cause : new IOException("ProxyWriter close has been requested");
        if (this.channelReleased) {
            if (LOGGER.isLoggable(Level.FINE)) {
                IOException ex;
                if (this.closeCause != null) {
                    ex = new IOException("Writer is already closed", this.closeCause);
                    ex.addSuppressed(terminationCause);
                } else {
                    ex = new IOException("Writer is already closed", terminationCause);
                }
                LOGGER.log(Level.FINE, "Trying to close the already closed writer", ex);
            }
            return;
        }
        if (this.closeCause == null) {
            this.closeCause = terminationCause;
        }
        ProxyWriter proxyWriter = this;
        synchronized (proxyWriter) {
            if (this.channel != null) {
                this.channel.send(new EOF(this.channel.newIoId(), this.oid));
                this.channel = null;
                this.channelReleased = true;
                this.oid = -1;
            }
        }
    }

    @SuppressFBWarnings(value={"FI_FINALIZER_NULLS_FIELDS"}, justification="As designed")
    protected synchronized void finalize() throws Throwable {
        super.finalize();
        if (this.channel != null) {
            if (this.channel.remoteCapability.supportsProxyWriter2_35()) {
                this.channel.send(new Unexport(this.channel.newIoId(), this.oid));
            } else {
                this.channel.send(new EOF(this.channel.newIoId(), this.oid));
            }
            this.channel = null;
            this.oid = -1;
        }
    }

    private static final class NotifyDeadWriter
    extends Command {
        private final int oid;
        private static final long serialVersionUID = 1L;

        private NotifyDeadWriter(Channel channel, Throwable cause, int oid) {
            super(channel, cause);
            this.oid = oid;
        }

        @Override
        protected void execute(Channel channel) {
            PipeWindow w = channel.getPipeWindow(this.oid);
            w.dead(this.createdAt != null ? this.createdAt.getCause() : null);
        }

        @Override
        public String toString() {
            return "ProxyWriter.Dead(" + this.oid + ")";
        }
    }

    private static class Ack
    extends Command {
        private final int oid;
        private final int size;
        private static final long serialVersionUID = 1L;

        private Ack(int oid, int size) {
            super(false);
            this.oid = oid;
            this.size = size;
        }

        @Override
        protected void execute(Channel channel) {
            PipeWindow w = channel.getPipeWindow(this.oid);
            w.increase(this.size);
        }

        @Override
        public String toString() {
            return "ProxyWriter.Ack(" + this.oid + ',' + this.size + ")";
        }
    }

    private static final class EOF
    extends Command {
        private final int oid;
        private final int ioId;
        private static final long serialVersionUID = 1L;

        public EOF(int ioId, int oid) {
            this.ioId = ioId;
            this.oid = oid;
        }

        @Override
        protected void execute(final Channel channel) {
            final Writer os = (Writer)channel.getExportedObjectOrNull(this.oid);
            if (os == null) {
                LOGGER.log(Level.FINE, "ProxyWriter with oid=%s has been already unexported", this.oid);
                return;
            }
            channel.pipeWriter.submit(this.ioId, new Runnable(){

                @Override
                public void run() {
                    channel.unexport(oid, createdAt, false);
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public String toString() {
            return "ProxyWriter.EOF(" + this.oid + ")";
        }
    }

    private static class Unexport
    extends Command {
        private final int oid;
        private final int ioId;
        private static final long serialVersionUID = 1L;

        public Unexport(int ioId, int oid) {
            this.ioId = ioId;
            this.oid = oid;
        }

        @Override
        protected void execute(final Channel channel) {
            channel.pipeWriter.submit(this.ioId, new Runnable(){

                @Override
                public void run() {
                    channel.unexport(oid, createdAt, false);
                }
            });
        }

        @Override
        public String toString() {
            return "ProxyWriter.Unexport(" + this.oid + ")";
        }
    }

    private static final class Flush
    extends Command {
        private final int oid;
        private final int ioId;
        private static final long serialVersionUID = 1L;

        public Flush(int ioId, int oid) {
            super(false);
            this.ioId = ioId;
            this.oid = oid;
        }

        @Override
        protected void execute(Channel channel) throws ExecutionException {
            final Writer os = (Writer)channel.getExportedObject(this.oid);
            channel.pipeWriter.submit(this.ioId, new Runnable(){

                @Override
                public void run() {
                    try {
                        os.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public String toString() {
            return "ProxyWriter.Flush(" + this.oid + ")";
        }
    }

    private static final class Chunk
    extends Command {
        private final int ioId;
        private final int oid;
        private final char[] buf;
        private static final long serialVersionUID = 1L;

        public Chunk(int ioId, int oid, char[] buf, int start, int len) {
            super(false);
            this.ioId = ioId;
            this.oid = oid;
            if (start == 0 && len == buf.length) {
                this.buf = buf;
            } else {
                this.buf = new char[len];
                System.arraycopy(buf, start, this.buf, 0, len);
            }
        }

        @Override
        protected void execute(final Channel channel) throws ExecutionException {
            final Writer os = (Writer)channel.getExportedObject(this.oid);
            channel.pipeWriter.submit(this.ioId, new Runnable(){

                @Override
                public void run() {
                    try {
                        os.write(buf);
                    }
                    catch (IOException e) {
                        try {
                            if (channel.remoteCapability.supportsProxyWriter2_35()) {
                                channel.send(new NotifyDeadWriter(channel, e, oid));
                            }
                        }
                        catch (ChannelClosedException channelClosedException) {
                        }
                        catch (IOException x) {
                            LOGGER.log(Level.WARNING, "Failed to notify the sender that the write end is dead", x);
                            LOGGER.log(Level.WARNING, "... the failed write was:", e);
                        }
                    }
                    finally {
                        if (channel.remoteCapability.supportsProxyWriter2_35()) {
                            try {
                                channel.send(new Ack(oid, buf.length));
                            }
                            catch (ChannelClosedException e) {
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.WARNING, "Failed to ack the stream", e);
                            }
                        }
                    }
                }
            });
        }

        @Override
        public String toString() {
            return "ProxyWriter.Chunk(" + this.oid + "," + this.buf.length + ")";
        }
    }
}

