/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.jenkinsci.remoting.util.ListenableFuture;

public final class SettableFuture<V>
implements ListenableFuture<V> {
    private static final Logger LOGGER = Logger.getLogger(SettableFuture.class.getName());
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private boolean done;
    @GuardedBy(value="lock")
    private boolean cancelled;
    @Nullable
    @GuardedBy(value="lock")
    private V value;
    @CheckForNull
    @GuardedBy(value="lock")
    private Throwable throwable;
    private final Queue<Map.Entry<Runnable, Executor>> listeners = new LinkedList<Map.Entry<Runnable, Executor>>();
    @GuardedBy(value="listeners")
    private boolean notified;

    public static <V> SettableFuture<V> create() {
        return new SettableFuture<V>();
    }

    private SettableFuture() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(@Nullable V value) {
        boolean result;
        Object object = this.lock;
        synchronized (object) {
            if (this.done) {
                result = false;
            } else {
                this.done = true;
                this.value = value;
                this.lock.notifyAll();
                result = true;
            }
        }
        if (result) {
            this.notifyListeners();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setException(@Nonnull Throwable throwable) {
        boolean result;
        SettableFuture.verifyNonnull(throwable);
        Object object = this.lock;
        synchronized (object) {
            if (this.done) {
                result = false;
            } else {
                this.done = true;
                this.throwable = throwable;
                this.lock.notifyAll();
                result = true;
            }
        }
        if (result) {
            this.notifyListeners();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean result;
        Object object = this.lock;
        synchronized (object) {
            if (this.done) {
                result = false;
            } else {
                this.done = true;
                this.cancelled = true;
                this.lock.notifyAll();
                result = true;
            }
        }
        if (result) {
            this.notifyListeners();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.lock;
        synchronized (object) {
            return this.done && this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.done;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get() throws InterruptedException, ExecutionException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.done) {
                this.lock.wait();
            }
            if (this.cancelled) {
                throw new CancellationException();
            }
            if (this.throwable != null) {
                throw new ExecutionException(this.throwable);
            }
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeoutNanos = unit.toNanos(timeout);
        long start = System.nanoTime();
        Object object = this.lock;
        synchronized (object) {
            while (!this.done) {
                long elapsed = System.nanoTime() - start;
                if (elapsed > timeoutNanos) {
                    throw new TimeoutException();
                }
                long remaining = timeoutNanos - elapsed;
                this.lock.wait(remaining / 1000000L, (int)(remaining % 1000000L));
            }
            if (this.cancelled) {
                throw new CancellationException();
            }
            if (this.throwable != null) {
                throw new ExecutionException(this.throwable);
            }
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(@Nonnull Runnable listener, @Nonnull Executor executor) {
        SettableFuture.verifyNonnull(listener);
        SettableFuture.verifyNonnull(executor);
        boolean executeImmediate = false;
        Queue<Map.Entry<Runnable, Executor>> queue = this.listeners;
        synchronized (queue) {
            if (!this.notified) {
                this.listeners.add(new AbstractMap.SimpleImmutableEntry<Runnable, Executor>(listener, executor));
            } else {
                executeImmediate = true;
            }
        }
        if (executeImmediate) {
            try {
                executor.execute(listener);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, "RuntimeException while executing runnable " + listener + " with executor " + executor, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        Queue<Map.Entry<Runnable, Executor>> queue = this.listeners;
        synchronized (queue) {
            if (this.notified) {
                return;
            }
            this.notified = true;
        }
        while (!this.listeners.isEmpty()) {
            Map.Entry<Runnable, Executor> entry = this.listeners.poll();
            try {
                entry.getValue().execute(entry.getKey());
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, "RuntimeException while executing runnable " + entry.getKey() + " with executor " + entry.getValue(), e);
            }
        }
    }

    @SuppressFBWarnings
    private static void verifyNonnull(@Nullable Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }
}

